/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.process.UnixProcessManager;
import com.intellij.ide.actions.CreateDesktopEntryAction;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Restarter {
    private Restarter() {
    }

    public static boolean isSupported() {
        if (SystemInfo.isWindows) {
            return JnaLoader.isLoaded() && new File(PathManager.getBinPath(), "restarter.exe").exists();
        }
        if (SystemInfo.isMac) {
            return PathManager.getHomePath().contains(".app") && new File(PathManager.getBinPath(), "restarter").canExecute();
        }
        if (SystemInfo.isUnix) {
            return UnixProcessManager.getCurrentProcessId() > 0 && CreateDesktopEntryAction.getLauncherScript() != null && new File(PathManager.getBinPath(), "restart.py").canExecute();
        }
        return false;
    }

    public static void scheduleRestart(String ... beforeRestart) throws IOException {
        if (beforeRestart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeRestart", "com/intellij/util/Restarter", "scheduleRestart"));
        }
        if (SystemInfo.isWindows) {
            Restarter.restartOnWindows(beforeRestart);
        } else if (SystemInfo.isMac) {
            Restarter.restartOnMac(beforeRestart);
        } else if (SystemInfo.isUnix) {
            Restarter.restartOnUnix(beforeRestart);
        } else {
            throw new IOException("Cannot restart application: not supported.");
        }
    }

    private static void restartOnWindows(String ... beforeRestart) throws IOException {
        Kernel32 kernel32 = (Kernel32)Native.loadLibrary((String)"kernel32", Kernel32.class);
        Shell32 shell32 = (Shell32)Native.loadLibrary((String)"shell32", Shell32.class);
        int pid = kernel32.GetCurrentProcessId();
        IntByReference argc = new IntByReference();
        Pointer argv_ptr = shell32.CommandLineToArgvW(kernel32.GetCommandLineW(), argc);
        String[] argv = Restarter.getRestartArgv(argv_ptr.getWideStringArray(0L, argc.getValue()));
        kernel32.LocalFree(argv_ptr);
        char[] buffer = new char[Short.MAX_VALUE];
        if (kernel32.GetModuleFileNameW(null, buffer, new WinDef.DWORD((long)buffer.length)).intValue() > 0) {
            argv[0] = Native.toString((char[])buffer);
        }
        Restarter.doScheduleRestart(new File(PathManager.getBinPath(), "restarter.exe"), (Consumer<List<String>>)((Consumer)commands -> {
            Collections.addAll(commands, String.valueOf(pid), String.valueOf(beforeRestart.length));
            Collections.addAll(commands, beforeRestart);
            Collections.addAll(commands, String.valueOf(argv.length));
            Collections.addAll(commands, argv);
        }));
        TimeoutUtil.sleep((long)500L);
    }

    private static String[] getRestartArgv(String[] argv) {
        int countArgs = argv.length;
        for (int i2 = argv.length - 1; i2 >= 0; --i2) {
            if (!argv[i2].endsWith("com.intellij.idea.Main") && !argv[i2].endsWith(".exe")) continue;
            countArgs = i2 + 1;
            if (!argv[i2].endsWith(".exe") || argv[i2].indexOf(File.separatorChar) >= 0) break;
            argv[i2] = new File(PathManager.getBinPath(), argv[i2]).getPath();
            break;
        }
        String[] restartArg = new String[countArgs];
        System.arraycopy(argv, 0, restartArg, 0, countArgs);
        return restartArg;
    }

    private static void restartOnMac(String ... beforeRestart) throws IOException {
        String homePath = PathManager.getHomePath();
        int p = homePath.indexOf(".app");
        if (p < 0) {
            throw new IOException("Application bundle not found: " + homePath);
        }
        String bundlePath = homePath.substring(0, p + 4);
        Restarter.doScheduleRestart(new File(PathManager.getBinPath(), "restarter"), (Consumer<List<String>>)((Consumer)commands -> {
            commands.add(bundlePath);
            Collections.addAll(commands, beforeRestart);
        }));
    }

    private static void restartOnUnix(String ... beforeRestart) throws IOException {
        String launcherScript = CreateDesktopEntryAction.getLauncherScript();
        if (launcherScript == null) {
            throw new IOException("Launcher script not found in " + PathManager.getBinPath());
        }
        int pid = UnixProcessManager.getCurrentProcessId();
        if (pid <= 0) {
            throw new IOException("Invalid process ID: " + pid);
        }
        Restarter.doScheduleRestart(new File(PathManager.getBinPath(), "restart.py"), (Consumer<List<String>>)((Consumer)commands -> {
            commands.add(String.valueOf(pid));
            commands.add(launcherScript);
            Collections.addAll(commands, beforeRestart);
        }));
    }

    private static void doScheduleRestart(File restarterFile, Consumer<List<String>> argumentsBuilder) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(Restarter.createTempExecutable(restarterFile).getPath());
        argumentsBuilder.consume(commands);
        Runtime.getRuntime().exec(ArrayUtil.toStringArray(commands));
    }

    @NotNull
    public static File createTempExecutable(@NotNull File executable) throws IOException {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/intellij/util/Restarter", "createTempExecutable"));
        }
        File tempDir = new File(PathManager.getSystemPath(), "restart");
        if (!FileUtilRt.createDirectory((File)tempDir)) {
            throw new IOException("Cannot create directory: " + tempDir);
        }
        File copy = new File(tempDir, executable.getName());
        if (!FileUtilRt.ensureCanCreateFile((File)copy) || copy.exists() && !copy.delete()) {
            String prefix = FileUtilRt.getNameWithoutExtension((String)copy.getName());
            String ext = FileUtilRt.getExtension((String)executable.getName());
            String suffix = StringUtil.isEmptyOrSpaces((String)ext) ? ".tmp" : "." + ext;
            copy = FileUtilRt.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)false);
        }
        FileUtilRt.copy((File)executable, (File)copy);
        if (executable.canExecute() && !copy.setExecutable(true)) {
            throw new IOException("Cannot make file executable: " + copy);
        }
        File file2 = copy;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Restarter", "createTempExecutable"));
        }
        return file2;
    }

    private static interface Shell32
    extends StdCallLibrary {
        public Pointer CommandLineToArgvW(WString var1, IntByReference var2);
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public int GetCurrentProcessId();

        public WString GetCommandLineW();

        public Pointer LocalFree(Pointer var1);

        public WinDef.DWORD GetModuleFileNameW(WinDef.HMODULE var1, char[] var2, WinDef.DWORD var3);
    }
}

