/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogStorage;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.TroveUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CompressedRefs {
    @NotNull
    private final VcsLogStorage myHashMap;
    @NotNull
    private final TIntObjectHashMap<TIntArrayList> myTags;
    @NotNull
    private final TIntObjectHashMap<SmartList<VcsRef>> myBranches;

    public CompressedRefs(@NotNull Set<VcsRef> refs, @NotNull VcsLogStorage hashMap) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/CompressedRefs", "<init>"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/CompressedRefs", "<init>"));
        }
        this.myHashMap = hashMap;
        this.myTags = new TIntObjectHashMap();
        this.myBranches = new TIntObjectHashMap();
        Ref root = new Ref();
        refs.forEach(ref -> {
            assert (root.get() == null || ((VirtualFile)root.get()).equals(ref.getRoot())) : "All references are supposed to be from the single root";
            root.set((Object)ref.getRoot());
            if (ref.getType().isBranch()) {
                CompressedRefs.putRef(this.myBranches, ref, this.myHashMap);
            } else {
                CompressedRefs.putRefIndex(this.myTags, ref, this.myHashMap);
            }
        });
        this.myHashMap.flush();
    }

    @NotNull
    public SmartList<VcsRef> refsToCommit(int index) {
        TIntArrayList tags;
        SmartList result2 = new SmartList();
        if (this.myBranches.containsKey(index)) {
            result2.addAll((Collection)this.myBranches.get(index));
        }
        if ((tags = (TIntArrayList)this.myTags.get(index)) != null) {
            tags.forEach(value -> {
                result2.add((Object)this.myHashMap.getVcsRef(value));
                return true;
            });
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "refsToCommit"));
        }
        return smartList;
    }

    @NotNull
    public Stream<VcsRef> streamBranches() {
        Stream<VcsRef> stream = TroveUtil.streamValues(this.myBranches).flatMap(Collection::stream);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "streamBranches"));
        }
        return stream;
    }

    @NotNull
    private Stream<VcsRef> streamTags() {
        Stream<VcsRef> stream = TroveUtil.streamValues(this.myTags).flatMapToInt(TroveUtil::stream).mapToObj(this.myHashMap::getVcsRef);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "streamTags"));
        }
        return stream;
    }

    @NotNull
    public Stream<VcsRef> stream() {
        Stream<VcsRef> stream = Stream.concat(this.streamBranches(), this.streamTags());
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "stream"));
        }
        return stream;
    }

    @NotNull
    public Collection<VcsRef> getRefs() {
        AbstractCollection<VcsRef> abstractCollection = new AbstractCollection<VcsRef>(){
            private final Supplier<Collection<VcsRef>> myLoadedRefs = Suppliers.memoize(() -> CompressedRefs.this.stream().collect(Collectors.toList()));

            @Override
            public Iterator<VcsRef> iterator() {
                return ((Collection)this.myLoadedRefs.get()).iterator();
            }

            @Override
            public int size() {
                return ((Collection)this.myLoadedRefs.get()).size();
            }
        };
        if (abstractCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "getRefs"));
        }
        return abstractCollection;
    }

    @NotNull
    public Collection<Integer> getCommits() {
        HashSet result2 = ContainerUtil.newHashSet();
        TroveUtil.streamKeys(this.myBranches).forEach(result2::add);
        TroveUtil.streamKeys(this.myTags).forEach(result2::add);
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs", "getCommits"));
        }
        return hashSet;
    }

    public static void putRef(@NotNull TIntObjectHashMap<SmartList<VcsRef>> map, @NotNull VcsRef ref, @NotNull VcsLogStorage hashMap) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/vcs/log/data/CompressedRefs", "putRef"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/data/CompressedRefs", "putRef"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/CompressedRefs", "putRef"));
        }
        int index = hashMap.getCommitIndex(ref.getCommitHash(), ref.getRoot());
        SmartList list = (SmartList)map.get(index);
        if (list == null) {
            list = new SmartList();
            map.put(index, (Object)list);
        }
        list.add((Object)ref);
    }

    public static void putRefIndex(@NotNull TIntObjectHashMap<TIntArrayList> map, @NotNull VcsRef ref, @NotNull VcsLogStorage hashMap) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/vcs/log/data/CompressedRefs", "putRefIndex"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/data/CompressedRefs", "putRefIndex"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/CompressedRefs", "putRefIndex"));
        }
        int index = hashMap.getCommitIndex(ref.getCommitHash(), ref.getRoot());
        TIntArrayList list = (TIntArrayList)map.get(index);
        if (list == null) {
            list = new TIntArrayList();
            map.put(index, (Object)list);
        }
        list.add(hashMap.getRefIndex(ref));
    }
}

