/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TroveUtil {
    @NotNull
    public static <T> Stream<T> streamValues(@NotNull TIntObjectHashMap<T> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/vcs/log/data/TroveUtil", "streamValues"));
        }
        TIntObjectIterator it = map.iterator();
        Stream<Object> stream = Stream.generate(() -> {
            it.advance();
            return it.value();
        }).limit(map.size());
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/TroveUtil", "streamValues"));
        }
        return stream;
    }

    @NotNull
    public static IntStream streamKeys(@NotNull TIntObjectHashMap<?> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/vcs/log/data/TroveUtil", "streamKeys"));
        }
        TIntObjectIterator it = map.iterator();
        IntStream intStream = IntStream.generate(() -> {
            it.advance();
            return it.key();
        }).limit(map.size());
        if (intStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/TroveUtil", "streamKeys"));
        }
        return intStream;
    }

    @NotNull
    public static IntStream stream(@NotNull TIntArrayList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/vcs/log/data/TroveUtil", "stream"));
        }
        if (list.isEmpty()) {
            IntStream intStream = IntStream.empty();
            if (intStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/TroveUtil", "stream"));
            }
            return intStream;
        }
        IntStream intStream = IntStream.range(0, list.size()).map(arg_0 -> ((TIntArrayList)list).get(arg_0));
        if (intStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/TroveUtil", "stream"));
        }
        return intStream;
    }

    @NotNull
    public static Set<Integer> intersect(TIntHashSet ... sets) {
        if (sets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sets", "com/intellij/vcs/log/data/TroveUtil", "intersect"));
        }
        TIntHashSet result2 = null;
        Arrays.sort(sets, (set1, set2) -> {
            if (set1 == null) {
                return -1;
            }
            if (set2 == null) {
                return 1;
            }
            return set1.size() - set2.size();
        });
        for (TIntHashSet set3 : sets) {
            result2 = TroveUtil.intersect(result2, set3);
        }
        if (result2 == null) {
            HashSet hashSet = ContainerUtil.newHashSet();
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/TroveUtil", "intersect"));
            }
            return hashSet;
        }
        Set<Integer> set4 = TroveUtil.createJavaSet(result2);
        if (set4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/TroveUtil", "intersect"));
        }
        return set4;
    }

    @Nullable
    private static TIntHashSet intersect(@Nullable TIntHashSet set1, @Nullable TIntHashSet set2) {
        if (set1 == null) {
            return set2;
        }
        if (set2 == null) {
            return set1;
        }
        TIntHashSet result2 = new TIntHashSet();
        if (set1.size() < set2.size()) {
            set1.forEach(value -> {
                if (set2.contains(value)) {
                    result2.add(value);
                }
                return true;
            });
        } else {
            set2.forEach(value -> {
                if (set1.contains(value)) {
                    result2.add(value);
                }
                return true;
            });
        }
        return result2;
    }

    @NotNull
    private static Set<Integer> createJavaSet(@NotNull TIntHashSet set2) {
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/vcs/log/data/TroveUtil", "createJavaSet"));
        }
        HashSet result2 = ContainerUtil.newHashSet((int)set2.size());
        set2.forEach(value -> {
            result2.add(value);
            return true;
        });
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/TroveUtil", "createJavaSet"));
        }
        return hashSet;
    }

    public static void addAll(@NotNull TIntHashSet where, @NotNull TIntHashSet what) {
        if (where == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "com/intellij/vcs/log/data/TroveUtil", "addAll"));
        }
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/vcs/log/data/TroveUtil", "addAll"));
        }
        what.forEach(value -> {
            if (where == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "com/intellij/vcs/log/data/TroveUtil", "lambda$addAll$6"));
            }
            where.add(value);
            return true;
        });
    }

    @NotNull
    public static IntStream stream(@NotNull TIntHashSet set2) {
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/vcs/log/data/TroveUtil", "stream"));
        }
        TIntIterator it = set2.iterator();
        IntStream intStream = IntStream.generate(() -> ((TIntIterator)it).next()).limit(set2.size());
        if (intStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/TroveUtil", "stream"));
        }
        return intStream;
    }

    @NotNull
    public static <T> List<T> map(@NotNull TIntHashSet set2, @NotNull IntFunction<T> function) {
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/vcs/log/data/TroveUtil", "map"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/vcs/log/data/TroveUtil", "map"));
        }
        List list = TroveUtil.stream(set2).mapToObj(function).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/TroveUtil", "map"));
        }
        return list;
    }

    public static void processBatches(@NotNull IntStream stream, int batchSize, @NotNull Consumer<TIntHashSet> consumer) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/vcs/log/data/TroveUtil", "processBatches"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/TroveUtil", "processBatches"));
        }
        Ref batch = new Ref((Object)new TIntHashSet());
        stream.forEach(commit -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/TroveUtil", "lambda$processBatches$7"));
            }
            ((TIntHashSet)batch.get()).add(commit);
            if (((TIntHashSet)batch.get()).size() >= batchSize) {
                try {
                    consumer.consume(batch.get());
                }
                finally {
                    batch.set((Object)new TIntHashSet());
                }
            }
        });
        if (!((TIntHashSet)batch.get()).isEmpty()) {
            consumer.consume(batch.get());
        }
    }
}

