/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogStorage;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.data.EmptyIndex;
import com.intellij.vcs.log.data.InMemoryStorage;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogRefresherImpl;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.VisiblePackBuilder;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogData
implements Disposable,
VcsLogDataProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogData.class);
    private static final Consumer<Exception> FAILING_EXCEPTION_HANDLER = e -> {
        if (!(e instanceof ProcessCanceledException)) {
            LOG.error((Throwable)e);
        }
    };
    public static final int RECENT_COMMITS_COUNT = Registry.intValue((String)"vcs.log.recent.commits.count");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final BackgroundTaskQueue myDataLoaderQueue;
    @NotNull
    private final MiniDetailsGetter myMiniDetailsGetter;
    @NotNull
    private final CommitDetailsGetter myDetailsGetter;
    private final Map<VirtualFile, VcsUser> myCurrentUser;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final VcsLogStorage myHashMap;
    @NotNull
    private final ContainingBranchesGetter myContainingBranchesGetter;
    @NotNull
    private final VcsLogRefresherImpl myRefresher;
    @NotNull
    private final List<DataPackChangeListener> myDataPackChangeListeners;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsLogIndex myIndex;

    public VcsLogData(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogData", "<init>"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/VcsLogData", "<init>"));
        }
        if (fatalErrorsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorsConsumer", "com/intellij/vcs/log/data/VcsLogData", "<init>"));
        }
        this.myCurrentUser = ContainerUtil.newHashMap();
        this.myDataPackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project2;
        this.myLogProviders = logProviders;
        this.myDataLoaderQueue = new BackgroundTaskQueue(project2, "Loading history...");
        this.myUserRegistry = (VcsUserRegistryImpl)ServiceManager.getService((Project)project2, VcsUserRegistry.class);
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        VcsLogProgress progress = new VcsLogProgress();
        Disposer.register((Disposable)this, (Disposable)progress);
        VcsLogCachesInvalidator invalidator = (VcsLogCachesInvalidator)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class));
        if (invalidator.isValid()) {
            this.myHashMap = this.createLogHashMap();
            this.myIndex = new VcsLogPersistentIndex(this.myProject, this.myHashMap, progress, logProviders, this.myFatalErrorsConsumer, this);
        } else {
            String message = "Could not delete " + PersistentUtil.LOG_CACHE + "\nDelete it manually and restart IDEA.";
            LOG.error(message);
            this.myFatalErrorsConsumer.displayFatalErrorMessage(message);
            this.myHashMap = new InMemoryStorage();
            this.myIndex = new EmptyIndex();
        }
        this.myTopCommitsDetailsCache = new TopCommitsCache(this.myHashMap);
        this.myMiniDetailsGetter = new MiniDetailsGetter(this.myHashMap, logProviders, this.myTopCommitsDetailsCache, (Disposable)this);
        this.myDetailsGetter = new CommitDetailsGetter(this.myHashMap, logProviders, this);
        this.myRefresher = new VcsLogRefresherImpl(this.myProject, this.myHashMap, this.myLogProviders, this.myUserRegistry, this.myIndex, progress, this.myTopCommitsDetailsCache, (Consumer<DataPack>)((Consumer)this::fireDataPackChangeEvent), FAILING_EXCEPTION_HANDLER, RECENT_COMMITS_COUNT);
        this.myContainingBranchesGetter = new ContainingBranchesGetter(this, this);
    }

    @NotNull
    private VcsLogStorage createLogHashMap() {
        VcsLogStorage hashMap;
        try {
            hashMap = new VcsLogStorageImpl(this.myProject, this.myLogProviders, this.myFatalErrorsConsumer, this);
        }
        catch (IOException e) {
            hashMap = new InMemoryStorage();
            LOG.error("Falling back to in-memory hashes", (Throwable)e);
        }
        VcsLogStorage vcsLogStorage = hashMap;
        if (vcsLogStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "createLogHashMap"));
        }
        return vcsLogStorage;
    }

    private void fireDataPackChangeEvent(@NotNull DataPack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VcsLogData", "fireDataPackChangeEvent"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (dataPack == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VcsLogData", "lambda$fireDataPackChangeEvent$1"));
            }
            for (DataPackChangeListener listener2 : this.myDataPackChangeListeners) {
                listener2.onDataPackChange(dataPack);
            }
        });
    }

    public void addDataPackChangeListener(@NotNull DataPackChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/data/VcsLogData", "addDataPackChangeListener"));
        }
        this.myDataPackChangeListeners.add(listener2);
    }

    public void removeDataPackChangeListener(@NotNull DataPackChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/data/VcsLogData", "removeDataPackChangeListener"));
        }
        this.myDataPackChangeListeners.remove(listener2);
    }

    @NotNull
    public DataPack getDataPack() {
        DataPack dataPack = this.myRefresher.getCurrentDataPack();
        if (dataPack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getDataPack"));
        }
        return dataPack;
    }

    @NotNull
    public VisiblePackBuilder createVisiblePackBuilder() {
        VisiblePackBuilder visiblePackBuilder = new VisiblePackBuilder(this.myLogProviders, this.myHashMap, this.myTopCommitsDetailsCache, this.myDetailsGetter, this.myIndex);
        if (visiblePackBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "createVisiblePackBuilder"));
        }
        return visiblePackBuilder;
    }

    @Nullable
    public CommitId getCommitId(int commitIndex) {
        return this.myHashMap.getCommitId(commitIndex);
    }

    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogData", "getCommitIndex"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogData", "getCommitIndex"));
        }
        return this.myHashMap.getCommitIndex(hash, root);
    }

    @NotNull
    public VcsLogStorage getHashMap() {
        VcsLogStorage vcsLogStorage = this.myHashMap;
        if (vcsLogStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getHashMap"));
        }
        return vcsLogStorage;
    }

    public void initialize() {
        StopWatch initSw = StopWatch.start("initialize");
        this.myDataLoaderQueue.clear();
        this.runInBackground((ThrowableConsumer<ProgressIndicator, VcsException>)((ThrowableConsumer)indicator -> {
            this.resetState();
            this.readCurrentUser();
            DataPack dataPack = this.myRefresher.readFirstBlock();
            this.fireDataPackChangeEvent(dataPack);
            initSw.report();
        }), "Loading History...");
    }

    private void readCurrentUser() {
        StopWatch sw = StopWatch.start("readCurrentUser");
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : this.myLogProviders.entrySet()) {
            VirtualFile root = entry.getKey();
            try {
                VcsUser me = entry.getValue().getCurrentUser(root);
                if (me != null) {
                    this.myCurrentUser.put(root, me);
                    continue;
                }
                LOG.info("Username not configured for root " + root);
            }
            catch (VcsException e) {
                LOG.warn("Couldn't read the username from root " + root, (Throwable)e);
            }
        }
        sw.report();
    }

    private void resetState() {
        this.myTopCommitsDetailsCache.clear();
    }

    @NotNull
    public Set<VcsUser> getAllUsers() {
        Set<VcsUser> set2 = this.myUserRegistry.getUsers();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getAllUsers"));
        }
        return set2;
    }

    @NotNull
    public Map<VirtualFile, VcsUser> getCurrentUser() {
        Map<VirtualFile, VcsUser> map = this.myCurrentUser;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getCurrentUser"));
        }
        return map;
    }

    public boolean isMultiRoot() {
        return this.myLogProviders.size() > 1;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getProject"));
        }
        return project2;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Set<VirtualFile> set2 = this.myLogProviders.keySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getRoots"));
        }
        return set2;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map = this.myLogProviders;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getLogProviders"));
        }
        return map;
    }

    @NotNull
    public ContainingBranchesGetter getContainingBranchesGetter() {
        ContainingBranchesGetter containingBranchesGetter = this.myContainingBranchesGetter;
        if (containingBranchesGetter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getContainingBranchesGetter"));
        }
        return containingBranchesGetter;
    }

    private void runInBackground(final ThrowableConsumer<ProgressIndicator, VcsException> task, String title) {
        Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, title, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/VcsLogData$1", "run"));
                }
                indicator.setIndeterminate(true);
                try {
                    task.consume((Object)indicator);
                }
                catch (VcsException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.myDataLoaderQueue.run(backgroundable, null, this.myRefresher.getProgress().createProgressIndicator());
    }

    public void refreshSoftly() {
        this.myRefresher.refresh(this.myLogProviders.keySet());
    }

    public void refresh(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogData", "refresh"));
        }
        this.myRefresher.refresh(roots);
    }

    public CommitDetailsGetter getCommitDetailsGetter() {
        return this.myDetailsGetter;
    }

    @NotNull
    public MiniDetailsGetter getMiniDetailsGetter() {
        MiniDetailsGetter miniDetailsGetter = this.myMiniDetailsGetter;
        if (miniDetailsGetter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getMiniDetailsGetter"));
        }
        return miniDetailsGetter;
    }

    public void dispose() {
        this.myDataLoaderQueue.clear();
        this.resetState();
    }

    @NotNull
    public VcsLogProvider getLogProvider(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogData", "getLogProvider"));
        }
        VcsLogProvider vcsLogProvider = this.myLogProviders.get(root);
        if (vcsLogProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getLogProvider"));
        }
        return vcsLogProvider;
    }

    @NotNull
    public VcsUserRegistryImpl getUserRegistry() {
        VcsUserRegistryImpl vcsUserRegistryImpl = this.myUserRegistry;
        if (vcsUserRegistryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getUserRegistry"));
        }
        return vcsUserRegistryImpl;
    }

    @NotNull
    public VcsLogProgress getProgress() {
        VcsLogProgress vcsLogProgress = this.myRefresher.getProgress();
        if (vcsLogProgress == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getProgress"));
        }
        return vcsLogProgress;
    }

    @NotNull
    public TopCommitsCache getTopCommitsCache() {
        TopCommitsCache topCommitsCache = this.myTopCommitsDetailsCache;
        if (topCommitsCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getTopCommitsCache"));
        }
        return topCommitsCache;
    }

    @NotNull
    public VcsLogIndex getIndex() {
        VcsLogIndex vcsLogIndex = this.myIndex;
        if (vcsLogIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogData", "getIndex"));
        }
        return vcsLogIndex;
    }
}

