/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogProgress
implements Disposable {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final List<ProgressListener> myListeners = ContainerUtil.newArrayList();
    @NotNull
    private Set<ProgressIndicator> myTasksWithVisibleProgress = ContainerUtil.newHashSet();
    @NotNull
    private Set<ProgressIndicator> myTasksWithSilentProgress = ContainerUtil.newHashSet();

    @NotNull
    public ProgressIndicator createProgressIndicator() {
        ProgressIndicator progressIndicator = this.createProgressIndicator(true);
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogProgress", "createProgressIndicator"));
        }
        return progressIndicator;
    }

    public ProgressIndicator createProgressIndicator(boolean visible) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return new EmptyProgressIndicator();
        }
        return new VcsLogProgressIndicator(visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressIndicatorListener(@NotNull ProgressListener listener2, @Nullable Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/data/VcsLogProgress", "addProgressIndicatorListener"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.add(listener2);
            if (parentDisposable != null) {
                Disposer.register((Disposable)parentDisposable, () -> {
                    if (listener2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/data/VcsLogProgress", "lambda$addProgressIndicatorListener$0"));
                    }
                    this.removeProgressIndicatorListener(listener2);
                });
            }
            if (this.isRunning()) {
                ApplicationManager.getApplication().invokeLater(listener2::progressStarted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressIndicatorListener(@NotNull ProgressListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/data/VcsLogProgress", "removeProgressIndicatorListener"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.myLock;
        synchronized (object) {
            return !this.myTasksWithVisibleProgress.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void started(@NotNull VcsLogProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/VcsLogProgress", "started"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (indicator.isVisible()) {
                this.myTasksWithVisibleProgress.add(indicator);
                if (this.myTasksWithVisibleProgress.size() == 1) {
                    this.fireNotification(ProgressListener::progressStarted);
                }
            } else {
                this.myTasksWithSilentProgress.add(indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped(@NotNull VcsLogProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/VcsLogProgress", "stopped"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (indicator.isVisible()) {
                this.myTasksWithVisibleProgress.remove(indicator);
                if (this.myTasksWithVisibleProgress.isEmpty()) {
                    this.fireNotification(ProgressListener::progressStopped);
                }
            } else {
                this.myTasksWithSilentProgress.remove(indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotification(@NotNull Consumer<ProgressListener> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/data/VcsLogProgress", "fireNotification"));
        }
        Object object = this.myLock;
        synchronized (object) {
            ArrayList list = ContainerUtil.newArrayList(this.myListeners);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/data/VcsLogProgress", "lambda$fireNotification$1"));
                }
                list.forEach(action);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            for (ProgressIndicator indicator : this.myTasksWithVisibleProgress) {
                indicator.cancel();
            }
            for (ProgressIndicator indicator : this.myTasksWithSilentProgress) {
                indicator.cancel();
            }
        }
    }

    public static interface ProgressListener {
        public void progressStarted();

        public void progressStopped();
    }

    private class VcsLogProgressIndicator
    extends AbstractProgressIndicatorBase {
        private final boolean myVisible;

        private VcsLogProgressIndicator(boolean visible) {
            this.myVisible = visible;
        }

        @Override
        public synchronized void start() {
            super.start();
            VcsLogProgress.this.started(this);
        }

        @Override
        public synchronized void stop() {
            super.stop();
            VcsLogProgress.this.stopped(this);
        }

        public boolean isVisible() {
            return this.myVisible;
        }
    }
}

