/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStorage;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitCountStage;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.EmptyVisibleGraph;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.util.StopWatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VisiblePackBuilder {
    private static final Logger LOG = Logger.getInstance(VisiblePackBuilder.class);
    @NotNull
    private final VcsLogStorage myHashMap;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final DataGetter<VcsFullCommitDetails> myCommitDetailsGetter;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final VcsLogIndex myIndex;

    VisiblePackBuilder(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogStorage hashMap, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull DataGetter<VcsFullCommitDetails> detailsGetter, @NotNull VcsLogIndex index) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        if (topCommitsDetailsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topCommitsDetailsCache", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        if (detailsGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsGetter", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        this.myHashMap = hashMap;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myCommitDetailsGetter = detailsGetter;
        this.myLogProviders = providers;
        this.myIndex = index;
    }

    @NotNull
    Pair<VisiblePack, CommitCountStage> build(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        if (commitCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitCount", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        long start = System.currentTimeMillis();
        VcsLogHashFilter hashFilter = filters.getHashFilter();
        if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
            Pair pair = Pair.create((Object)this.applyHashFilter(dataPack, hashFilter.getHashes(), sortType), (Object)((Object)commitCount));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
            }
            return pair;
        }
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(dataPack.getLogProviders().keySet(), filters.getRootFilter(), filters.getStructureFilter());
        Set<Integer> matchingHeads = this.getMatchingHeads(dataPack.getRefsModel(), visibleRoots, filters);
        FilterResult filterResult = this.filterByDetails(dataPack, filters, commitCount, visibleRoots, matchingHeads);
        VisibleGraph visibleGraph = VisiblePackBuilder.matchesNothing(matchingHeads) || VisiblePackBuilder.matchesNothing(filterResult.matchingCommits) ? EmptyVisibleGraph.getInstance() : dataPack.getPermanentGraph().createVisibleGraph(sortType, matchingHeads, filterResult.matchingCommits);
        LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start) + " for filtering by " + filters);
        Pair pair = Pair.create((Object)new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, filterResult.canRequestMore, filters), (Object)((Object)filterResult.commitCount));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        return pair;
    }

    @NotNull
    private FilterResult filterByDetails(@NotNull DataPack dataPack, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount, @NotNull Collection<VirtualFile> visibleRoots, @Nullable Set<Integer> matchingHeads) {
        List notIndexedRoots;
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterByDetails"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterByDetails"));
        }
        if (commitCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitCount", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterByDetails"));
        }
        if (visibleRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleRoots", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterByDetails"));
        }
        List detailsFilters = filters.getDetailsFilters();
        if (detailsFilters.isEmpty()) {
            FilterResult filterResult = new FilterResult(null, false, commitCount);
            if (filterResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterByDetails"));
            }
            return filterResult;
        }
        Set filteredWidthIndex = null;
        if (this.myIndex.canFilter(detailsFilters) && (notIndexedRoots = ContainerUtil.filter(visibleRoots, root -> !this.myIndex.isIndexed((VirtualFile)root))).size() < visibleRoots.size()) {
            filteredWidthIndex = this.myIndex.filter(detailsFilters);
            if (notIndexedRoots.isEmpty()) {
                FilterResult filterResult = new FilterResult(filteredWidthIndex, false, commitCount);
                if (filterResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterByDetails"));
                }
                return filterResult;
            }
            matchingHeads = this.getMatchingHeads(dataPack.getRefsModel(), notIndexedRoots, filters);
        }
        FilterResult filteredWithVcs = this.filterWithVcs(dataPack.getPermanentGraph(), filters, detailsFilters, matchingHeads, commitCount);
        Set filteredCommits = filteredWidthIndex == null ? filteredWithVcs.matchingCommits : (filteredWithVcs.matchingCommits == null ? filteredWidthIndex : ContainerUtil.union(filteredWidthIndex, (Set)filteredWithVcs.matchingCommits));
        FilterResult filterResult = new FilterResult(filteredCommits, filteredWithVcs.canRequestMore, filteredWithVcs.commitCount);
        if (filterResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterByDetails"));
        }
        return filterResult;
    }

    @NotNull
    private FilterResult filterWithVcs(@NotNull PermanentGraph graph, @NotNull VcsLogFilterCollection filters, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads, @NotNull CommitCountStage commitCount) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterWithVcs"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterWithVcs"));
        }
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsFilters", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterWithVcs"));
        }
        if (commitCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitCount", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterWithVcs"));
        }
        Set<Object> matchingCommits = null;
        if (commitCount == CommitCountStage.INITIAL && (matchingCommits = this.getMatchedCommitIndex(this.filterInMemory((PermanentGraph<Integer>)graph, detailsFilters, matchingHeads))).size() < commitCount.getCount()) {
            commitCount = commitCount.next();
            matchingCommits = null;
        }
        if (matchingCommits == null) {
            try {
                matchingCommits = this.getMatchedCommitIndex(VisiblePackBuilder.getFilteredDetailsFromTheVcs(this.myLogProviders, filters, commitCount.getCount()));
            }
            catch (VcsException e) {
                matchingCommits = Collections.emptySet();
                LOG.error((Throwable)e);
            }
        }
        FilterResult filterResult = new FilterResult(matchingCommits, matchingCommits.size() >= commitCount.getCount(), commitCount);
        if (filterResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterWithVcs"));
        }
        return filterResult;
    }

    private static <T> boolean matchesNothing(@Nullable Collection<T> matchingSet) {
        return matchingSet != null && matchingSet.isEmpty();
    }

    private VisiblePack applyHashFilter(@NotNull DataPack dataPack, @NotNull Collection<String> hashes, @NotNull PermanentGraph.SortType sortType) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VisiblePackBuilder", "applyHashFilter"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "com/intellij/vcs/log/data/VisiblePackBuilder", "applyHashFilter"));
        }
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/data/VisiblePackBuilder", "applyHashFilter"));
        }
        Set indices = ContainerUtil.map2SetNotNull(hashes, partOfHash -> {
            CommitId commitId = this.myHashMap.findCommitId(new CommitIdByStringCondition((String)partOfHash));
            return commitId != null ? Integer.valueOf(this.myHashMap.getCommitIndex(commitId.getHash(), commitId.getRoot())) : null;
        });
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, indices);
        return new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, false, new VcsLogFilterCollectionImpl(null, null, new VcsLogHashFilterImpl(hashes), null, null, null, null));
    }

    @Nullable
    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull Collection<VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        VcsLogBranchFilter branchFilter = filters.getBranchFilter();
        VcsLogRootFilter rootFilter = filters.getRootFilter();
        VcsLogStructureFilter structureFilter = filters.getStructureFilter();
        if (branchFilter == null && rootFilter == null && structureFilter == null) {
            return null;
        }
        Set<Integer> filteredByBranch = null;
        if (branchFilter != null) {
            filteredByBranch = this.getMatchingHeads(refs, branchFilter);
        }
        Set<Integer> filteredByFile = this.getMatchingHeads(refs, roots);
        if (filteredByBranch == null) {
            return filteredByFile;
        }
        if (filteredByFile == null) {
            return filteredByBranch;
        }
        return new HashSet(ContainerUtil.intersection(filteredByBranch, filteredByFile));
    }

    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull VcsLogBranchFilter filter) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        return new HashSet((Collection)ContainerUtil.mapNotNull((Collection)refs.getBranches(), ref -> {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/data/VisiblePackBuilder", "lambda$getMatchingHeads$2"));
            }
            boolean acceptRef = filter.matches(ref.getName());
            return acceptRef ? Integer.valueOf(this.myHashMap.getCommitIndex(ref.getCommitHash(), ref.getRoot())) : null;
        }));
    }

    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull Collection<VirtualFile> roots) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        HashSet result2 = new HashSet();
        for (VcsRef branch : refs.getBranches()) {
            if (!roots.contains(branch.getRoot())) continue;
            result2.add(this.myHashMap.getCommitIndex(branch.getCommitHash(), branch.getRoot()));
        }
        return result2;
    }

    @NotNull
    private Collection<CommitId> filterInMemory(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        GraphCommit commit;
        VcsCommitMetadata data;
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterInMemory"));
        }
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsFilters", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterInMemory"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        Iterator iterator = permanentGraph.getAllCommits().iterator();
        while (iterator.hasNext() && (data = this.getDetailsFromCache((Integer)(commit = (GraphCommit)iterator.next()).getId())) != null) {
            if (!this.matchesAllFilters(data, permanentGraph, detailsFilters, matchingHeads)) continue;
            result2.add(new CommitId((Hash)data.getId(), data.getRoot()));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterInMemory"));
        }
        return arrayList;
    }

    private boolean matchesAllFilters(@NotNull VcsCommitMetadata commit, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAllFilters"));
        }
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAllFilters"));
        }
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsFilters", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAllFilters"));
        }
        boolean matchesAllDetails = ContainerUtil.and(detailsFilters, filter -> {
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VisiblePackBuilder", "lambda$matchesAllFilters$3"));
            }
            return filter.matches(commit);
        });
        return matchesAllDetails && this.matchesAnyHead(permanentGraph, commit, matchingHeads);
    }

    private boolean matchesAnyHead(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull VcsCommitMetadata commit, @Nullable Set<Integer> matchingHeads) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAnyHead"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAnyHead"));
        }
        if (matchingHeads == null) {
            return true;
        }
        int commitIndex = this.myHashMap.getCommitIndex((Hash)commit.getId(), commit.getRoot());
        return ContainerUtil.intersects((Collection)permanentGraph.getContainingBranches((Object)commitIndex), matchingHeads);
    }

    @Nullable
    private VcsCommitMetadata getDetailsFromCache(int commitIndex) {
        VcsCommitMetadata details = this.myTopCommitsDetailsCache.get(commitIndex);
        if (details != null) {
            return details;
        }
        return (VcsCommitMetadata)UIUtil.invokeAndWaitIfNeeded(() -> this.myCommitDetailsGetter.getCommitDataIfAvailable(commitIndex));
    }

    @NotNull
    private static Collection<CommitId> getFilteredDetailsFromTheVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VisiblePackBuilder", "getFilteredDetailsFromTheVcs"));
        }
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "com/intellij/vcs/log/data/VisiblePackBuilder", "getFilteredDetailsFromTheVcs"));
        }
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(providers.keySet(), filterCollection.getRootFilter(), filterCollection.getStructureFilter());
        ArrayList commits = ContainerUtil.newArrayList();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            if (!visibleRoots.contains(root) || filterCollection.getUserFilter() != null && filterCollection.getUserFilter().getUserNames(root).isEmpty()) continue;
            VcsLogFilterCollection rootSpecificCollection = filterCollection;
            if (rootSpecificCollection.getStructureFilter() != null) {
                rootSpecificCollection = VisiblePackBuilder.replaceStructureFilter(filterCollection, ContainerUtil.newHashSet(VcsLogUtil.getFilteredFilesForRoot(root, filterCollection)));
            }
            List matchingCommits = entry.getValue().getCommitsMatchingFilter(root, rootSpecificCollection, maxCount);
            commits.addAll(ContainerUtil.map((Collection)matchingCommits, commit -> new CommitId((Hash)commit.getId(), root)));
        }
        ArrayList arrayList = commits;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "getFilteredDetailsFromTheVcs"));
        }
        return arrayList;
    }

    @NotNull
    private static VcsLogFilterCollection replaceStructureFilter(@NotNull VcsLogFilterCollection filterCollection, @NotNull Set<FilePath> files) {
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "com/intellij/vcs/log/data/VisiblePackBuilder", "replaceStructureFilter"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/data/VisiblePackBuilder", "replaceStructureFilter"));
        }
        VcsLogFilterCollectionImpl vcsLogFilterCollectionImpl = new VcsLogFilterCollectionImpl(filterCollection.getBranchFilter(), filterCollection.getUserFilter(), filterCollection.getHashFilter(), filterCollection.getDateFilter(), filterCollection.getTextFilter(), new VcsLogStructureFilterImpl((Collection<FilePath>)files), filterCollection.getRootFilter());
        if (vcsLogFilterCollectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "replaceStructureFilter"));
        }
        return vcsLogFilterCollectionImpl;
    }

    @Nullable
    private Set<Integer> getMatchedCommitIndex(@Nullable Collection<CommitId> commits) {
        if (commits == null) {
            return null;
        }
        return ContainerUtil.map2Set(commits, commitId -> this.myHashMap.getCommitIndex(commitId.getHash(), commitId.getRoot()));
    }

    private static class FilterResult {
        @Nullable
        private final Set<Integer> matchingCommits;
        private final boolean canRequestMore;
        @NotNull
        private final CommitCountStage commitCount;

        private FilterResult(@Nullable Set<Integer> commits, boolean more, @NotNull CommitCountStage count) {
            if (count == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "count", "com/intellij/vcs/log/data/VisiblePackBuilder$FilterResult", "<init>"));
            }
            this.matchingCommits = commits;
            this.canRequestMore = more;
            this.commitCount = count;
        }
    }
}

