/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtilRt;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.InputIndexDataExternalizer;
import com.intellij.util.indexing.MapIndexStorage;
import com.intellij.util.indexing.MapReduceIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdateData;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.PersistentUtil;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFullDetailsIndex<T>
implements Disposable {
    @NotNull
    protected static final String INDEX = "index-";
    @NotNull
    protected static final String INDEX_INPUTS = "index-inputs-";
    @NotNull
    protected final MyMapReduceIndex myMapReduceIndex;
    @NotNull
    private final ID<Integer, T> myID;
    @NotNull
    private final String myLogId;
    @NotNull
    private final String myName;
    @NotNull
    protected final DataIndexer<Integer, T, VcsFullCommitDetails> myIndexer;
    @NotNull
    private final FatalErrorHandler myFatalErrorHandler;

    public VcsLogFullDetailsIndex(@NotNull String logId, @NotNull String name, int version, @NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, @NotNull DataExternalizer<T> externalizer, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        if (indexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        if (externalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        if (fatalErrorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "<init>"));
        }
        this.myID = ID.create((String)name);
        this.myName = name;
        this.myLogId = logId;
        this.myIndexer = indexer;
        this.myFatalErrorHandler = fatalErrorHandler;
        MyMapReduceIndex result2 = (MyMapReduceIndex)IOUtil.openCleanOrResetBroken(() -> {
            if (externalizer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "lambda$new$0"));
            }
            return new MyMapReduceIndex(this.myIndexer, externalizer, version);
        }, () -> {
            IOUtil.deleteAllFilesStartingWith((File)this.getStorageFile(version));
            IOUtil.deleteAllFilesStartingWith((File)this.getInputsStorageFile(version));
        });
        if (result2 == null) {
            throw new IOException("Can not create " + this.myName + " index for " + this.myLogId);
        }
        this.myMapReduceIndex = result2;
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    @NotNull
    public TIntHashSet getCommitsWithAnyKey(@NotNull Set<Integer> keys) throws StorageException {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getCommitsWithAnyKey"));
        }
        TIntHashSet result2 = new TIntHashSet();
        for (Integer key2 : keys) {
            this.iterateCommitIds(key2, (Consumer<Integer>)((Consumer)arg_0 -> ((TIntHashSet)result2).add(arg_0)));
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getCommitsWithAnyKey"));
        }
        return tIntHashSet;
    }

    @NotNull
    public ValueContainer.IntIterator getCommitsWithAllKeys(@NotNull Collection<Integer> keys) throws StorageException {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getCommitsWithAllKeys"));
        }
        ValueContainer.IntIterator intIterator = FileBasedIndexImpl.collectInputIdsContainingAllKeys(this.myMapReduceIndex, keys);
        if (intIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getCommitsWithAllKeys"));
        }
        return intIterator;
    }

    private void iterateCommitIds(int key2, @NotNull Consumer<Integer> consumer) throws StorageException {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "iterateCommitIds"));
        }
        ValueContainer data = this.myMapReduceIndex.getData(key2);
        ValueContainer.ValueIterator valueIt = data.getValueIterator();
        while (valueIt.hasNext()) {
            valueIt.next();
            ValueContainer.IntIterator inputIt = valueIt.getInputIdsIterator();
            while (inputIt.hasNext()) {
                consumer.consume((Object)inputIt.next());
            }
        }
    }

    protected void iterateCommitIdsAndValues(int key2, @NotNull ObjIntConsumer<T> consumer) throws StorageException {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "iterateCommitIdsAndValues"));
        }
        ValueContainer data = this.myMapReduceIndex.getData(key2);
        ValueContainer.ValueIterator valueIt = data.getValueIterator();
        while (valueIt.hasNext()) {
            Object nextValue = valueIt.next();
            ValueContainer.IntIterator inputIt = valueIt.getInputIdsIterator();
            while (inputIt.hasNext()) {
                int next = inputIt.next();
                consumer.accept(nextValue, next);
            }
        }
    }

    public void update(int commitId, @NotNull VcsFullCommitDetails details) throws IOException {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "update"));
        }
        this.myMapReduceIndex.update(commitId, details).compute();
    }

    public void flush() throws StorageException {
        this.myMapReduceIndex.flush();
    }

    public boolean isIndexed(int commit) throws IOException {
        return this.myMapReduceIndex.isIndexed(commit);
    }

    public void dispose() {
        this.myMapReduceIndex.dispose();
    }

    protected void onNotIndexableCommit(int commit) throws StorageException {
    }

    public void markCorrupted() {
        this.myMapReduceIndex.markCorrupted();
    }

    @NotNull
    private File getStorageFile(int version) {
        File file2 = VcsLogFullDetailsIndex.getStorageFile(INDEX + this.myName, this.myLogId, version);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getStorageFile"));
        }
        return file2;
    }

    @NotNull
    private File getInputsStorageFile(int version) {
        File file2 = PersistentUtil.getStorageFile(INDEX_INPUTS + this.myName, this.myLogId, version);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getInputsStorageFile"));
        }
        return file2;
    }

    @NotNull
    public static File getStorageFile(@NotNull String kind, @NotNull String id, int version) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getStorageFile"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getStorageFile"));
        }
        File subdir = new File(PersistentUtil.LOG_CACHE, kind);
        String safeLogId = PathUtilRt.suggestFileName((String)id, (boolean)true, (boolean)true);
        File file2 = new File(subdir, safeLogId + "." + version);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex", "getStorageFile"));
        }
        return file2;
    }

    @Nullable
    protected Collection<Integer> getKeysForCommit(int commit) throws IOException {
        return (Collection)this.myMapReduceIndex.getInputsIndex().get((Object)commit);
    }

    private class MyIndexExtension
    extends IndexExtension<Integer, T, VcsFullCommitDetails> {
        @NotNull
        private final DataIndexer<Integer, T, VcsFullCommitDetails> myIndexer;
        @NotNull
        private final DataExternalizer<T> myExternalizer;
        private final int myVersion;

        public MyIndexExtension(@NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, DataExternalizer<T> externalizer, int version) {
            if (indexer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "<init>"));
            }
            if (externalizer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "<init>"));
            }
            this.myIndexer = indexer;
            this.myExternalizer = externalizer;
            this.myVersion = version;
        }

        @NotNull
        public ID<Integer, T> getName() {
            ID iD = VcsLogFullDetailsIndex.this.myID;
            if (iD == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "getName"));
            }
            return iD;
        }

        @NotNull
        public DataIndexer<Integer, T, VcsFullCommitDetails> getIndexer() {
            DataIndexer dataIndexer = this.myIndexer;
            if (dataIndexer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "getIndexer"));
            }
            return dataIndexer;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
            if (enumeratorIntegerDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "getKeyDescriptor"));
            }
            return enumeratorIntegerDescriptor;
        }

        @NotNull
        public DataExternalizer<T> getValueExternalizer() {
            DataExternalizer dataExternalizer = this.myExternalizer;
            if (dataExternalizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension", "getValueExternalizer"));
            }
            return dataExternalizer;
        }

        public int getVersion() {
            return this.myVersion;
        }
    }

    private class MyMapReduceIndex
    extends MapReduceIndex<Integer, T, VcsFullCommitDetails> {
        public MyMapReduceIndex(@NotNull DataIndexer<Integer, T, VcsFullCommitDetails> indexer, DataExternalizer<T> externalizer, int version) throws IOException {
            if (indexer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapReduceIndex", "<init>"));
            }
            if (externalizer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapReduceIndex", "<init>"));
            }
            super(new MyIndexExtension(indexer, externalizer, version), new MapIndexStorage(VcsLogFullDetailsIndex.this.getStorageFile(version), EnumeratorIntegerDescriptor.INSTANCE, externalizer, 5000));
        }

        @NotNull
        public PersistentHashMap<Integer, Collection<Integer>> getInputsIndex() {
            PersistentHashMap persistentHashMap = this.myInputsIndex;
            if (persistentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapReduceIndex", "getInputsIndex"));
            }
            return persistentHashMap;
        }

        public boolean isIndexed(int commitId) throws IOException {
            return this.myInputsIndex.containsMapping((Object)commitId);
        }

        @Override
        protected PersistentHashMap<Integer, Collection<Integer>> createInputsIndex() throws IOException {
            IndexExtension extension = this.getExtension();
            return new PersistentHashMap(VcsLogFullDetailsIndex.this.getInputsStorageFile(extension.getVersion()), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, new InputIndexDataExternalizer(extension.getKeyDescriptor(), VcsLogFullDetailsIndex.this.myID));
        }

        @Override
        protected void updateWithMap(int inputId, @NotNull UpdateData<Integer, T> updateData) throws StorageException {
            if (updateData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateData", "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapReduceIndex", "updateWithMap"));
            }
            if (((MapReduceIndex.SimpleUpdateData)updateData).getNewData().isEmpty()) {
                VcsLogFullDetailsIndex.this.onNotIndexableCommit(inputId);
            }
            super.updateWithMap(inputId, updateData);
        }

        public void markCorrupted() {
            this.myInputsIndex.markCorrupted();
        }

        @Override
        protected void requestRebuild(@Nullable Exception ex) {
            VcsLogFullDetailsIndex.this.myFatalErrorHandler.consume(this, ex != null ? ex : new Exception("Index rebuild requested"));
        }
    }
}

