/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.PersistentUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogMessagesTrigramIndex
extends VcsLogFullDetailsIndex<Void> {
    private static final Logger LOG = Logger.getInstance(VcsLogMessagesTrigramIndex.class);
    private static final String TRIGRAMS = "trigrams";
    private static final int VALUE = 239;
    @NotNull
    private final PersistentHashMap<Integer, Integer> myNoTrigramsCommits;

    public VcsLogMessagesTrigramIndex(@NotNull String logId, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex", "<init>"));
        }
        if (fatalErrorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex", "<init>"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex", "<init>"));
        }
        super(logId, TRIGRAMS, VcsLogPersistentIndex.getVersion(), new TrigramMessageIndexer(), ScalarIndexExtension.VOID_DATA_EXTERNALIZER, fatalErrorHandler, disposableParent);
        this.myNoTrigramsCommits = PersistentUtil.createPersistentHashMap(EnumeratorIntegerDescriptor.INSTANCE, "index-no-trigrams", logId, VcsLogPersistentIndex.getVersion());
    }

    @Nullable
    public ValueContainer.IntIterator getCommitsForSubstring(@NotNull String string) throws StorageException {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex", "getCommitsForSubstring"));
        }
        MyTrigramProcessor trigramProcessor = new MyTrigramProcessor();
        TrigramBuilder.processTrigrams((CharSequence)string, (TrigramBuilder.TrigramProcessor)trigramProcessor);
        if (trigramProcessor.map.isEmpty()) {
            return null;
        }
        return this.getCommitsWithAllKeys(trigramProcessor.map.keySet());
    }

    @Override
    protected void onNotIndexableCommit(int commit) throws StorageException {
        try {
            this.myNoTrigramsCommits.put((Object)commit, (Object)239);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean isIndexed(int commit) throws IOException {
        return super.isIndexed(commit) || this.myNoTrigramsCommits.containsMapping((Object)commit);
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myNoTrigramsCommits.force();
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myNoTrigramsCommits.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Override
    public void markCorrupted() {
        super.markCorrupted();
        this.myNoTrigramsCommits.markCorrupted();
    }

    @NotNull
    public String getTrigramInfo(int commit) throws IOException {
        if (this.myNoTrigramsCommits.containsMapping((Object)commit)) {
            if ("No trigrams" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex", "getTrigramInfo"));
            }
            return "No trigrams";
        }
        Collection<Integer> keys = this.getKeysForCommit(commit);
        assert (keys != null);
        StringBuilder builder = new StringBuilder();
        for (Integer key2 : keys) {
            builder.append((char)(key2 >> 16));
            builder.append((char)((key2 >> 8) % 256));
            builder.append((char)(key2 % 256));
            builder.append(" ");
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex", "getTrigramInfo"));
        }
        return string;
    }

    private static class MyTrigramProcessor
    extends TrigramBuilder.TrigramProcessor {
        Map<Integer, Void> map;

        private MyTrigramProcessor() {
        }

        public boolean consumeTrigramsCount(int count) {
            this.map = new THashMap(count);
            return true;
        }

        public boolean execute(int value) {
            this.map.put(value, null);
            return true;
        }
    }

    public static class TrigramMessageIndexer
    implements DataIndexer<Integer, Void, VcsFullCommitDetails> {
        @NotNull
        public Map<Integer, Void> map(@NotNull VcsFullCommitDetails inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex$TrigramMessageIndexer", "map"));
            }
            MyTrigramProcessor trigramProcessor = new MyTrigramProcessor();
            TrigramBuilder.processTrigrams((CharSequence)inputData.getFullMessage(), (TrigramBuilder.TrigramProcessor)trigramProcessor);
            Map<Integer, Void> map = trigramProcessor.map;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex$TrigramMessageIndexer", "map"));
            }
            return map;
        }
    }
}

