/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.util.SmartList;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PermanentLinearGraphImpl
implements LinearGraph {
    private final Flags mySimpleNodes;
    private final IntList myNodeToEdgeIndex;
    private final IntList myLongEdges;

    PermanentLinearGraphImpl(Flags simpleNodes, int[] nodeToEdgeIndex, int[] longEdges) {
        this.mySimpleNodes = simpleNodes;
        this.myNodeToEdgeIndex = CompressedIntList.newInstance(nodeToEdgeIndex);
        this.myLongEdges = CompressedIntList.newInstance(longEdges);
    }

    public PermanentLinearGraphImpl() {
        this(new BitSetFlags(0), new int[0], new int[0]);
    }

    @Override
    public int nodesCount() {
        return this.mySimpleNodes.size();
    }

    @Override
    @NotNull
    public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter) {
        boolean hasUpSimpleEdge;
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/graph/impl/permanent/PermanentLinearGraphImpl", "getAdjacentEdges"));
        }
        SmartList result2 = new SmartList();
        boolean bl = hasUpSimpleEdge = nodeIndex != 0 && this.mySimpleNodes.get(nodeIndex - 1);
        if (hasUpSimpleEdge && filter.upNormal) {
            result2.add(new GraphEdge(nodeIndex - 1, nodeIndex, null, GraphEdgeType.USUAL));
        }
        for (int i2 = this.myNodeToEdgeIndex.get(nodeIndex); i2 < this.myNodeToEdgeIndex.get(nodeIndex + 1); ++i2) {
            int adjacentNode = this.myLongEdges.get(i2);
            if (adjacentNode < 0 && filter.special) {
                result2.add(GraphEdge.createEdgeWithTargetId(nodeIndex, adjacentNode, GraphEdgeType.NOT_LOAD_COMMIT));
            }
            if (adjacentNode < 0) continue;
            if (nodeIndex > adjacentNode && filter.upNormal) {
                result2.add(new GraphEdge(adjacentNode, nodeIndex, null, GraphEdgeType.USUAL));
            }
            if (nodeIndex >= adjacentNode || !filter.downNormal) continue;
            result2.add(new GraphEdge(nodeIndex, adjacentNode, null, GraphEdgeType.USUAL));
        }
        if (this.mySimpleNodes.get(nodeIndex) && filter.downNormal) {
            result2.add(new GraphEdge(nodeIndex, nodeIndex + 1, null, GraphEdgeType.USUAL));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentLinearGraphImpl", "getAdjacentEdges"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public GraphNode getGraphNode(int nodeIndex) {
        GraphNode graphNode = new GraphNode(nodeIndex);
        if (graphNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentLinearGraphImpl", "getGraphNode"));
        }
        return graphNode;
    }

    @Override
    public int getNodeId(int nodeIndex) {
        assert (nodeIndex >= 0 && nodeIndex < this.nodesCount()) : "Bad nodeIndex: " + nodeIndex;
        return nodeIndex;
    }

    @Override
    public Integer getNodeIndex(int nodeId) {
        if (nodeId >= 0 && nodeId < this.nodesCount()) {
            return nodeId;
        }
        return null;
    }
}

