/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import gnu.trove.TIntObjectHashMap;
import java.util.AbstractList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class IntIntMultiMap {
    private static final int[] EMPTY = new int[0];
    private final TIntObjectHashMap<int[]> myKeyToArrayMap = new TIntObjectHashMap();

    public void putValue(int key2, int value) {
        int[] values = (int[])this.myKeyToArrayMap.get(key2);
        if (values == null) {
            int[] newValues = new int[]{value};
            this.myKeyToArrayMap.put(key2, (Object)newValues);
        } else {
            int[] newValues = new int[values.length + 1];
            for (int i2 = 0; i2 < values.length; ++i2) {
                if (values[i2] == value) {
                    return;
                }
                newValues[i2] = values[i2];
            }
            newValues[newValues.length - 1] = value;
            this.myKeyToArrayMap.put(key2, (Object)newValues);
        }
    }

    public void remove(int key2, int value) {
        int removeIndex = -1;
        int[] values = (int[])this.myKeyToArrayMap.get(key2);
        if (values == null) {
            return;
        }
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (values[i2] != value) continue;
            removeIndex = i2;
            break;
        }
        if (removeIndex == -1) {
            return;
        }
        if (values.length == 1) {
            this.myKeyToArrayMap.remove(key2);
            return;
        }
        int[] newValues = new int[values.length - 1];
        for (int i3 = 0; i3 < newValues.length; ++i3) {
            newValues[i3] = i3 >= removeIndex ? values[i3 + 1] : values[i3];
        }
        this.myKeyToArrayMap.put(key2, (Object)newValues);
    }

    @NotNull
    public Collection<Integer> get(int key2) {
        final int[] asArray = this.getAsArray(key2);
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            @NotNull
            public Integer get(int index) {
                Integer n = asArray[index];
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap$1", "get"));
                }
                return n;
            }

            @Override
            public int size() {
                return asArray.length;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap", "get"));
        }
        return abstractList;
    }

    @NotNull
    public int[] getAsArray(int key2) {
        int[] result2 = (int[])this.myKeyToArrayMap.get(key2);
        if (result2 == null) {
            if (EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap", "getAsArray"));
            }
            return EMPTY;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap", "getAsArray"));
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.myKeyToArrayMap.isEmpty();
    }

    public boolean containsKey(int key2) {
        return this.myKeyToArrayMap.containsKey(key2);
    }

    @NotNull
    public int[] keys() {
        int[] nArray = this.myKeyToArrayMap.keys();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/IntIntMultiMap", "keys"));
        }
        return nArray;
    }

    public void clear() {
        this.myKeyToArrayMap.clear();
    }
}

