/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.IntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.graph.utils.impl.ByteArrayUtils;
import com.intellij.vcs.log.graph.utils.impl.PermanentListIntToIntMap;
import org.jetbrains.annotations.NotNull;

class IntDeltaCompressor
implements IntList {
    @NotNull
    private final byte[] myCompressedDeltas;
    @NotNull
    private final Flags myStartedDeltaIndex;
    @NotNull
    private final IntToIntMap myStartIndexMap;

    @NotNull
    public static IntDeltaCompressor newInstance(@NotNull IntList deltaList) {
        if (deltaList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deltaList", "com/intellij/vcs/log/graph/utils/impl/IntDeltaCompressor", "newInstance"));
        }
        if (deltaList.size() < 0) {
            throw new NegativeArraySizeException("size < 0: " + deltaList.size());
        }
        int bytesAfterCompression = ByteArrayUtils.countBytesAfterCompression(deltaList);
        BitSetFlags startedDeltaIndex = new BitSetFlags(bytesAfterCompression);
        byte[] compressedDeltas = new byte[bytesAfterCompression];
        int currentStartIndex = 0;
        for (int i2 = 0; i2 < deltaList.size(); ++i2) {
            startedDeltaIndex.set(currentStartIndex, true);
            int value = deltaList.get(i2);
            int sizeOf = ByteArrayUtils.sizeOf(value);
            ByteArrayUtils.writeDelta(currentStartIndex, value, sizeOf, compressedDeltas);
            currentStartIndex += sizeOf;
        }
        IntDeltaCompressor intDeltaCompressor = new IntDeltaCompressor(compressedDeltas, startedDeltaIndex, deltaList.size());
        if (intDeltaCompressor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/IntDeltaCompressor", "newInstance"));
        }
        return intDeltaCompressor;
    }

    private IntDeltaCompressor(@NotNull byte[] compressedDeltas, @NotNull Flags startedDeltaIndex, int countDeltas) {
        if (compressedDeltas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compressedDeltas", "com/intellij/vcs/log/graph/utils/impl/IntDeltaCompressor", "<init>"));
        }
        if (startedDeltaIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startedDeltaIndex", "com/intellij/vcs/log/graph/utils/impl/IntDeltaCompressor", "<init>"));
        }
        this.myCompressedDeltas = compressedDeltas;
        this.myStartedDeltaIndex = startedDeltaIndex;
        this.myStartIndexMap = PermanentListIntToIntMap.newInstance(startedDeltaIndex, countDeltas);
    }

    public int getSumOfInterval(int left, int right) {
        if (left < 0 || left > right || right > this.size()) {
            throw new IllegalArgumentException("Size is: " + this.size() + ", but interval is: (" + left + ", " + right + ")");
        }
        if (left == this.size()) {
            return 0;
        }
        int startIndex = this.myStartIndexMap.getLongIndex(left);
        int sum = 0;
        for (int i2 = 0; i2 < right - left; ++i2) {
            int sizeOf = this.getNextStartIndex(startIndex) - startIndex;
            sum += ByteArrayUtils.readDelta(startIndex, sizeOf, this.myCompressedDeltas);
            startIndex += sizeOf;
        }
        return sum;
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Size is: " + this.size() + ", but index is: " + index);
        }
        int startIndex = this.myStartIndexMap.getLongIndex(index);
        int sizeOf = this.getNextStartIndex(startIndex) - startIndex;
        return ByteArrayUtils.readDelta(startIndex, sizeOf, this.myCompressedDeltas);
    }

    @Override
    public int size() {
        return this.myStartIndexMap.shortSize();
    }

    private int getNextStartIndex(int currentIndex) {
        for (int i2 = currentIndex + 1; i2 < this.myStartedDeltaIndex.size(); ++i2) {
            if (!this.myStartedDeltaIndex.get(i2)) continue;
            return i2;
        }
        return this.myStartedDeltaIndex.size();
    }
}

