/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class IndexHighlighter
implements VcsLogHighlighter {
    public static final JBColor NOT_INDEXED_COMMIT_FOREGROUND = JBColor.BLUE;
    @NotNull
    private final VcsLogData myLogData;

    public IndexHighlighter(@NotNull VcsLogData logData) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/IndexHighlighter", "<init>"));
        }
        this.myLogData = logData;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(@NotNull VcsShortCommitDetails details, boolean isSelected) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/IndexHighlighter", "getStyle"));
        }
        if (isSelected || !Registry.is((String)"vcs.log.highlight.not.indexed")) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/IndexHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsLogIndex index = this.myLogData.getIndex();
        if (!index.isIndexed(this.myLogData.getCommitIndex((Hash)details.getId(), details.getRoot()))) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.foreground((Color)NOT_INDEXED_COMMIT_FOREGROUND);
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/IndexHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/IndexHighlighter", "getStyle"));
        }
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/IndexHighlighter", "update"));
        }
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "INDEXED_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            if (logData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/IndexHighlighter$Factory", "createHighlighter"));
            }
            if (logUi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logUi", "com/intellij/vcs/log/ui/IndexHighlighter$Factory", "createHighlighter"));
            }
            IndexHighlighter indexHighlighter = new IndexHighlighter(logData);
            if (indexHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/IndexHighlighter$Factory", "createHighlighter"));
            }
            return indexHighlighter;
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/IndexHighlighter$Factory", "getId"));
            }
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            if ("Indexed Commits" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/IndexHighlighter$Factory", "getTitle"));
            }
            return "Indexed Commits";
        }

        @Override
        public boolean showMenuItem() {
            return false;
        }
    }
}

