/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.graph.PermanentGraph;
import icons.VcsLogIcons;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class IntelliSortChooserPopupAction
extends DumbAwareAction {
    public IntelliSortChooserPopupAction() {
        super("IntelliSort", "Change IntelliSort Type", VcsLogIcons.IntelliSort);
    }

    public void actionPerformed(AnActionEvent e) {
        VcsLogUi logUI = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        DefaultActionGroup settingsGroup = new DefaultActionGroup(ContainerUtil.map((Object[])PermanentGraph.SortType.values(), sortType -> new SelectIntelliSortTypeAction(logUI, (PermanentGraph.SortType)sortType)));
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)settingsGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.MNEMONICS, true, "ToolwindowPopup");
        Component component = e.getInputEvent().getComponent();
        if (component instanceof ActionButtonComponent) {
            popup.showUnderneathOf(component);
        } else {
            popup.showInCenterOf(component);
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabled(logUI != null);
        if (logUI != null) {
            String description = "IntelliSort: " + logUI.getBekType().getName();
            e.getPresentation().setDescription(description);
            e.getPresentation().setText(description);
        }
    }

    private static class SelectIntelliSortTypeAction
    extends ToggleAction
    implements DumbAware {
        private final PermanentGraph.SortType mySortType;
        private final VcsLogUi myUI;

        public SelectIntelliSortTypeAction(VcsLogUi logUi, PermanentGraph.SortType sortType) {
            super(sortType.getName(), sortType.getDescription() + ".", null);
            this.myUI = logUi;
            this.mySortType = sortType;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/IntelliSortChooserPopupAction$SelectIntelliSortTypeAction", "update"));
            }
            super.update(e);
            e.getPresentation().setEnabled(this.myUI.areGraphActionsEnabled());
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myUI.getBekType().equals((Object)this.mySortType);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                this.myUI.setBekType(this.mySortType);
            }
        }
    }
}

