/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.List;

public class PrintIndexInfoAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (!Registry.is((String)"vcs.log.highlight.not.indexed")) {
            presentation.setEnabledAndVisible(false);
        } else {
            Project project2 = e.getProject();
            VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
            if (project2 == null || log == null) {
                presentation.setEnabledAndVisible(false);
            } else {
                VcsLogData dataManager = VcsProjectLog.getInstance(project2).getDataManager();
                if (dataManager == null) {
                    presentation.setEnabledAndVisible(false);
                } else {
                    VcsLogIndex index = dataManager.getIndex();
                    if (!(index instanceof VcsLogPersistentIndex)) {
                        presentation.setEnabledAndVisible(false);
                    } else {
                        presentation.setEnabledAndVisible(!log.getSelectedCommits().isEmpty());
                    }
                }
            }
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project2 == null || log == null) {
            return;
        }
        VcsLogData dataManager = VcsProjectLog.getInstance(project2).getDataManager();
        if (dataManager == null) {
            return;
        }
        VcsLogIndex index = dataManager.getIndex();
        if (!(index instanceof VcsLogPersistentIndex)) {
            return;
        }
        List commits = log.getSelectedCommits();
        for (CommitId commit : commits) {
            ((VcsLogPersistentIndex)index).printDebugInfoForCommit(commit);
        }
        VcsBalloonProblemNotifier.showOverChangesView(project2, "Index information for " + commits.size() + " " + StringUtil.pluralize((String)"commit", (int)commits.size()) + " was written into log file", MessageType.INFO, new NamedRunnable[0]);
    }
}

