/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.RepositoryChangesBrowser;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.actions.IntelliSortChooserPopupAction;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.frame.CommitSelectionListener;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.util.BekUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements DataProvider,
Disposable {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final VcsLog myLog;
    @NotNull
    private final VcsLogClassicFilterUi myFilterUi;
    @NotNull
    private final JBLoadingPanel myChangesLoadingPane;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final DetailsPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final RepositoryChangesBrowser myChangesBrowser;
    @NotNull
    private final Splitter myChangesBrowserSplitter;
    @NotNull
    private final SearchTextField myTextFilter;
    @NotNull
    private Runnable myContainingBranchesListener;
    @NotNull
    private Runnable myMiniDetailsLoadedListener;

    public MainFrame(@NotNull VcsLogData logData, @NotNull VcsLogUiImpl ui, @NotNull Project project2, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLog log, @NotNull VisiblePack initialDataPack) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/frame/MainFrame", "<init>"));
        }
        this.myLogData = logData;
        this.myUi = ui;
        this.myLog = log;
        this.myFilterUi = new VcsLogClassicFilterUi(this.myUi, logData, uiProperties, initialDataPack);
        this.myGraphTable = new VcsLogGraphTable(ui, logData, initialDataPack);
        this.myDetailsPanel = new DetailsPanel(logData, ui.getColorManager(), this);
        this.myChangesBrowser = new RepositoryChangesBrowser(project2, null, Collections.emptyList(), null){

            @Override
            protected void buildToolBar(DefaultActionGroup toolBarGroup) {
                super.buildToolBar(toolBarGroup);
                toolBarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.ShowDetailsAction"));
            }
        };
        this.myChangesBrowser.getViewerScrollPane().setBorder(IdeBorderFactory.createBorder((int)2));
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.getGraphTable()));
        this.myChangesBrowser.getEditSourceAction().registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)((Object)this.getGraphTable()));
        this.myChangesBrowser.getViewer().setEmptyText("");
        this.myChangesLoadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        this.myChangesLoadingPane.add((Component)this.myChangesBrowser);
        this.myDetailsSplitter = new OnePixelSplitter(true, "vcs.log.details.splitter.proportion", 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)this.myChangesLoadingPane);
        this.setupDetailsSplitter(uiProperties.isShowDetails());
        this.myGraphTable.getSelectionModel().addListSelectionListener(new CommitSelectionListenerForDiff());
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        this.updateWhenDetailsAreLoaded();
        this.myTextFilter = this.myFilterUi.createTextFilter();
        this.myToolbar = this.createActionsToolbar();
        final ProgressStripe progressStripe = new ProgressStripe(this.setupScrolledGraph(), this, 300){

            @Override
            public void updateUI() {
                super.updateUI();
                if (this.myDecorator != null && MainFrame.this.myLogData.getProgress().isRunning()) {
                    this.startLoadingImmediately();
                }
            }
        };
        this.myLogData.getProgress().addProgressIndicatorListener(new VcsLogProgress.ProgressListener(){

            @Override
            public void progressStarted() {
                progressStripe.startLoading();
            }

            @Override
            public void progressStopped() {
                progressStripe.stopLoading();
            }
        }, this);
        JPanel toolbars = new JPanel(new BorderLayout());
        toolbars.add((Component)this.myToolbar, "North");
        JPanel toolbarsAndTable = new JPanel(new BorderLayout());
        toolbarsAndTable.add((Component)toolbars, "North");
        toolbarsAndTable.add((Component)((Object)progressStripe), "Center");
        this.myChangesBrowserSplitter = new OnePixelSplitter(false, "vcs.log.changes.splitter.proportion", 0.7f);
        this.myChangesBrowserSplitter.setFirstComponent((JComponent)toolbarsAndTable);
        this.myChangesBrowserSplitter.setSecondComponent((JComponent)this.myDetailsSplitter);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myChangesBrowserSplitter);
        Disposer.register((Disposable)ui, (Disposable)this);
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new MyFocusPolicy());
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/MainFrame", "updateDataPack"));
        }
        this.myFilterUi.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack, permGraphChanged);
    }

    private void updateWhenDetailsAreLoaded() {
        this.myMiniDetailsLoadedListener = () -> {
            this.myGraphTable.initColumnSize();
            this.myGraphTable.repaint();
        };
        this.myContainingBranchesListener = () -> {
            this.myDetailsPanel.branchesChanged();
            this.myGraphTable.repaint();
        };
        this.myLogData.getMiniDetailsGetter().addDetailsLoadedListener(this.myMiniDetailsLoadedListener);
        this.myLogData.getContainingBranchesGetter().addTaskCompletedListener(this.myContainingBranchesListener);
    }

    public void setupDetailsSplitter(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    @NotNull
    private JScrollPane setupScrolledGraph() {
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myGraphTable), (int)2);
        this.myGraphTable.viewportSet(scrollPane.getViewport());
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "setupScrolledGraph"));
        }
        return jScrollPane;
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getGraphTable"));
        }
        return vcsLogGraphTable;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        VcsLogClassicFilterUi vcsLogClassicFilterUi = this.myFilterUi;
        if (vcsLogClassicFilterUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getFilterUi"));
        }
        return vcsLogClassicFilterUi;
    }

    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.Toolbar.Internal"));
        DefaultActionGroup mainGroup = new DefaultActionGroup();
        mainGroup.add((AnAction)this.myFilterUi.createActionGroup());
        mainGroup.addSeparator();
        if (BekUtil.isBekEnabled()) {
            if (BekUtil.isLinearBekEnabled()) {
                mainGroup.add((AnAction)new IntelliSortChooserPopupAction());
            } else {
                mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.IntelliSortChooser"));
            }
        }
        mainGroup.add((AnAction)toolbarGroup);
        ActionToolbar toolbar = this.createActionsToolbar(mainGroup);
        Wrapper textFilter = new Wrapper((JComponent)this.myTextFilter);
        textFilter.setVerticalSizeReferent(toolbar.getComponent());
        textFilter.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        ActionToolbar settings = this.createActionsToolbar(new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.QuickSettings")}));
        settings.setReservePlaceAutoPopupIcon(false);
        settings.setLayoutPolicy(0);
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[left]0[left, fill]push[right]", "center"));
        panel2.add((Component)textFilter);
        panel2.add(toolbar.getComponent());
        panel2.add(settings.getComponent());
        return panel2;
    }

    @NotNull
    private ActionToolbar createActionsToolbar(@NotNull DefaultActionGroup mainGroup) {
        if (mainGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainGroup", "com/intellij/vcs/log/ui/frame/MainFrame", "createActionsToolbar"));
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)mainGroup, true);
        toolbar.setTargetComponent((JComponent)this);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "createActionsToolbar"));
        }
        return actionToolbar;
    }

    @NotNull
    public JComponent getMainComponent() {
        MainFrame mainFrame = this;
        if (mainFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getMainComponent"));
        }
        return mainFrame;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (VcsLogDataKeys.VCS_LOG.is(dataId)) {
            return this.myLog;
        }
        if (VcsLogDataKeys.VCS_LOG_UI.is(dataId)) {
            return this.myUi;
        }
        if (VcsLogDataKeys.VCS_LOG_DATA_PROVIDER.is(dataId)) {
            return this.myLogData;
        }
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            return ArrayUtil.toObjectArray(this.myChangesBrowser.getCurrentDisplayedChanges(), Change.class);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            List details = this.myLog.getSelectedDetails();
            if (details.size() > 1000) {
                return null;
            }
            return ContainerUtil.map2Array((Collection)details, CommittedChangeListForRevision.class, details1 -> new CommittedChangeListForRevision(details1.getSubject(), details1.getFullMessage(), VcsUserUtil.getShortPresentation(details1.getCommitter()), new Date(details1.getCommitTime()), details1.getChanges(), (VcsRevisionNumber)MainFrame.convertToRevisionNumber((Hash)details1.getId())));
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(dataId)) {
            List hashes = this.myLog.getSelectedCommits();
            if (hashes.size() > 1000) {
                return null;
            }
            return ArrayUtil.toObjectArray((Collection)ContainerUtil.map((Collection)hashes, commitId -> MainFrame.convertToRevisionNumber(commitId.getHash())), VcsRevisionNumber.class);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            int[] selectedRows = this.myGraphTable.getSelectedRows();
            if (selectedRows.length == 0 || selectedRows.length > 1000) {
                return null;
            }
            Set roots = ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row -> this.myGraphTable.getModel().getRoot((int)row));
            if (roots.size() == 1) {
                return this.myLogData.getLogProvider((VirtualFile)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)roots))).getSupportedVcs();
            }
        } else if (VcsLogDataKeys.VCS_LOG_BRANCHES.is(dataId)) {
            int[] selectedRows = this.myGraphTable.getSelectedRows();
            if (selectedRows.length != 1) {
                return null;
            }
            return this.myGraphTable.getModel().getBranchesAtRow(selectedRows[0]);
        }
        return null;
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myToolbar;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getToolbar"));
        }
        return jComponent;
    }

    @NotNull
    public SearchTextField getTextFilter() {
        SearchTextField searchTextField = this.myTextFilter;
        if (searchTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "getTextFilter"));
        }
        return searchTextField;
    }

    public boolean areGraphActionsEnabled() {
        return this.myGraphTable.getRowCount() > 0;
    }

    @NotNull
    private static TextRevisionNumber convertToRevisionNumber(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/ui/frame/MainFrame", "convertToRevisionNumber"));
        }
        TextRevisionNumber textRevisionNumber = new TextRevisionNumber(hash.asString(), hash.toShortString());
        if (textRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame", "convertToRevisionNumber"));
        }
        return textRevisionNumber;
    }

    public void showDetails(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    public void dispose() {
        this.myLogData.getMiniDetailsGetter().removeDetailsLoadedListener(this.myMiniDetailsLoadedListener);
        this.myLogData.getContainingBranchesGetter().removeTaskCompletedListener(this.myContainingBranchesListener);
        this.myDetailsSplitter.dispose();
        this.myChangesBrowserSplitter.dispose();
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @Override
        @NotNull
        protected List<Component> getOrderedComponents() {
            List<Component> list = Arrays.asList(new Component[]{MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent(), MainFrame.this.myTextFilter.getTextEditor()});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$MyFocusPolicy", "getOrderedComponents"));
            }
            return list;
        }
    }

    private class CommitSelectionListenerForDiff
    extends CommitSelectionListener {
        protected CommitSelectionListenerForDiff() {
            super(MainFrame.this.myLogData, MainFrame.this.myGraphTable, MainFrame.this.myChangesLoadingPane);
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<VcsFullCommitDetails> detailsList) {
            if (detailsList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsList", "com/intellij/vcs/log/ui/frame/MainFrame$CommitSelectionListenerForDiff", "onDetailsLoaded"));
            }
            List<Object> changes = ContainerUtil.newArrayList();
            List detailsListReversed = ContainerUtil.reverse(detailsList);
            for (VcsFullCommitDetails details : detailsListReversed) {
                changes.addAll(details.getChanges());
            }
            changes = CommittedChangesTreeBrowser.zipChanges((List<Change>)changes);
            MainFrame.this.myChangesBrowser.setChangesToDisplay(changes);
        }

        @Override
        protected void onSelection(@NotNull int[] selection) {
            if (selection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/vcs/log/ui/frame/MainFrame$CommitSelectionListenerForDiff", "onSelection"));
            }
            MainFrame.this.myChangesBrowser.setChangesToDisplay(Collections.emptyList());
            MainFrame.this.myChangesBrowser.getViewer().setEmptyText("");
        }

        @Override
        protected void onEmptySelection() {
            MainFrame.this.myChangesBrowser.getViewer().setEmptyText("No commits selected");
            MainFrame.this.myChangesBrowser.setChangesToDisplay(Collections.emptyList());
        }
    }
}

