/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PaintParameters;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.LabelPainter;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import com.intellij.vcs.log.ui.render.RectangleReferencePainter;
import com.intellij.vcs.log.ui.render.ReferencePainter;
import com.intellij.vcs.log.ui.render.TooltipReferencesPanel;
import com.intellij.vcs.log.ui.render.TypeSafeTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphCommitCellRenderer
extends TypeSafeTableCellRenderer<GraphCommitCell> {
    private static final int MAX_GRAPH_WIDTH = 6;
    private static final int VERTICAL_PADDING = JBUI.scale((int)7);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final MyComponent myComponent;
    @NotNull
    private final MyComponent myTemplateComponent;
    @Nullable
    private final ReferencePainter myTooltipPainter;

    public GraphCommitCellRenderer(@NotNull VcsLogData logData, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer", "<init>"));
        }
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer", "<init>"));
        }
        this.myLogData = logData;
        this.myGraphTable = table;
        this.myTooltipPainter = GraphCommitCellRenderer.isRedesignedLabels() ? new LabelPainter(this.myLogData) : null;
        this.myComponent = new MyComponent(logData, painter, table);
        this.myTemplateComponent = new MyComponent(logData, painter, table);
    }

    protected SimpleColoredComponent getTableCellRendererComponentImpl(@NotNull JTable table, @NotNull GraphCommitCell value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer", "getTableCellRendererComponentImpl"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer", "getTableCellRendererComponentImpl"));
        }
        this.myComponent.customize(value, isSelected, hasFocus, row, column);
        return this.myComponent;
    }

    public static boolean isRedesignedLabels() {
        return Registry.is((String)"vcs.log.labels.redesign");
    }

    @Nullable
    public JComponent getTooltip(@NotNull Object value, @NotNull Point point, int row) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer", "getTooltip"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer", "getTooltip"));
        }
        if (this.myTooltipPainter == null) {
            return null;
        }
        GraphCommitCell cell = (GraphCommitCell)this.getValue(value);
        Collection<VcsRef> refs = cell.getRefsToThisCommit();
        if (!refs.isEmpty()) {
            this.myTooltipPainter.customizePainter((JComponent)((Object)this.myComponent), refs, this.myComponent.getBackground(), this.myComponent.getForeground(), true, this.getColumnWidth());
            if ((double)this.getReferencesWidth(row) >= (double)this.getColumnWidth() - point.getX()) {
                return new TooltipReferencesPanel(this.myLogData, this.myTooltipPainter, refs);
            }
        }
        return null;
    }

    public int getPreferredHeight() {
        return this.myComponent.getPreferredHeight();
    }

    private int getReferencesWidth(int row) {
        GraphCommitCell cell = (GraphCommitCell)this.getValue(this.myGraphTable.getModel().getValueAt(row, 1));
        Collection<VcsRef> refs = cell.getRefsToThisCommit();
        if (!refs.isEmpty()) {
            this.myTemplateComponent.customize(cell, this.myGraphTable.isRowSelected(row), this.myGraphTable.hasFocus(), row, 1);
            return this.myTemplateComponent.getReferencePainter().getSize().width;
        }
        return 0;
    }

    public int getTooltipXCoordinate(int row) {
        int referencesWidth = this.getReferencesWidth(row);
        if (referencesWidth != 0) {
            return this.getColumnWidth() - referencesWidth / 2;
        }
        return this.getColumnWidth() / 2;
    }

    private int getColumnWidth() {
        return this.myGraphTable.getColumnModel().getColumn(1).getWidth();
    }

    private static class PaintInfo {
        private final int myWidth;
        @NotNull
        private final Image myImage;

        PaintInfo(@NotNull Image image, int width) {
            if (image == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$PaintInfo", "<init>"));
            }
            this.myImage = image;
            this.myWidth = width;
        }

        @NotNull
        Image getImage() {
            Image image = this.myImage;
            if (image == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$PaintInfo", "getImage"));
            }
            return image;
        }

        int getWidth() {
            return this.myWidth;
        }
    }

    private static class MyComponent
    extends SimpleColoredRenderer {
        @NotNull
        private final VcsLogData myLogData;
        @NotNull
        private final VcsLogGraphTable myGraphTable;
        @NotNull
        private final GraphCellPainter myPainter;
        @NotNull
        private final IssueLinkRenderer myIssueLinkRenderer;
        @NotNull
        private final ReferencePainter myReferencePainter;
        @NotNull
        protected PaintInfo myGraphImage;
        @NotNull
        private Font myFont;
        private int myHeight;

        public MyComponent(@NotNull VcsLogData data, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent", "<init>"));
            }
            if (painter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent", "<init>"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent", "<init>"));
            }
            this.myGraphImage = new PaintInfo(UIUtil.createImage((int)1, (int)1, (int)2), 0);
            this.myLogData = data;
            this.myPainter = painter;
            this.myGraphTable = table;
            this.myReferencePainter = GraphCommitCellRenderer.isRedesignedLabels() ? new LabelPainter(this.myLogData) : new RectangleReferencePainter(this.myLogData);
            this.myIssueLinkRenderer = new IssueLinkRenderer(this.myLogData.getProject(), (SimpleColoredComponent)this);
            this.myFont = RectanglePainter.getFont();
            this.myHeight = this.calculateHeight();
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            int referencesSize = this.myReferencePainter.isLeftAligned() ? 0 : this.myReferencePainter.getSize().width;
            Dimension dimension = new Dimension(preferredSize.width + referencesSize, this.getPreferredHeight());
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent", "getPreferredSize"));
            }
            return dimension;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int graphImageWidth = this.myGraphImage.getWidth();
            if (!this.myReferencePainter.isLeftAligned()) {
                int start = Math.max(graphImageWidth, this.getWidth() - this.myReferencePainter.getSize().width);
                this.myReferencePainter.paint((Graphics2D)g, start, 0, this.getHeight());
            } else {
                this.myReferencePainter.paint((Graphics2D)g, graphImageWidth, 0, this.getHeight());
            }
            UIUtil.drawImage((Graphics)g, (Image)this.myGraphImage.getImage(), (int)0, (int)0, null);
        }

        public void customize(@NotNull GraphCommitCell cell, boolean isSelected, boolean hasFocus, int row, int column) {
            if (cell == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent", "customize"));
            }
            this.clear();
            this.setPaintFocusBorder(false);
            this.acquireState((JTable)((Object)this.myGraphTable), isSelected, hasFocus, row, column);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            this.setBorder(null);
            this.myGraphImage = this.getGraphImage(cell.getPrintElements());
            SimpleTextAttributes style = this.myGraphTable.applyHighlighters((Component)((Object)this), row, column, hasFocus, isSelected);
            Collection<VcsRef> refs = cell.getRefsToThisCommit();
            Color baseForeground = (Color)ObjectUtils.assertNotNull((Object)this.myGraphTable.getBaseStyle(row, column, hasFocus, isSelected).getForeground());
            this.append("");
            if (this.myReferencePainter.isLeftAligned()) {
                this.myReferencePainter.customizePainter((JComponent)((Object)this), refs, this.getBackground(), baseForeground, isSelected, 0);
                this.appendTextPadding(this.myGraphImage.getWidth() + this.myReferencePainter.getSize().width);
                this.appendText(cell, style);
            } else {
                this.appendTextPadding(this.myGraphImage.getWidth());
                this.appendText(cell, style);
                this.myReferencePainter.customizePainter((JComponent)((Object)this), refs, this.getBackground(), baseForeground, isSelected, this.getAvailableWidth(column));
            }
        }

        private void appendText(@NotNull GraphCommitCell cell, @NotNull SimpleTextAttributes style) {
            if (cell == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent", "appendText"));
            }
            if (style == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent", "appendText"));
            }
            this.myIssueLinkRenderer.appendTextWithLinks(StringUtil.replace((String)cell.getText(), (String)"\t", (String)" "), style);
        }

        private int getAvailableWidth(int column) {
            int columnWidth = this.myGraphTable.getColumnModel().getColumn(column).getWidth();
            return Math.min(columnWidth - super.getPreferredSize().width, columnWidth / 3);
        }

        private int calculateHeight() {
            return Math.max(this.myReferencePainter.getSize().height, this.getFontMetrics(this.myFont).getHeight() + VERTICAL_PADDING);
        }

        public int getPreferredHeight() {
            Font font = RectanglePainter.getFont();
            if (this.myFont != font) {
                this.myFont = font;
                this.myHeight = this.calculateHeight();
            }
            return this.myHeight;
        }

        @NotNull
        private PaintInfo getGraphImage(@NotNull Collection<? extends PrintElement> printElements) {
            if (printElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElements", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent", "getGraphImage"));
            }
            double maxIndex = 0.0;
            for (PrintElement printElement : printElements) {
                maxIndex = Math.max(maxIndex, (double)printElement.getPositionInCurrentRow());
                if (!(printElement instanceof EdgePrintElement)) continue;
                maxIndex = Math.max(maxIndex, (double)(printElement.getPositionInCurrentRow() + ((EdgePrintElement)printElement).getPositionInOtherRow()) / 2.0);
            }
            maxIndex += 1.0;
            maxIndex = Math.max(maxIndex, (double)Math.min(6, this.myGraphTable.getVisibleGraph().getRecommendedWidth()));
            BufferedImage image = UIUtil.createImage((int)((int)((double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()) * (maxIndex + 2.0))), (int)this.myGraphTable.getRowHeight(), (int)2);
            Graphics2D graphics2D = image.createGraphics();
            this.myPainter.draw(graphics2D, printElements);
            int width = (int)(maxIndex * (double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()));
            PaintInfo paintInfo = new PaintInfo(image, width);
            if (paintInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent", "getGraphImage"));
            }
            return paintInfo;
        }

        @NotNull
        public ReferencePainter getReferencePainter() {
            ReferencePainter referencePainter = this.myReferencePainter;
            if (referencePainter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent", "getReferencePainter"));
            }
            return referencePainter;
        }
    }
}

