/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LabelIcon
implements Icon {
    private final int mySize;
    @NotNull
    private final Color[] myColors;
    @NotNull
    private final Color myBgColor;

    public LabelIcon(int size, @NotNull Color bgColor, Color ... colors) {
        if (bgColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bgColor", "com/intellij/vcs/log/ui/render/LabelIcon", "<init>"));
        }
        if (colors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/vcs/log/ui/render/LabelIcon", "<init>"));
        }
        this.mySize = size;
        this.myBgColor = bgColor;
        this.myColors = colors;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        float scale = (float)this.mySize / 8.0f;
        for (int i2 = this.myColors.length - 1; i2 >= 0; --i2) {
            if (i2 != this.myColors.length - 1) {
                g2.setColor(this.myBgColor);
                this.paintTag(g2, scale, x + Math.round(scale * 2.0f) * i2 + 1, y);
            }
            g2.setColor(this.myColors[i2]);
            this.paintTag(g2, scale, x + Math.round(scale * 2.0f) * i2, y);
        }
        config.restore();
    }

    public void paintTag(Graphics2D g2, float scale, int x, int y) {
        Path2D.Float path = new Path2D.Float();
        path.moveTo((float)x + 1.0f * scale, (float)y + 2.0f * scale);
        path.lineTo((float)x + 3.0f * scale, (float)y + 2.0f * scale);
        path.lineTo((float)x + 6.0f * scale, (float)y + 5.0f * scale);
        path.lineTo((float)x + 4.0f * scale, (float)y + 7.0f * scale);
        path.lineTo((float)x + 1.0f * scale, (float)y + 4.0f * scale);
        path.lineTo((float)x + 1.0f * scale, (float)y + 2.0f * scale);
        path.closePath();
        Ellipse2D.Float hole = new Ellipse2D.Float((float)x + 2.0f * scale, (float)y + 3.0f * scale, scale, scale);
        Area area = new Area(path);
        area.subtract(new Area(hole));
        g2.fill(area);
    }

    @Override
    public int getIconWidth() {
        return this.getWidth(this.myColors.length);
    }

    protected int getWidth(int labelsCount) {
        return LabelIcon.getWidth(this.mySize, labelsCount);
    }

    public static int getWidth(int height, int labelsCount) {
        return height + height * (labelsCount - 1) / 4;
    }

    @Override
    public int getIconHeight() {
        return this.mySize;
    }
}

