/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import com.intellij.vcs.log.ui.render.ReferencePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPainter
implements ReferencePainter {
    public static final int TOP_TEXT_PADDING = JBUI.scale((int)1);
    public static final int BOTTOM_TEXT_PADDING = JBUI.scale((int)2);
    public static final int RIGHT_PADDING = JBUI.scale((int)2);
    public static final int LEFT_PADDING = JBUI.scale((int)2);
    public static final int MIDDLE_PADDING = JBUI.scale((int)2);
    private static final int MAX_LENGTH = 22;
    private static final String THREE_DOTS = "...";
    private static final String TWO_DOTS = "..";
    private static final String SEPARATOR = "/";
    private static final JBColor BACKGROUND = new JBColor(Color.BLACK, Color.WHITE);
    private static final float BALANCE = 0.08f;
    private static final JBColor TEXT_COLOR = new JBColor(new Color(0x7A7A7A), new Color(0x909090));
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private List<Pair<String, LabelIcon>> myLabels;
    private int myHeight;
    private int myWidth;
    @NotNull
    private Color myBackground;
    @Nullable
    private Color myGreyBackground;
    @NotNull
    private Color myForeground;

    public LabelPainter(@NotNull VcsLogData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/vcs/log/ui/render/LabelPainter", "<init>"));
        }
        this.myLabels = ContainerUtil.newArrayList();
        this.myHeight = JBUI.scale((int)22);
        this.myWidth = 0;
        this.myBackground = UIUtil.getTableBackground();
        this.myGreyBackground = null;
        this.myForeground = UIUtil.getTableForeground();
        this.myLogData = data;
    }

    @Override
    public void customizePainter(@NotNull JComponent component, @NotNull Collection<VcsRef> references, @NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/vcs/log/ui/render/LabelPainter", "customizePainter"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/vcs/log/ui/render/LabelPainter", "customizePainter"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/vcs/log/ui/render/LabelPainter", "customizePainter"));
        }
        if (foreground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreground", "com/intellij/vcs/log/ui/render/LabelPainter", "customizePainter"));
        }
        this.myBackground = background;
        this.myForeground = isSelected ? foreground : TEXT_COLOR;
        FontMetrics metrics = component.getFontMetrics(this.getReferenceFont());
        this.myHeight = metrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING;
        VcsLogRefManager manager = ReferencePainter.getRefManager(this.myLogData, references);
        List refGroups = manager == null ? ContainerUtil.emptyList() : manager.groupForTable(references);
        this.myGreyBackground = LabelPainter.calculateGreyBackground(refGroups, background, isSelected);
        Pair<List<Pair<String, LabelIcon>>, Integer> presentation = LabelPainter.calculatePresentation(refGroups, metrics, this.myHeight, this.myGreyBackground != null ? this.myGreyBackground : this.myBackground, availableWidth);
        this.myLabels = (List)presentation.first;
        this.myWidth = (Integer)presentation.second;
    }

    @NotNull
    private static Pair<List<Pair<String, LabelIcon>>, Integer> calculatePresentation(@NotNull List<RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int height, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refGroups", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
        }
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
        }
        int width = LEFT_PADDING + RIGHT_PADDING;
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            Pair pair = Pair.create((Object)labels, (Object)width);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
            }
            return pair;
        }
        for (RefGroup group : refGroups) {
            if (group.isExpanded()) {
                for (VcsRef ref : group.getRefs()) {
                    LabelIcon labelIcon = new LabelIcon(height, background, ref.getType().getBackgroundColor());
                    String text = LabelPainter.shortenRefName(ref.getName(), fontMetrics, availableWidth - (width += labelIcon.getIconWidth() + MIDDLE_PADDING));
                    width += fontMetrics.stringWidth(text);
                    labels.add(Pair.create((Object)text, (Object)labelIcon));
                }
                continue;
            }
            LabelIcon labelIcon = new LabelIcon(height, background, LabelPainter.getGroupColors(group));
            String text = LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth - (width += labelIcon.getIconWidth() + MIDDLE_PADDING));
            width += fontMetrics.stringWidth(text);
            labels.add(Pair.create((Object)text, (Object)labelIcon));
        }
        Pair pair = Pair.create((Object)labels, (Object)width);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
        }
        return pair;
    }

    @Nullable
    private static Color calculateGreyBackground(@NotNull List<RefGroup> refGroups, @NotNull Color background, boolean isSelected) {
        if (refGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refGroups", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateGreyBackground"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateGreyBackground"));
        }
        if (isSelected) {
            return null;
        }
        for (RefGroup group : refGroups) {
            boolean paintGreyBackground;
            if (group.isExpanded()) {
                paintGreyBackground = ContainerUtil.find((Iterable)group.getRefs(), ref -> !ref.getName().isEmpty()) != null;
            } else {
                boolean bl = paintGreyBackground = !group.getName().isEmpty();
            }
            if (!paintGreyBackground) continue;
            return ColorUtil.mix((Color)background, (Color)BACKGROUND, (double)0.08f);
        }
        return null;
    }

    @NotNull
    private static String shortenRefName(@NotNull String refName, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (refName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
        }
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
        }
        if (fontMetrics.stringWidth(refName) > availableWidth && refName.length() > 22) {
            int separatorIndex = refName.indexOf(SEPARATOR);
            if (separatorIndex > TWO_DOTS.length()) {
                refName = TWO_DOTS + refName.substring(separatorIndex);
            }
            if (fontMetrics.stringWidth(refName) <= availableWidth) {
                String string = refName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
                }
                return string;
            }
            if (availableWidth > 0) {
                for (int i2 = refName.length(); i2 > 22; --i2) {
                    String result2 = StringUtil.shortenTextWithEllipsis((String)refName, (int)i2, (int)0, (String)THREE_DOTS);
                    if (fontMetrics.stringWidth(result2) > availableWidth) continue;
                    String string = result2;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
                    }
                    return string;
                }
            }
            String string = StringUtil.shortenTextWithEllipsis((String)refName, (int)22, (int)0, (String)THREE_DOTS);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
            }
            return string;
        }
        String string = refName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
        }
        return string;
    }

    @NotNull
    public static Color[] getGroupColors(@NotNull RefGroup group) {
        Color[] colors;
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/vcs/log/ui/render/LabelPainter", "getGroupColors"));
        }
        MultiMap referencesByType = ContainerUtil.groupBy((Iterable)group.getRefs(), VcsRef::getType);
        if (referencesByType.size() == 1) {
            Color[] colorArray;
            Map.Entry firstItem = (Map.Entry)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)referencesByType.entrySet()));
            boolean multiple = ((Collection)firstItem.getValue()).size() > 1;
            Color color = ((VcsRefType)firstItem.getKey()).getBackgroundColor();
            if (multiple) {
                Color[] colorArray2 = new Color[2];
                colorArray2[0] = color;
                colorArray = colorArray2;
                colorArray2[1] = color;
            } else {
                Color[] colorArray3 = new Color[1];
                colorArray = colorArray3;
                colorArray3[0] = color;
            }
            colors = colorArray;
        } else {
            ArrayList colorsList = ContainerUtil.newArrayList();
            for (VcsRefType type : referencesByType.keySet()) {
                if (referencesByType.get((Object)type).size() > 1) {
                    colorsList.add(type.getBackgroundColor());
                }
                colorsList.add(type.getBackgroundColor());
            }
            colors = colorsList.toArray(new Color[colorsList.size()]);
        }
        if (colors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "getGroupColors"));
        }
        return colors;
    }

    @Override
    public void paint(@NotNull Graphics2D g2, int x, int y, int height) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/LabelPainter", "paint"));
        }
        if (this.myLabels.isEmpty()) {
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setFont(this.getReferenceFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        g2.setColor(this.myBackground);
        g2.fillRect(x, y, this.myWidth, height);
        if (this.myGreyBackground != null) {
            g2.setColor(this.myGreyBackground);
            g2.fillRect(x, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING, this.myWidth - RIGHT_PADDING + LEFT_PADDING, fontMetrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING);
        }
        x += LEFT_PADDING;
        for (Pair<String, LabelIcon> label : this.myLabels) {
            LabelIcon icon = (LabelIcon)label.second;
            String text = (String)label.first;
            icon.paintIcon(null, g2, x, y + (height - icon.getIconHeight()) / 2);
            g2.setColor(this.myForeground);
            g2.drawString(text, x += icon.getIconWidth(), y + baseLine);
            x += fontMetrics.stringWidth(text) + MIDDLE_PADDING;
        }
        config.restore();
    }

    @Override
    public Dimension getSize() {
        if (this.myLabels.isEmpty()) {
            return new Dimension();
        }
        return new Dimension(this.myWidth, this.myHeight);
    }

    @Override
    public boolean isLeftAligned() {
        return false;
    }

    @Override
    public Font getReferenceFont() {
        Font font = RectanglePainter.getFont();
        return font.deriveFont((float)font.getSize() - 1.0f);
    }
}

