/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import com.intellij.vcs.log.ui.render.ReferencePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RectangleReferencePainter
implements ReferencePainter {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private List<Pair<String, Color>> myLabels;
    private int myHeight;
    private int myWidth;
    private final RectanglePainter myLabelPainter;

    public RectangleReferencePainter(@NotNull VcsLogData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/vcs/log/ui/render/RectangleReferencePainter", "<init>"));
        }
        this.myLabels = ContainerUtil.newArrayList();
        this.myHeight = JBUI.scale((int)22);
        this.myWidth = 0;
        this.myLabelPainter = new RectanglePainter(false){

            @Override
            protected Font getLabelFont() {
                return RectangleReferencePainter.this.getReferenceFont();
            }
        };
        this.myLogData = data;
    }

    @Override
    public void customizePainter(@NotNull JComponent component, @NotNull Collection<VcsRef> references, @NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/vcs/log/ui/render/RectangleReferencePainter", "customizePainter"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/vcs/log/ui/render/RectangleReferencePainter", "customizePainter"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/vcs/log/ui/render/RectangleReferencePainter", "customizePainter"));
        }
        if (foreground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreground", "com/intellij/vcs/log/ui/render/RectangleReferencePainter", "customizePainter"));
        }
        FontMetrics metrics = component.getFontMetrics(this.getReferenceFont());
        this.myHeight = metrics.getHeight() + RectanglePainter.TOP_TEXT_PADDING + RectanglePainter.BOTTOM_TEXT_PADDING;
        this.myWidth = 6;
        this.myLabels = ContainerUtil.newArrayList();
        VcsLogRefManager manager = ReferencePainter.getRefManager(this.myLogData, references);
        if (manager == null) {
            return;
        }
        List sorted = ContainerUtil.sorted(references, (Comparator)manager.getLabelsOrderComparator());
        for (Map.Entry entry : ContainerUtil.groupBy((Iterable)sorted, VcsRef::getType).entrySet()) {
            VcsRef ref = (VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())));
            String text = ref.getName() + (((Collection)entry.getValue()).size() > 1 ? " +" : "");
            this.myLabels.add((Pair<String, Color>)Pair.create((Object)text, (Object)((VcsRefType)entry.getKey()).getBackgroundColor()));
            this.myWidth = (int)((double)this.myWidth + (this.myLabelPainter.calculateSize(text, metrics).getWidth() + 3.0));
        }
    }

    @Override
    public void paint(@NotNull Graphics2D g2, int x, int y, int height) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/RectangleReferencePainter", "paint"));
        }
        if (this.myLabels.isEmpty()) {
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setFont(this.getReferenceFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        x += 3;
        for (Pair<String, Color> label : this.myLabels) {
            Dimension size = this.myLabelPainter.calculateSize((String)label.first, fontMetrics);
            int paddingY = y + (height - size.height) / 2;
            this.myLabelPainter.paint(g2, (String)label.first, x, paddingY, RectangleReferencePainter.getLabelColor((Color)label.second));
            x += size.width + 3;
        }
        config.restore();
    }

    @NotNull
    public static Color getLabelColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/ui/render/RectangleReferencePainter", "getLabelColor"));
        }
        color = UIUtil.isUnderDarcula() ? ColorUtil.darker((Color)color, (int)6) : ColorUtil.brighter((Color)color, (int)6);
        Color color2 = ColorUtil.desaturate((Color)color, (int)3);
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/RectangleReferencePainter", "getLabelColor"));
        }
        return color2;
    }

    @Override
    public Dimension getSize() {
        if (this.myLabels.isEmpty()) {
            return new Dimension();
        }
        return new Dimension(this.myWidth, this.myHeight);
    }

    @Override
    public boolean isLeftAligned() {
        return true;
    }
}

