/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PersistentUtil {
    @NotNull
    public static final File LOG_CACHE = new File(PathManager.getSystemPath(), "vcs-log");
    @NotNull
    private static final String CORRUPTION_MARKER = "corruption.marker";

    @NotNull
    public static String calcLogId(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/util/PersistentUtil", "calcLogId"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/util/PersistentUtil", "calcLogId"));
        }
        int hashcode = PersistentUtil.calcLogProvidersHash(logProviders);
        String string = project2.getLocationHash() + "." + Integer.toHexString(hashcode);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "calcLogId"));
        }
        return string;
    }

    private static int calcLogProvidersHash(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/util/PersistentUtil", "calcLogProvidersHash"));
        }
        List sortedRoots = ContainerUtil.sorted(logProviders.keySet(), (o1, o2) -> o1.getPath().compareTo(o2.getPath()));
        return StringUtil.join((Collection)sortedRoots, root -> {
            if (logProviders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/util/PersistentUtil", "lambda$calcLogProvidersHash$1"));
            }
            return root.getPath() + "." + ((VcsLogProvider)logProviders.get(root)).getSupportedVcs().getName();
        }, (String)".").hashCode();
    }

    @NotNull
    public static File getStorageFile(@NotNull String storageKind, @NotNull String logId, int version) {
        if (storageKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageKind", "com/intellij/vcs/log/util/PersistentUtil", "getStorageFile"));
        }
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/util/PersistentUtil", "getStorageFile"));
        }
        File subdir = new File(LOG_CACHE, storageKind);
        String safeLogId = PathUtilRt.suggestFileName((String)logId, (boolean)true, (boolean)true);
        File mapFile = new File(subdir, safeLogId + "." + version);
        if (!mapFile.exists()) {
            IOUtil.deleteAllFilesStartingWith((File)new File(subdir, safeLogId));
        }
        File file2 = mapFile;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "getStorageFile"));
        }
        return file2;
    }

    public static void cleanupOldStorageFile(@NotNull String storageKind, @NotNull String logId, int version) {
        if (storageKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageKind", "com/intellij/vcs/log/util/PersistentUtil", "cleanupOldStorageFile"));
        }
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/util/PersistentUtil", "cleanupOldStorageFile"));
        }
        IOUtil.deleteAllFilesStartingWith((File)PersistentUtil.getStorageFile(storageKind, logId, version));
    }

    @NotNull
    public static <T> PersistentEnumeratorBase<T> createPersistentEnumerator(@NotNull KeyDescriptor<T> keyDescriptor, @NotNull String storageKind, @NotNull String logId, int version) throws IOException {
        if (keyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentEnumerator"));
        }
        if (storageKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageKind", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentEnumerator"));
        }
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentEnumerator"));
        }
        File storageFile = PersistentUtil.getStorageFile(storageKind, logId, version);
        PersistentEnumeratorBase persistentEnumeratorBase = (PersistentEnumeratorBase)IOUtil.openCleanOrResetBroken(() -> {
            if (keyDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "com/intellij/vcs/log/util/PersistentUtil", "lambda$createPersistentEnumerator$2"));
            }
            return new PersistentBTreeEnumerator(storageFile, keyDescriptor, Page.PAGE_SIZE, null, version);
        }, (File)storageFile);
        if (persistentEnumeratorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentEnumerator"));
        }
        return persistentEnumeratorBase;
    }

    @NotNull
    public static <V> PersistentHashMap<Integer, V> createPersistentHashMap(@NotNull DataExternalizer<V> externalizer, @NotNull String storageKind, @NotNull String logId, int version) throws IOException {
        if (externalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentHashMap"));
        }
        if (storageKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageKind", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentHashMap"));
        }
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentHashMap"));
        }
        File storageFile = PersistentUtil.getStorageFile(storageKind, logId, version);
        PersistentHashMap persistentHashMap = (PersistentHashMap)IOUtil.openCleanOrResetBroken(() -> {
            if (externalizer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/vcs/log/util/PersistentUtil", "lambda$createPersistentHashMap$3"));
            }
            return new PersistentHashMap(storageFile, (KeyDescriptor)new IntInlineKeyDescriptor(), externalizer, Page.PAGE_SIZE);
        }, (File)storageFile);
        if (persistentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentHashMap"));
        }
        return persistentHashMap;
    }

    @NotNull
    public static File getCorruptionMarkerFile() {
        File file2 = new File(LOG_CACHE, CORRUPTION_MARKER);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "getCorruptionMarkerFile"));
        }
        return file2;
    }
}

