/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XAddToWatchesFromEditorActionHandler
extends XDebuggerActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler", "isEnabled"));
        }
        return XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session2) != null;
    }

    @Nullable
    protected static String getTextToEvaluate(DataContext dataContext, XDebugSession session2) {
        XDebuggerEvaluator evaluator;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text == null && (evaluator = session2.getDebugProcess().getEvaluator()) != null) {
            text = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, editor.getProject(), editor);
        }
        return StringUtil.nullize((String)text, (boolean)true);
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler", "perform"));
        }
        String text = XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session2);
        if (text == null) {
            return;
        }
        ((XDebugSessionImpl)session2).getSessionTab().getWatchesView().addWatchExpression(XExpressionImpl.fromText(text), -1, true);
    }
}

