/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ObjectLongHashMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerEditorLinePainter
extends EditorLinePainter {
    public static final Key<Map<Variable, VariableValue>> CACHE = Key.create((String)"debug.inline.variables.cache");
    private static final int LINE_EXTENSIONS_MAX_COUNT = 200;

    @Override
    public Collection<LineExtensionInfo> getLineExtensions(@NotNull Project project2, @NotNull VirtualFile file2, int lineNumber) {
        Long timestamp;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/XDebuggerEditorLinePainter", "getLineExtensions"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/evaluate/XDebuggerEditorLinePainter", "getLineExtensions"));
        }
        if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowValuesInline()) {
            return null;
        }
        XVariablesView.InlineVariablesInfo data = (XVariablesView.InlineVariablesInfo)project2.getUserData(XVariablesView.DEBUG_VARIABLES);
        ObjectLongHashMap timestamps = (ObjectLongHashMap)project2.getUserData(XVariablesView.DEBUG_VARIABLES_TIMESTAMPS);
        Document doc = FileDocumentManager.getInstance().getDocument(file2);
        if (data == null || timestamps == null || doc == null) {
            return null;
        }
        HashMap<Variable, VariableValue> oldValues = (HashMap<Variable, VariableValue>)project2.getUserData(CACHE);
        if (oldValues == null) {
            oldValues = new HashMap<Variable, VariableValue>();
            project2.putUserData(CACHE, oldValues);
        }
        if ((timestamp = Long.valueOf(timestamps.get((Object)file2))) == -1L || timestamp < doc.getModificationStamp()) {
            return null;
        }
        List<XValueNodeImpl> values = data.get(file2, lineNumber);
        if (values != null && !values.isEmpty()) {
            XDebugSession session2 = XDebugView.getSession((Component)((Object)values.iterator().next().getTree()));
            int bpLine = XDebuggerEditorLinePainter.getCurrentBreakPointLineInFile(session2, file2);
            boolean isTopFrame = session2 instanceof XDebugSessionImpl && ((XDebugSessionImpl)session2).isTopFrameSelected();
            TextAttributes attributes = bpLine == lineNumber && isTopFrame && ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)project2)).isFullLineHighlighter() ? XDebuggerEditorLinePainter.getTopFrameSelectedAttributes() : XDebuggerEditorLinePainter.getNormalAttributes();
            ArrayList<VariableText> result2 = new ArrayList<VariableText>();
            for (XValueNodeImpl value : values) {
                SimpleColoredText simpleColoredText;
                block16: {
                    simpleColoredText = new SimpleColoredText();
                    XValueTextRendererImpl renderer = new XValueTextRendererImpl((ColoredTextContainer)simpleColoredText);
                    XValuePresentation presentation = value.getValuePresentation();
                    if (presentation == null) continue;
                    try {
                        String type;
                        if (presentation instanceof XValueCompactPresentation && !value.getTree().isUnderRemoteDebug()) {
                            ((XValueCompactPresentation)presentation).renderValue(renderer, value);
                        } else {
                            presentation.renderValue((XValuePresentation.XValueTextRenderer)renderer);
                        }
                        if (!StringUtil.isEmpty((String)simpleColoredText.toString()) || StringUtil.isEmpty((String)(type = value.getValuePresentation().getType()))) break block16;
                        simpleColoredText.append(type, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    catch (Exception ignored) {
                        continue;
                    }
                }
                String name = value.getName();
                if (StringUtil.isEmpty((String)simpleColoredText.toString())) continue;
                VariableText res = new VariableText();
                result2.add(res);
                res.add(new LineExtensionInfo("  " + name + ": ", attributes));
                Variable var = new Variable(name, lineNumber);
                VariableValue variableValue = oldValues.computeIfAbsent(var, k -> new VariableValue(simpleColoredText.toString(), null, value.hashCode()));
                if (variableValue.valueNodeHashCode != value.hashCode()) {
                    variableValue.old = variableValue.actual;
                    variableValue.actual = simpleColoredText.toString();
                    variableValue.valueNodeHashCode = value.hashCode();
                }
                if (!variableValue.isChanged()) {
                    for (String s : simpleColoredText.getTexts()) {
                        res.add(new LineExtensionInfo(s, attributes));
                    }
                    continue;
                }
                variableValue.produceChangedParts(res.infos);
            }
            ArrayList<LineExtensionInfo> infos = new ArrayList<LineExtensionInfo>();
            for (VariableText variableText : result2) {
                infos.addAll(variableText.infos);
            }
            return infos.size() > 200 ? infos.subList(0, 200) : infos;
        }
        return null;
    }

    private static int getCurrentBreakPointLineInFile(@Nullable XDebugSession session2, VirtualFile file2) {
        try {
            XSourcePosition position;
            if (session2 != null && (position = session2.getCurrentPosition()) != null && position.getFile().equals(file2)) {
                return position.getLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static boolean isDarkEditor() {
        Color bg = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        return ColorUtil.isDark((Color)bg);
    }

    public static TextAttributes getNormalAttributes() {
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES);
        if (attributes == null || attributes.getForegroundColor() == null) {
            return new TextAttributes((Color)new JBColor(() -> XDebuggerEditorLinePainter.isDarkEditor() ? new Color(4030565) : Gray._135), null, null, null, 2);
        }
        return attributes;
    }

    public static TextAttributes getChangedAttributes() {
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES_MODIFIED);
        if (attributes == null || attributes.getForegroundColor() == null) {
            return new TextAttributes((Color)new JBColor(() -> XDebuggerEditorLinePainter.isDarkEditor() ? new Color(10584842) : new Color(13271073)), null, null, null, 2);
        }
        return attributes;
    }

    private static TextAttributes getTopFrameSelectedAttributes() {
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
        if (attributes == null || attributes.getForegroundColor() == null) {
            return new TextAttributes(XDebuggerEditorLinePainter.isDarkEditor() ? new Color(255, 235, 9) : new Color(0, 255, 86), null, null, null, 2);
        }
        return attributes;
    }

    private static class VariableText {
        final List<LineExtensionInfo> infos = new ArrayList<LineExtensionInfo>();
        int length = 0;

        private VariableText() {
        }

        void add(LineExtensionInfo info) {
            this.infos.add(info);
            this.length += info.getText().length();
        }
    }

    static class VariableValue {
        private String actual;
        private String old;
        private int valueNodeHashCode;

        public VariableValue(String actual, String old, int valueNodeHashCode) {
            this.actual = actual;
            this.old = old;
            this.valueNodeHashCode = valueNodeHashCode;
        }

        public boolean isChanged() {
            return this.old != null && !StringUtil.equals((CharSequence)this.actual, (CharSequence)this.old);
        }

        public void produceChangedParts(List<LineExtensionInfo> result2) {
            if (VariableValue.isArray(this.actual) && VariableValue.isArray(this.old)) {
                List<String> actualParts = VariableValue.getArrayParts(this.actual);
                List<String> oldParts = VariableValue.getArrayParts(this.old);
                result2.add(new LineExtensionInfo("{", XDebuggerEditorLinePainter.getNormalAttributes()));
                for (int i2 = 0; i2 < actualParts.size(); ++i2) {
                    if (i2 < oldParts.size() && StringUtil.equals((CharSequence)actualParts.get(i2), (CharSequence)oldParts.get(i2))) {
                        result2.add(new LineExtensionInfo(actualParts.get(i2), XDebuggerEditorLinePainter.getNormalAttributes()));
                    } else {
                        result2.add(new LineExtensionInfo(actualParts.get(i2), XDebuggerEditorLinePainter.getChangedAttributes()));
                    }
                    if (i2 == actualParts.size() - 1) continue;
                    result2.add(new LineExtensionInfo(", ", XDebuggerEditorLinePainter.getNormalAttributes()));
                }
                result2.add(new LineExtensionInfo("}", XDebuggerEditorLinePainter.getNormalAttributes()));
                return;
            }
            result2.add(new LineExtensionInfo(this.actual, XDebuggerEditorLinePainter.getChangedAttributes()));
        }

        private static boolean isArray(String s) {
            return s != null && s.startsWith("{") && s.endsWith("}");
        }

        private static List<String> getArrayParts(String array) {
            return StringUtil.split((String)array.substring(1, array.length() - 1), (String)", ");
        }
    }

    static class Variable {
        private final int lineNumber;
        private final String name;

        public Variable(String name, int lineNumber) {
            this.lineNumber = lineNumber;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            if (this.lineNumber != variable.lineNumber) {
                return false;
            }
            return this.name.equals(variable.name);
        }

        public int hashCode() {
            int result2 = this.lineNumber;
            result2 = 31 * result2 + this.name.hashCode();
            return result2;
        }
    }
}

