/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.ui.EmptyIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ColorIconCache {
    private static final ColorIconCache INSTANCE = new ColorIconCache();
    private static final SoftFactoryMap<Color, Map<Integer, Icon>> ourCache = new SoftFactoryMap<Color, Map<Integer, Icon>>(){

        protected Map<Integer, Icon> create(Color key2) {
            return new HashMap();
        }
    };

    private ColorIconCache() {
    }

    public static ColorIconCache getIconCache() {
        return INSTANCE;
    }

    public Icon getIcon(@NotNull Color color, int size) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/xml/util/ColorIconCache", "getIcon"));
        }
        Object icon = (Icon)((Map)ourCache.get((Object)color)).get(size);
        if (icon == null) {
            icon = new ColorIcon(size, color);
            ((Map)ourCache.get((Object)color)).put(size, icon);
        }
        return icon;
    }

    public static class ColorIcon
    extends EmptyIcon {
        private Color myColor;
        private Color[] myColours;

        public ColorIcon(int size, Color color) {
            super(size);
            this.myColor = color;
        }

        public ColorIcon(int size, Color[] colours) {
            super(size);
            this.myColours = colours;
        }

        public void paintIcon(Component component, Graphics g, int i2, int j) {
            int iconWidth = this.getIconWidth();
            int iconHeight = this.getIconHeight();
            if (this.myColor != null) {
                g.setColor(this.myColor);
                g.fillRect(i2, j, iconWidth, iconHeight);
            } else if (this.myColours != null) {
                Color top = this.myColours[0];
                g.setColor(top);
                g.fillRect(i2, j, iconWidth, 2);
                Color right = this.myColours[1];
                g.setColor(right);
                g.fillRect(i2 + iconWidth / 2, j + 2, iconWidth / 2, iconHeight / 2);
                Color bottom = this.myColours[2];
                g.setColor(bottom);
                g.fillRect(i2, j + iconHeight - 2, iconWidth, 2);
                Color left = this.myColours[3];
                g.setColor(left);
                g.fillRect(i2, j + 2, iconWidth / 2, iconHeight / 2);
            }
            Composite old = ((Graphics2D)g).getComposite();
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.1f));
            g.setColor(Color.BLACK);
            g.drawRect(i2, j, iconWidth - 1, iconHeight - 1);
            ((Graphics2D)g).setComposite(old);
        }
    }
}

