/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension.schema;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.jsonSchema.JsonSchemaFileType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaFileIndex
extends FileBasedIndexExtension<String, Integer> {
    public static final ID<String, Integer> PROPERTIES_INDEX = ID.create((String)"json.schema.properties.index");
    public static final int VERSION = 9;
    private IntInlineKeyDescriptor myKeyDescriptor = new IntInlineKeyDescriptor();

    @NotNull
    public ID<String, Integer> getName() {
        ID<String, Integer> iD = PROPERTIES_INDEX;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaFileIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Integer, FileContent> getIndexer() {
        DataIndexer<String, Integer, FileContent> dataIndexer = new DataIndexer<String, Integer, FileContent>(){

            @NotNull
            public Map<String, Integer> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaFileIndex$1", "map"));
                }
                final HashMap<String, Integer> map = new HashMap<String, Integer>();
                PsiFile file2 = inputData.getPsiFile();
                if (file2 instanceof JsonFile) {
                    file2.accept((PsiElementVisitor)new JsonRecursiveElementVisitor(){
                        private String myPrefix = "";

                        @Override
                        public void visitProperty(@NotNull JsonProperty property) {
                            if (property == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaFileIndex$1$1", "visitProperty"));
                            }
                            String wasPrefix = this.myPrefix;
                            this.myPrefix = this.myPrefix + "/" + property.getName();
                            map.put(this.myPrefix, property.getTextRange().getStartOffset());
                            super.visitProperty(property);
                            this.myPrefix = wasPrefix;
                        }
                    });
                }
                HashMap<String, Integer> hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaFileIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaFileIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaFileIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        IntInlineKeyDescriptor intInlineKeyDescriptor = this.myKeyDescriptor;
        if (intInlineKeyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaFileIndex", "getValueExternalizer"));
        }
        return intInlineKeyDescriptor;
    }

    public int getVersion() {
        return 9;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JsonSchemaFileType.INSTANCE});
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaFileIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }
}

