/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaObject {
    private String myDefinitionAddress;
    private Map<String, JsonSchemaObject> myDefinitions;
    private Map<String, JsonSchemaObject> myProperties;
    private Map<String, JsonSchemaObject> myPatternProperties;
    private final PatternCalculator myPatternCalculator = new PatternCalculator();
    private String myId;
    private String mySchema;
    private String myDescription;
    private String myTitle;
    private JsonSchemaType myType;
    private Object myDefault;
    private String myRef;
    private String myFormat;
    private List<JsonSchemaType> myTypeVariants;
    private Number myMultipleOf;
    private Number myMaximum;
    private boolean myExclusiveMaximum;
    private Number myMinimum;
    private boolean myExclusiveMinimum;
    private Integer myMaxLength;
    private Integer myMinLength;
    private String myPattern;
    private Boolean myAdditionalPropertiesAllowed = true;
    private JsonSchemaObject myAdditionalPropertiesSchema;
    private Boolean myAdditionalItemsAllowed = true;
    private JsonSchemaObject myAdditionalItemsSchema;
    private JsonSchemaObject myItemsSchema;
    private List<JsonSchemaObject> myItemsSchemaList;
    private Integer myMaxItems;
    private Integer myMinItems;
    private boolean myUniqueItems;
    private Integer myMaxProperties;
    private Integer myMinProperties;
    private List<String> myRequired;
    private Map<String, List<String>> myPropertyDependencies;
    private Map<String, JsonSchemaObject> mySchemaDependencies;
    private List<Object> myEnum;
    private List<JsonSchemaObject> myAllOf;
    private List<JsonSchemaObject> myAnyOf;
    private List<JsonSchemaObject> myOneOf;
    private JsonSchemaObject myNot;

    public JsonSchemaObject() {
        this.myProperties = new HashMap<String, JsonSchemaObject>();
    }

    public void copyValues(JsonSchemaObject other) {
        this.myId = other.myId;
        this.mySchema = other.mySchema;
        this.myDescription = other.myDescription;
        this.myTitle = other.myTitle;
        this.myProperties = other.myProperties;
        this.myDefinitions = other.myDefinitions;
        this.myPatternProperties = other.myPatternProperties;
        this.myPatternCalculator.clear();
        this.myType = other.myType;
        this.myDefault = other.myDefault;
        this.myRef = other.myRef;
        this.myFormat = other.myFormat;
        this.myTypeVariants = other.myTypeVariants;
        this.myMultipleOf = other.myMultipleOf;
        this.myMaximum = other.myMaximum;
        this.myExclusiveMaximum = other.myExclusiveMaximum;
        this.myMinimum = other.myMinimum;
        this.myExclusiveMinimum = other.myExclusiveMinimum;
        this.myMaxLength = other.myMaxLength;
        this.myMinLength = other.myMinLength;
        this.myPattern = other.myPattern;
        this.myAdditionalPropertiesAllowed = other.myAdditionalPropertiesAllowed;
        this.myAdditionalPropertiesSchema = other.myAdditionalPropertiesSchema;
        this.myAdditionalItemsAllowed = other.myAdditionalItemsAllowed;
        this.myAdditionalItemsSchema = other.myAdditionalItemsSchema;
        this.myItemsSchema = other.myItemsSchema;
        this.myItemsSchemaList = other.myItemsSchemaList;
        this.myMaxItems = other.myMaxItems;
        this.myMinItems = other.myMinItems;
        this.myUniqueItems = other.myUniqueItems;
        this.myMaxProperties = other.myMaxProperties;
        this.myMinProperties = other.myMinProperties;
        this.myRequired = other.myRequired;
        this.myPropertyDependencies = other.myPropertyDependencies;
        this.mySchemaDependencies = other.mySchemaDependencies;
        this.myEnum = other.myEnum;
        this.myAllOf = other.myAllOf;
        this.myAnyOf = other.myAnyOf;
        this.myOneOf = other.myOneOf;
        this.myNot = other.myNot;
        this.myDefinitionAddress = other.myDefinitionAddress;
    }

    public void mergeValues(JsonSchemaObject other) {
        this.myProperties.putAll(other.myProperties);
        this.myDefinitions = JsonSchemaObject.copyMap(this.myDefinitions, other.myDefinitions);
        this.myPatternProperties = JsonSchemaObject.copyMap(this.myPatternProperties, other.myPatternProperties);
        this.myPatternCalculator.clear();
        if (!StringUtil.isEmptyOrSpaces((String)other.myDescription)) {
            this.myDescription = other.myDescription;
        }
        if (other.myType != null) {
            this.myType = other.myType;
        }
        if (other.myDefault != null) {
            this.myDefault = other.myDefault;
        }
        if (other.myRef != null) {
            this.myRef = other.myRef;
        }
        if (other.myFormat != null) {
            this.myFormat = other.myFormat;
        }
        this.myTypeVariants = JsonSchemaObject.copyList(this.myTypeVariants, other.myTypeVariants);
        if (other.myMultipleOf != null) {
            this.myMultipleOf = other.myMultipleOf;
        }
        if (other.myMaximum != null) {
            this.myMaximum = other.myMaximum;
        }
        if (other.myExclusiveMaximum) {
            this.myExclusiveMaximum = other.myExclusiveMaximum;
        }
        if (other.myMinimum != null) {
            this.myMinimum = other.myMinimum;
        }
        if (other.myExclusiveMinimum) {
            this.myExclusiveMinimum = other.myExclusiveMinimum;
        }
        if (other.myMaxLength != null) {
            this.myMaxLength = other.myMaxLength;
        }
        if (other.myMinLength != null) {
            this.myMinLength = other.myMinLength;
        }
        if (other.myPattern != null) {
            this.myPattern = other.myPattern;
        }
        if (other.myAdditionalPropertiesAllowed != null) {
            this.myAdditionalPropertiesAllowed = other.myAdditionalPropertiesAllowed;
        }
        if (other.myAdditionalPropertiesSchema != null) {
            this.myAdditionalPropertiesSchema = other.myAdditionalPropertiesSchema;
        }
        if (other.myAdditionalItemsAllowed != null) {
            this.myAdditionalItemsAllowed = other.myAdditionalItemsAllowed;
        }
        if (other.myAdditionalItemsSchema != null) {
            this.myAdditionalItemsSchema = other.myAdditionalItemsSchema;
        }
        if (other.myItemsSchema != null) {
            this.myItemsSchema = other.myItemsSchema;
        }
        this.myItemsSchemaList = JsonSchemaObject.copyList(this.myItemsSchemaList, other.myItemsSchemaList);
        if (other.myMaxItems != null) {
            this.myMaxItems = other.myMaxItems;
        }
        if (other.myMinItems != null) {
            this.myMinItems = other.myMinItems;
        }
        if (other.myUniqueItems) {
            this.myUniqueItems = other.myUniqueItems;
        }
        if (other.myMaxProperties != null) {
            this.myMaxProperties = other.myMaxProperties;
        }
        if (other.myMinProperties != null) {
            this.myMinProperties = other.myMinProperties;
        }
        this.myRequired = JsonSchemaObject.copyList(this.myRequired, other.myRequired);
        this.myPropertyDependencies = JsonSchemaObject.copyMap(this.myPropertyDependencies, other.myPropertyDependencies);
        this.mySchemaDependencies = JsonSchemaObject.copyMap(this.mySchemaDependencies, other.mySchemaDependencies);
        if (other.myEnum != null) {
            this.myEnum = other.myEnum;
        }
        this.myAllOf = JsonSchemaObject.copyList(this.myAllOf, other.myAllOf);
        this.myAnyOf = JsonSchemaObject.copyList(this.myAnyOf, other.myAnyOf);
        this.myOneOf = JsonSchemaObject.copyList(this.myOneOf, other.myOneOf);
        if (other.myNot != null) {
            this.myNot = other.myNot;
        }
    }

    private static <T> List<T> copyList(List<T> target, List<T> source) {
        if (source == null || source.isEmpty()) {
            return target;
        }
        if (target == null) {
            target = new ArrayList<T>();
        }
        target.addAll(source);
        return target;
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> target, Map<K, V> source) {
        if (source == null || source.isEmpty()) {
            return target;
        }
        if (target == null) {
            target = new HashMap();
        }
        target.putAll(source);
        return target;
    }

    public Map<String, JsonSchemaObject> getDefinitions() {
        return this.myDefinitions;
    }

    public void setDefinitions(Map<String, JsonSchemaObject> definitions) {
        this.myDefinitions = definitions;
    }

    public Map<String, JsonSchemaObject> getProperties() {
        return this.myProperties;
    }

    public void setProperties(Map<String, JsonSchemaObject> properties) {
        this.myProperties = properties;
    }

    public Map<String, JsonSchemaObject> getPatternProperties() {
        return this.myPatternProperties;
    }

    public void setPatternProperties(Map<String, JsonSchemaObject> patternProperties) {
        this.myPatternProperties = patternProperties;
        this.myPatternCalculator.clear();
    }

    public JsonSchemaType getType() {
        return this.myType;
    }

    public void setType(JsonSchemaType type) {
        this.myType = type;
    }

    public Number getMultipleOf() {
        return this.myMultipleOf;
    }

    public void setMultipleOf(Number multipleOf) {
        this.myMultipleOf = multipleOf;
    }

    public Number getMaximum() {
        return this.myMaximum;
    }

    public void setMaximum(Number maximum) {
        this.myMaximum = maximum;
    }

    public boolean isExclusiveMaximum() {
        return this.myExclusiveMaximum;
    }

    public void setExclusiveMaximum(boolean exclusiveMaximum) {
        this.myExclusiveMaximum = exclusiveMaximum;
    }

    public Number getMinimum() {
        return this.myMinimum;
    }

    public void setMinimum(Number minimum) {
        this.myMinimum = minimum;
    }

    public boolean isExclusiveMinimum() {
        return this.myExclusiveMinimum;
    }

    public void setExclusiveMinimum(boolean exclusiveMinimum) {
        this.myExclusiveMinimum = exclusiveMinimum;
    }

    public Integer getMaxLength() {
        return this.myMaxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.myMaxLength = maxLength;
    }

    public Integer getMinLength() {
        return this.myMinLength;
    }

    public void setMinLength(Integer minLength) {
        this.myMinLength = minLength;
    }

    public String getPattern() {
        return this.myPattern;
    }

    public void setPattern(String pattern) {
        this.myPattern = pattern;
    }

    public Boolean getAdditionalPropertiesAllowed() {
        return this.myAdditionalPropertiesAllowed;
    }

    public void setAdditionalPropertiesAllowed(Boolean additionalPropertiesAllowed) {
        this.myAdditionalPropertiesAllowed = additionalPropertiesAllowed;
    }

    public JsonSchemaObject getAdditionalPropertiesSchema() {
        return this.myAdditionalPropertiesSchema;
    }

    public void setAdditionalPropertiesSchema(JsonSchemaObject additionalPropertiesSchema) {
        this.myAdditionalPropertiesSchema = additionalPropertiesSchema;
    }

    public Boolean getAdditionalItemsAllowed() {
        return this.myAdditionalItemsAllowed;
    }

    public void setAdditionalItemsAllowed(Boolean additionalItemsAllowed) {
        this.myAdditionalItemsAllowed = additionalItemsAllowed;
    }

    public JsonSchemaObject getAdditionalItemsSchema() {
        return this.myAdditionalItemsSchema;
    }

    public void setAdditionalItemsSchema(JsonSchemaObject additionalItemsSchema) {
        this.myAdditionalItemsSchema = additionalItemsSchema;
    }

    public JsonSchemaObject getItemsSchema() {
        return this.myItemsSchema;
    }

    public void setItemsSchema(JsonSchemaObject itemsSchema) {
        this.myItemsSchema = itemsSchema;
    }

    public List<JsonSchemaObject> getItemsSchemaList() {
        return this.myItemsSchemaList;
    }

    public void setItemsSchemaList(List<JsonSchemaObject> itemsSchemaList) {
        this.myItemsSchemaList = itemsSchemaList;
    }

    public Integer getMaxItems() {
        return this.myMaxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.myMaxItems = maxItems;
    }

    public Integer getMinItems() {
        return this.myMinItems;
    }

    public void setMinItems(Integer minItems) {
        this.myMinItems = minItems;
    }

    public boolean isUniqueItems() {
        return this.myUniqueItems;
    }

    public void setUniqueItems(boolean uniqueItems) {
        this.myUniqueItems = uniqueItems;
    }

    public Integer getMaxProperties() {
        return this.myMaxProperties;
    }

    public void setMaxProperties(Integer maxProperties) {
        this.myMaxProperties = maxProperties;
    }

    public Integer getMinProperties() {
        return this.myMinProperties;
    }

    public void setMinProperties(Integer minProperties) {
        this.myMinProperties = minProperties;
    }

    public List<String> getRequired() {
        return this.myRequired;
    }

    public void setRequired(List<String> required) {
        this.myRequired = required;
    }

    public Map<String, List<String>> getPropertyDependencies() {
        return this.myPropertyDependencies;
    }

    public void setPropertyDependencies(Map<String, List<String>> propertyDependencies) {
        this.myPropertyDependencies = propertyDependencies;
    }

    public Map<String, JsonSchemaObject> getSchemaDependencies() {
        return this.mySchemaDependencies;
    }

    public void setSchemaDependencies(Map<String, JsonSchemaObject> schemaDependencies) {
        this.mySchemaDependencies = schemaDependencies;
    }

    public List<Object> getEnum() {
        return this.myEnum;
    }

    public void setEnum(List<Object> anEnum) {
        this.myEnum = anEnum;
    }

    public List<JsonSchemaObject> getAllOf() {
        return this.myAllOf;
    }

    public void setAllOf(List<JsonSchemaObject> allOf) {
        this.myAllOf = allOf;
    }

    public List<JsonSchemaObject> getAnyOf() {
        return this.myAnyOf;
    }

    public void setAnyOf(List<JsonSchemaObject> anyOf) {
        this.myAnyOf = anyOf;
    }

    public List<JsonSchemaObject> getOneOf() {
        return this.myOneOf;
    }

    public void setOneOf(List<JsonSchemaObject> oneOf) {
        this.myOneOf = oneOf;
    }

    public JsonSchemaObject getNot() {
        return this.myNot;
    }

    public void setNot(JsonSchemaObject not) {
        this.myNot = not;
    }

    public List<JsonSchemaType> getTypeVariants() {
        return this.myTypeVariants;
    }

    public void setTypeVariants(List<JsonSchemaType> typeVariants) {
        this.myTypeVariants = typeVariants;
    }

    public String getRef() {
        return this.myRef;
    }

    public void setRef(String ref) {
        this.myRef = ref;
    }

    public Object getDefault() {
        return this.myDefault;
    }

    public void setDefault(Object aDefault) {
        this.myDefault = aDefault;
    }

    public String getFormat() {
        return this.myFormat;
    }

    public void setFormat(String format) {
        this.myFormat = format;
    }

    public String getId() {
        return this.myId;
    }

    public void setId(String id) {
        this.myId = id;
    }

    public String getSchema() {
        return this.mySchema;
    }

    public void setSchema(String schema) {
        this.mySchema = schema;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public boolean hasSpecifiedType() {
        return this.myType != null || this.myTypeVariants != null && !this.myTypeVariants.isEmpty();
    }

    public String getDefinitionAddress() {
        return this.myDefinitionAddress;
    }

    public void setDefinitionAddress(String definitionAddress) {
        this.myDefinitionAddress = definitionAddress;
    }

    @Nullable
    public JsonSchemaObject getMatchingPatternPropertySchema(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaObject", "getMatchingPatternPropertySchema"));
        }
        return this.myPatternCalculator.getMatchingPatternPropertySchema(this.myPatternProperties, name);
    }

    @NotNull
    private static String adaptSchemaPattern(String pattern) {
        pattern = pattern.startsWith("^") || pattern.startsWith("*") || pattern.startsWith(".") ? pattern : ".*" + pattern;
        String string = pattern = pattern.endsWith("+") || pattern.endsWith("*") ? pattern : pattern + ".*";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaObject", "adaptSchemaPattern"));
        }
        return string;
    }

    private static class PatternCalculator {
        private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
        private Map<String, Pattern> myCachedPatterns;
        private SLRUMap<String, String> myCachedPatternProperties;

        private PatternCalculator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public JsonSchemaObject getMatchingPatternPropertySchema(@Nullable Map<String, JsonSchemaObject> patternProperties, @NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "getMatchingPatternPropertySchema"));
            }
            if (patternProperties == null || patternProperties.isEmpty()) {
                return null;
            }
            this.myLock.readLock().lock();
            try {
                if (this.myCachedPatterns == null) {
                    this.initPatternCache(patternProperties);
                }
                assert (this.myCachedPatternProperties != null);
                String s = (String)this.myCachedPatternProperties.get((Object)name);
                if (s != null) {
                    JsonSchemaObject jsonSchemaObject = patternProperties.get(s);
                    return jsonSchemaObject;
                }
                JsonSchemaObject jsonSchemaObject = this.matchPatternsToString(name, patternProperties);
                return jsonSchemaObject;
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        public void clear() {
            this.myLock.writeLock().lock();
            try {
                this.myCachedPatterns = null;
                this.myCachedPatternProperties = null;
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        private JsonSchemaObject matchPatternsToString(@NotNull String name, @NotNull Map<String, JsonSchemaObject> patternProperties) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "matchPatternsToString"));
            }
            if (patternProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProperties", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "matchPatternsToString"));
            }
            ArrayList<String> strings = new ArrayList<String>(patternProperties.keySet());
            Collections.sort(strings);
            return (JsonSchemaObject)this.underWrite(() -> {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "lambda$matchPatternsToString$0"));
                }
                if (patternProperties == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProperties", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "lambda$matchPatternsToString$0"));
                }
                for (String pattern : strings) {
                    try {
                        Pattern compiledPattern = this.myCachedPatterns.get(pattern);
                        assert (compiledPattern != null);
                        boolean matches = compiledPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)name, (long)300L)).matches();
                        if (!matches) continue;
                        this.myCachedPatternProperties.put((Object)name, (Object)pattern);
                        return (JsonSchemaObject)patternProperties.get(pattern);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                }
                this.myCachedPatternProperties.put((Object)name, (Object)"");
                return null;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T underWrite(@NotNull Computable<T> computable) {
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "underWrite"));
            }
            this.myLock.readLock().unlock();
            this.myLock.writeLock().lock();
            try {
                Object t = computable.compute();
                this.myLock.readLock().lock();
                Object object = t;
                return (T)object;
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        private void initPatternCache(@NotNull Map<String, JsonSchemaObject> patternProperties) {
            if (patternProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProperties", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "initPatternCache"));
            }
            this.underWrite(() -> {
                if (patternProperties == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProperties", "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternCalculator", "lambda$initPatternCache$1"));
                }
                this.myCachedPatterns = new HashMap<String, Pattern>(patternProperties.size(), 1.0f);
                this.myCachedPatternProperties = new SLRUMap(100, 100);
                for (String pattern : patternProperties.keySet()) {
                    this.myCachedPatterns.put(pattern, Pattern.compile(JsonSchemaObject.adaptSchemaPattern(pattern)));
                }
                return true;
            });
        }
    }
}

