/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnNullInspectionBase
extends BaseInspection {
    public boolean m_reportObjectMethods = true;
    public boolean m_reportArrayMethods = true;
    public boolean m_reportCollectionMethods = true;
    public boolean m_ignorePrivateMethods = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("ReturnOfNull" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ReturnNullInspectionBase", "getID"));
        }
        return "ReturnOfNull";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("return.of.null.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ReturnNullInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("return.of.null.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ReturnNullInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod method2;
        PsiType type;
        PsiElement elt = (PsiElement)infos[0];
        if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)elt)) {
            return null;
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)elt, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (element instanceof PsiLambdaExpression) {
            return null;
        }
        if (element instanceof PsiMethod && TypeUtils.isOptional(type = (method2 = (PsiMethod)element).getReturnType())) {
            return new ReplaceWithEmptyOptionalFix(((PsiClassType)type).rawType().getCanonicalText());
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)elt.getProject());
        return new DelegatingFix(new AnnotateMethodFix(manager.getDefaultNullable(), ArrayUtil.toStringArray((Collection)manager.getNotNulls())){

            @Override
            public int shouldAnnotateBaseMethod(PsiMethod method2, PsiMethod superMethod, Project project2) {
                return ReturnNullInspectionBase.this.shouldAnnotateBaseMethod(method2, superMethod);
            }
        });
    }

    protected int shouldAnnotateBaseMethod(PsiMethod method2, PsiMethod superMethod) {
        return 1;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.ignore.private.option", new Object[0]), "m_ignorePrivateMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.arrays.option", new Object[0]), "m_reportArrayMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.collections.option", new Object[0]), "m_reportCollectionMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.objects.option", new Object[0]), "m_reportObjectMethods");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnNullVisitor();
    }

    private class ReturnNullVisitor
    extends BaseInspectionVisitor {
        private ReturnNullVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression value) {
            PsiType returnType;
            PsiMethod method2;
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/siyeh/ig/bugs/ReturnNullInspectionBase$ReturnNullVisitor", "visitLiteralExpression"));
            }
            super.visitLiteralExpression(value);
            String text = value.getText();
            if (!"null".equals(text)) {
                return;
            }
            PsiElement parent = value.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression || parent instanceof PsiTypeCastExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiReturnStatement)) {
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)value, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (element instanceof PsiMethod) {
                method2 = (PsiMethod)element;
                returnType = method2.getReturnType();
            } else if (element instanceof PsiLambdaExpression) {
                PsiType functionalInterfaceType = ((PsiLambdaExpression)element).getFunctionalInterfaceType();
                method2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
            } else {
                return;
            }
            if (method2 == null || returnType == null) {
                return;
            }
            if (TypeUtils.isOptional(returnType)) {
                this.registerError((PsiElement)value, value);
                return;
            }
            if (ReturnNullInspectionBase.this.m_ignorePrivateMethods && method2.hasModifierProperty("private")) {
                return;
            }
            NullableNotNullManager nullableNotNullManager = NullableNotNullManager.getInstance((Project)method2.getProject());
            if (nullableNotNullManager.isNullable((PsiModifierListOwner)method2, false)) {
                return;
            }
            if (CollectionUtils.isCollectionClassOrInterface(returnType)) {
                if (ReturnNullInspectionBase.this.m_reportCollectionMethods) {
                    this.registerError((PsiElement)value, value);
                }
            } else if (returnType.getArrayDimensions() > 0) {
                if (ReturnNullInspectionBase.this.m_reportArrayMethods) {
                    this.registerError((PsiElement)value, value);
                }
            } else if (ReturnNullInspectionBase.this.m_reportObjectMethods) {
                this.registerError((PsiElement)value, value);
            }
        }
    }

    private static class ReplaceWithEmptyOptionalFix
    extends InspectionGadgetsFix {
        private final String myTypeText;

        public ReplaceWithEmptyOptionalFix(String typeText) {
            this.myTypeText = typeText;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("return.of.null.optional.quickfix", this.myTypeText, "com.google.common.base.Optional".equals(this.myTypeText) ? "absent" : "empty");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ReturnNullInspectionBase$ReplaceWithEmptyOptionalFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("return.of.null.optional.quickfix.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ReturnNullInspectionBase$ReplaceWithEmptyOptionalFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            if ("com.google.common.base.Optional".equals(this.myTypeText)) {
                PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, this.myTypeText + ".absent()");
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, this.myTypeText + ".empty()");
            }
        }
    }
}

