/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.memory.InnerClassReferenceVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMayBeInterfaceInspection
extends BaseInspection {
    public boolean reportClassesWithNonAbstractMethods = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.may.be.interface.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.may.be.interface.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("class.may.be.interface.java8.option", new Object[0]), (InspectionProfileEntry)this, "reportClassesWithNonAbstractMethods");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection", "writeSettings"));
        }
        if (this.reportClassesWithNonAbstractMethods) {
            node.addContent(new Element("option").setAttribute("name", "reportClassesWithNonAbstractMethods").setAttribute("value", "true"));
        }
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ClassMayBeInterfaceFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassMayBeInterfaceVisitor();
    }

    private class ClassMayBeInterfaceVisitor
    extends BaseInspectionVisitor {
        private ClassMayBeInterfaceVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!this.mayBeInterface(aClass)) {
                return;
            }
            if (ClassUtils.isInnerClass(aClass)) {
                InnerClassReferenceVisitor visitor = new InnerClassReferenceVisitor(aClass);
                aClass.accept((PsiElementVisitor)visitor);
                if (!visitor.canInnerClassBeStatic()) {
                    return;
                }
            }
            this.registerClassError(aClass, new Object[0]);
        }

        public boolean mayBeInterface(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] extendsElements;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList != null && (extendsElements = extendsList.getReferenceElements()).length > 0) {
                return false;
            }
            PsiClassInitializer[] initializers = aClass.getInitializers();
            if (initializers.length > 0) {
                return false;
            }
            return this.allMethodsPublicAbstract(aClass) && this.allFieldsPublicStaticFinal(aClass) && this.allInnerClassesPublic(aClass);
        }

        private boolean allFieldsPublicStaticFinal(PsiClass aClass) {
            PsiField[] fields;
            boolean allFieldsStaticFinal = true;
            for (PsiField field : fields = aClass.getFields()) {
                if (field.hasModifierProperty("static") && field.hasModifierProperty("final") && field.hasModifierProperty("public")) continue;
                allFieldsStaticFinal = false;
            }
            return allFieldsStaticFinal;
        }

        private boolean allMethodsPublicAbstract(PsiClass aClass) {
            PsiMethod[] methods;
            for (PsiMethod method2 : methods = aClass.getMethods()) {
                if (!(method2.hasModifierProperty("abstract") || ClassMayBeInterfaceInspection.this.reportClassesWithNonAbstractMethods && PsiUtil.isLanguageLevel8OrHigher((PsiElement)aClass))) {
                    return false;
                }
                if (method2.hasModifierProperty("public") && !method2.hasModifierProperty("final")) continue;
                return false;
            }
            return true;
        }

        private boolean allInnerClassesPublic(PsiClass aClass) {
            PsiClass[] innerClasses;
            for (PsiClass innerClass : innerClasses = aClass.getInnerClasses()) {
                if (innerClass.hasModifierProperty("public")) continue;
                return false;
            }
            return true;
        }
    }

    private static class ClassMayBeInterfaceFix
    extends InspectionGadgetsFix {
        private ClassMayBeInterfaceFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("class.may.be.interface.convert.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected boolean prepareForWriting() {
            return false;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiIdentifier classNameIdentifier = (PsiIdentifier)descriptor.getPsiElement();
            PsiClass interfaceClass = (PsiClass)classNameIdentifier.getParent();
            SearchScope searchScope = interfaceClass.getUseScope();
            ArrayList<PsiClass> elements = new ArrayList<PsiClass>();
            elements.add(interfaceClass);
            for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)interfaceClass, (SearchScope)searchScope, (boolean)false)) {
                elements.add(inheritor);
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                return;
            }
            ClassMayBeInterfaceFix.moveSubClassExtendsToImplements(elements);
            ClassMayBeInterfaceFix.changeClassToInterface(interfaceClass);
            ClassMayBeInterfaceFix.moveImplementsToExtends(interfaceClass);
        }

        private static void changeClassToInterface(PsiClass aClass) {
            for (PsiMethod psiMethod : aClass.getMethods()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"public", (boolean)false);
                if (psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract")) continue;
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"default", (boolean)true);
            }
            for (PsiMethod psiMethod : aClass.getFields()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"public", (boolean)false);
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"static", (boolean)false);
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"final", (boolean)false);
            }
            for (PsiMethod psiMethod : aClass.getInnerClasses()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"public", (boolean)false);
            }
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            PsiKeyword classKeyword = (PsiKeyword)PsiTreeUtil.getPrevSiblingOfType((PsiElement)nameIdentifier, PsiKeyword.class);
            PsiManager manager = aClass.getManager();
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiKeyword interfaceKeyword = psiElementFactory.createKeyword("interface");
            if (classKeyword == null) {
                return;
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"abstract", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"final", (boolean)false);
            classKeyword.replace((PsiElement)interfaceKeyword);
        }

        private static void moveImplementsToExtends(PsiClass anInterface) {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiReferenceList extendsList = anInterface.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiReferenceList implementsList = anInterface.getImplementsList();
            if (implementsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = implementsList.getReferenceElements()) {
                extendsList.add((PsiElement)referenceElement);
                referenceElement.delete();
            }
        }

        private static void moveSubClassExtendsToImplements(List<PsiClass> inheritors) {
            PsiClass oldClass = inheritors.get(0);
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)oldClass.getProject()).getElementFactory();
            PsiJavaCodeReferenceElement classReference = elementFactory.createClassReferenceElement(oldClass);
            for (int i2 = 1; i2 < inheritors.size(); ++i2) {
                PsiClass inheritor = inheritors.get(i2);
                PsiReferenceList extendsList = inheritor.getExtendsList();
                if (extendsList == null) continue;
                PsiReferenceList implementsList = inheritor.getImplementsList();
                ClassMayBeInterfaceFix.moveReference(extendsList, implementsList, classReference);
            }
        }

        private static void moveReference(@NotNull PsiReferenceList source, @Nullable PsiReferenceList target, @NotNull PsiJavaCodeReferenceElement reference) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceFix", "moveReference"));
            }
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceFix", "moveReference"));
            }
            PsiJavaCodeReferenceElement[] sourceReferences = source.getReferenceElements();
            String fqName = reference.getQualifiedName();
            for (PsiJavaCodeReferenceElement sourceReference : sourceReferences) {
                String implementsReferenceFqName = sourceReference.getQualifiedName();
                if (!fqName.equals(implementsReferenceFqName)) continue;
                if (target != null) {
                    target.add((PsiElement)sourceReference);
                }
                sourceReference.delete();
            }
        }
    }
}

