/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.Consumer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.classlayout.PublicConstructorInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicConstructorInspection
extends PublicConstructorInspectionBase {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceConstructorWithFactoryMethodFix();
    }

    private static class ReplaceConstructorWithFactoryMethodFix
    extends InspectionGadgetsFix {
        private ReplaceConstructorWithFactoryMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("public.constructor.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/PublicConstructorInspection$ReplaceConstructorWithFactoryMethodFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(final Project project2, ProblemDescriptor descriptor) {
            final PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), (Class[])new Class[]{PsiClass.class, PsiMethod.class});
            AsyncResult context = DataManager.getInstance().getDataContextFromFocus();
            context.doWhenDone((Consumer)new Consumer<DataContext>(){

                public void consume(DataContext dataContext) {
                    JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
                    RefactoringActionHandler handler2 = factory.createReplaceConstructorWithFactoryHandler();
                    handler2.invoke(project2, new PsiElement[]{element}, dataContext);
                }
            });
        }

        @Override
        protected boolean prepareForWriting() {
            return false;
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

