/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class StringEqualsIgnoreCaseInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CallToStringEqualsIgnoreCase" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/StringEqualsIgnoreCaseInspection", "getID"));
        }
        return "CallToStringEqualsIgnoreCase";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.equalsignorecase.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/StringEqualsIgnoreCaseInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.equalsignorecase.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/StringEqualsIgnoreCaseInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiModifierListOwner annotatableArgument;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        ArrayList<DelegatingFix> result2 = new ArrayList<DelegatingFix>();
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiModifierListOwner annotatableQualifier = NonNlsUtils.getAnnotatableQualifier(methodExpression);
        if (annotatableQualifier != null) {
            DelegatingFix fix = StringEqualsIgnoreCaseInspection.createAddAnnotationFix(annotatableQualifier);
            result2.add(fix);
        }
        if ((annotatableArgument = NonNlsUtils.getAnnotatableArgument(methodCallExpression)) != null) {
            DelegatingFix fix = StringEqualsIgnoreCaseInspection.createAddAnnotationFix(annotatableArgument);
            result2.add(fix);
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result2.toArray(new InspectionGadgetsFix[result2.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/StringEqualsIgnoreCaseInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    private static DelegatingFix createAddAnnotationFix(PsiModifierListOwner annotatableQualifier) {
        return new DelegatingFix((LocalQuickFix)new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", annotatableQualifier, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringEqualsIgnoreCaseVisitor();
    }

    private static class StringEqualsIgnoreCaseVisitor
    extends BaseInspectionVisitor {
        private StringEqualsIgnoreCaseVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/internationalization/StringEqualsIgnoreCaseInspection$StringEqualsIgnoreCaseVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equalsIgnoreCase".equals(methodName)) {
                return;
            }
            PsiMethod method2 = expression.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType parameterType = parameters[0].getType();
            if (!TypeUtils.isJavaLangString(parameterType)) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (NonNlsUtils.isNonNlsAnnotated(qualifier)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            if (NonNlsUtils.isNonNlsAnnotated(arguments[0])) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }
    }
}

