/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.LoopCountVisitor;
import org.jetbrains.annotations.NotNull;

public class MethodWithMultipleLoopsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.with.multiple.loops.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/MethodWithMultipleLoopsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer negationCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("method.with.multiple.loops.problem.descriptor", negationCount);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/MethodWithMultipleLoopsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodWithMultipleLoopsVisitor();
    }

    private static class MethodWithMultipleLoopsVisitor
    extends BaseInspectionVisitor {
        private MethodWithMultipleLoopsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/MethodWithMultipleLoopsInspection$MethodWithMultipleLoopsVisitor", "visitMethod"));
            }
            if (method2.getNameIdentifier() == null) {
                return;
            }
            LoopCountVisitor visitor = new LoopCountVisitor();
            method2.accept((PsiElementVisitor)visitor);
            int negationCount = visitor.getCount();
            if (negationCount <= 1) {
                return;
            }
            this.registerMethodError(method2, negationCount);
        }
    }
}

