/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.RootProvider;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/WebServerRootsProvider;", "()V", "getPathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "resolve", "path", "", "built-in-server"})
final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project2) {
        Void void_;
        FileResolver resolver;
        void effectivePath;
        block14: {
            void $receiver$iv;
            Object moduleName;
            int index;
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = path;
            if (PlatformUtils.isIntelliJ() && (index = StringsKt.indexOf$default((CharSequence)((String)effectivePath.element), (char)'/', (int)0, (boolean)false, (int)6, null)) > 0) {
                String string = (String)effectivePath.element;
                String string2 = project2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.name");
                if (!StringsKt.regionMatches((String)string, (int)0, (String)string2, (int)0, (int)index, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                    String string3 = (String)effectivePath.element;
                    int n = 0;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    moduleName = string5;
                    Module module2 = (Module)ApplicationManager.getApplication().runReadAction(new Computable<T>(project2, (String)moduleName){
                        final /* synthetic */ Project $project$inlined;
                        final /* synthetic */ String $moduleName$inlined;

                        public final T compute() {
                            return (T)ModuleManager.getInstance((Project)this.$project$inlined).findModuleByName(this.$moduleName$inlined);
                        }
                        {
                            this.$project$inlined = project2;
                            this.$moduleName$inlined = string;
                        }
                    });
                    if (module2 != null && !module2.isDisposed()) {
                        PathInfo result2;
                        PathInfo pathInfo;
                        PathInfo pathInfo2;
                        FileResolver resolver2;
                        block12: {
                            void $receiver$iv2;
                            String $i$f$runReadAction = (String)effectivePath.element;
                            int n2 = index + 1;
                            void var21_14 = effectivePath;
                            String string6 = $i$f$runReadAction;
                            if (string6 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string7 = string6.substring(n2);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                            String string8 = string7;
                            var21_14.element = string8;
                            resolver2 = WebServerPathToFileManager.Companion.getInstance(project2).getResolver((String)effectivePath.element);
                            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                            Object[] objectArray = (Object[])RootProvider.values();
                            for (int j = 0; j < ((void)$receiver$iv2).length; ++j) {
                                void file$iv = $receiver$iv2[j];
                                RootProvider it = (RootProvider)file$iv;
                                String string9 = (String)effectivePath.element;
                                ModuleRootManager moduleRootManager2 = moduleRootManager;
                                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager2, (String)"moduleRootManager");
                                PathInfo result$iv = DefaultWebServerRootsProviderKt.access$findByRelativePath(string9, it.getRoots(moduleRootManager2), resolver2, (String)moduleName);
                                if (result$iv == null) continue;
                                pathInfo2 = result$iv;
                                break block12;
                            }
                            pathInfo2 = null;
                        }
                        if ((pathInfo = (PathInfo)pathInfo2) == null) {
                            pathInfo = result2 = DefaultWebServerRootsProviderKt.access$findInModuleLibraries((String)effectivePath.element, module2, resolver2);
                        }
                        if (result2 != null) {
                            return result2;
                        }
                    }
                }
            }
            resolver = WebServerPathToFileManager.Companion.getInstance(project2).getResolver((String)effectivePath.element);
            moduleName = (Object[])RootProvider.values();
            for (int j = 0; j < ((void)$receiver$iv).length; ++j) {
                Object v12;
                block13: {
                    void $receiver$iv3;
                    void file$iv = $receiver$iv[j];
                    RootProvider rootProvider = (RootProvider)file$iv;
                    Object[] $i$f$runReadAction = (Object[])ApplicationManager.getApplication().runReadAction(new Computable<T>(project2, path, resolver){
                        final /* synthetic */ Project $project$inlined;
                        final /* synthetic */ String $path$inlined;
                        final /* synthetic */ FileResolver $resolver$inlined;

                        public final T compute() {
                            return (T)ModuleManager.getInstance((Project)this.$project$inlined).getModules();
                        }
                        {
                            this.$project$inlined = project2;
                            this.$path$inlined = string;
                            this.$resolver$inlined = fileResolver;
                        }
                    });
                    for (int k = 0; k < ((void)$receiver$iv3).length; ++k) {
                        Object result$iv;
                        void file$iv2 = $receiver$iv3[k];
                        Module module3 = (Module)file$iv2;
                        if (!module3.isDisposed()) {
                            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module3);
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                            PathInfo pathInfo = DefaultWebServerRootsProviderKt.access$findByRelativePath(path, rootProvider.getRoots(moduleRootManager), resolver, null);
                            if (pathInfo != null) {
                                PathInfo pathInfo3 = pathInfo;
                                PathInfo it = pathInfo3;
                                it.setModuleName(DefaultWebServerRootsProviderKt.access$getModuleNameQualifier(project2, module3));
                                return it;
                            }
                        }
                        if ((result$iv = null) == null) continue;
                        v12 = result$iv;
                        break block13;
                    }
                    v12 = null;
                }
                Void result$iv = v12;
                if (result$iv == null) continue;
                void_ = result$iv;
                break block14;
            }
            void_ = null;
        }
        Void void_2 = void_;
        return void_2 != null ? (PathInfo)void_2 : DefaultWebServerRootsProviderKt.access$findInLibraries(project2, (String)effectivePath.element, resolver);
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file2, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return (PathInfo)ApplicationManager.getApplication().runReadAction(new Computable<T>(project2, file2){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ VirtualFile $file$inlined;

            public final T compute() {
                PathInfo pathInfo;
                DirectoryIndex directoryIndex = DirectoryIndex.getInstance(this.$project$inlined);
                DirectoryInfo info = directoryIndex.getInfoForFile(this.$file$inlined);
                if (!info.isExcluded() && !info.isInProject()) {
                    pathInfo = Intrinsics.areEqual((Object)this.$file$inlined.getFileSystem(), (Object)JarFileSystem.getInstance()) ? DefaultWebServerRootsProviderKt.access$getInfoForDocJar(this.$file$inlined, this.$project$inlined) : (PathInfo)null;
                } else {
                    boolean isLibrary;
                    boolean isRootNameOptionalInPath;
                    VirtualFile root = info.getSourceRoot();
                    if (root == null) {
                        isRootNameOptionalInPath = false;
                        root = info.getContentRoot();
                        if (root == null) {
                            root = info.getLibraryClassRoot();
                            isLibrary = true;
                            boolean bl = root != null;
                            if (_Assertions.ENABLED && !bl) {
                                String string = this.$file$inlined.getPresentableUrl();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.presentableUrl");
                                String string2 = string;
                                throw (Throwable)((Object)new AssertionError((Object)string2));
                            }
                        } else {
                            isLibrary = false;
                        }
                    } else {
                        isLibrary = info.isInLibrarySource();
                        isRootNameOptionalInPath = !isLibrary;
                    }
                    Module module2 = info.getModule();
                    if (isLibrary && module2 == null) {
                        for (OrderEntry entry : directoryIndex.getOrderEntries(info)) {
                            if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                            module2 = ((ModuleLibraryOrderEntryImpl)entry).getOwnerModule();
                            break;
                        }
                    }
                    Path path = null;
                    VirtualFile virtualFile = root;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root!!");
                    pathInfo = new PathInfo(path, this.$file$inlined, virtualFile, DefaultWebServerRootsProviderKt.access$getModuleNameQualifier(this.$project$inlined, module2), isLibrary, isRootNameOptionalInPath);
                }
                return (T)pathInfo;
            }
            {
                this.$project$inlined = project2;
                this.$file$inlined = virtualFile;
            }
        });
    }
}

