/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;
import org.jetbrains.debugger.ArrayPresentation;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.FunctionScopesValueGroup;
import org.jetbrains.debugger.LazyVariablesGroupKt;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.ObjectValuePresentation;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableView$Companion$WhenMappings;
import org.jetbrains.debugger.VariableView$WhenMappings;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.VariablesKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ArrayValue;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 T2\u00020\u00012\u00020\u0002:\u0003TUVB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ(\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0004012\b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u00102\u001a\u00020\u0004H\u0002J\b\u00103\u001a\u000204H\u0016J\u001e\u00105\u001a\u00020/2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020/2\u0006\u00107\u001a\u000208H\u0016J$\u0010:\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\"\u001a\u00020;2\u0006\u00107\u001a\u0002082\u0006\u0010<\u001a\u000204H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J3\u0010A\u001a\u0015\u0012\f\u0012\n B*\u0004\u0018\u00010/0/0\u0014\u00a2\u0006\u0002\bC2\u0006\u0010\"\u001a\u00020D2\u0006\u00107\u001a\u0002082\u0006\u0010<\u001a\u000204H\u0002J\u0018\u0010E\u001a\u00020/2\u0006\u00107\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0016J\u0018\u0010E\u001a\u00020/2\u0006\u0010\"\u001a\u00020#2\u0006\u00107\u001a\u00020FH\u0002J\u0010\u0010I\u001a\u00020/2\u0006\u0010J\u001a\u00020KH\u0016J\n\u0010L\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010M\u001a\u0004\u0018\u00010NH\u0016J\r\u0010O\u001a\t\u0018\u00010#\u00a2\u0006\u0002\bPJ$\u0010Q\u001a\u00020/2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010R\u001a\u0004\u0018\u00010\u00042\u0006\u00107\u001a\u00020FH\u0002J\b\u0010S\u001a\u000204H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00020\u001d8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u0004\u0018\u00010#8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\u0004\u0018\u00010+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006W"}, d2={"Lorg/jetbrains/debugger/VariableView;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "Lorg/jetbrains/debugger/VariableContext;", "variableName", "", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "(Ljava/lang/String;Lorg/jetbrains/debugger/Variable;Lorg/jetbrains/debugger/VariableContext;)V", "_memberFilter", "Lorg/jetbrains/debugger/MemberFilter;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getEvaluateContext", "()Lorg/jetbrains/debugger/EvaluateContext;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "memberFilter", "Lorg/jetbrains/concurrency/Promise;", "getMemberFilter", "()Lorg/jetbrains/concurrency/Promise;", "parent", "getParent", "()Lorg/jetbrains/debugger/VariableContext;", "remainingChildren", "", "remainingChildrenOffset", "", "scope", "Lorg/jetbrains/debugger/Scope;", "getScope", "()Lorg/jetbrains/debugger/Scope;", "value", "Lorg/jetbrains/debugger/values/Value;", "getVariableName", "()Ljava/lang/String;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "getViewSupport", "()Lorg/jetbrains/debugger/DebuggerViewSupport;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "addVarName", "", "list", "Lcom/intellij/util/SmartList;", "name", "canNavigateToSource", "", "computeArrayRanges", "properties", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computeChildren", "computeIndexedProperties", "Lorg/jetbrains/debugger/values/ArrayValue;", "isLastChildren", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "computeNamedProperties", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/debugger/values/ObjectValue;", "computePresentation", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "getEvaluationExpression", "getModifier", "Lcom/intellij/xdebugger/frame/XValueModifier;", "getValue", "Lorg/jetbrains/annotations/Nullable;", "setEvaluatedValue", "error", "watchableAsEvaluationExpression", "Companion", "MyFullValueEvaluator", "ObsolescentIndexedVariablesConsumer", "script-debugger-ui"})
public final class VariableView
extends XNamedValue
implements VariableContext {
    private volatile Value value;
    private MemberFilter _memberFilter;
    private volatile List<? extends Variable> remainingChildren;
    private volatile int remainingChildrenOffset;
    @NotNull
    private final VariableContext parent;
    @NotNull
    private final String variableName;
    private final Variable variable;
    private final VariableContext context;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean watchableAsEvaluationExpression() {
        return this.context.watchableAsEvaluationExpression();
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        return this.context.getViewSupport();
    }

    @Override
    @NotNull
    public VariableContext getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        return this.context.getViewSupport().getMemberFilter(this);
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.context.getEvaluateContext();
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.context.getScope();
    }

    @Override
    @Nullable
    public Vm getVm() {
        return this.context.getVm();
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        this.value = this.variable.getValue();
        if (this.value != null) {
            Value value = this.value;
            if (value == null) {
                Intrinsics.throwNpe();
            }
            this.computePresentation(value, node);
            return;
        }
        if (!(this.variable instanceof ObjectProperty) || ((ObjectProperty)this.variable).getGetter() == null) {
            EvaluateContext evaluateContext2 = this.getEvaluateContext();
            String string = this.variable.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name");
            Promise $receiver$iv = EvaluateContext.DefaultImpls.evaluate$default(evaluateContext2, string, null, false, 6, null);
            $receiver$iv = $receiver$iv.done((Consumer)new ObsolescentConsumer<EvaluateResult>((Obsolescent)node, (Obsolescent)node, this, node){
                final /* synthetic */ Obsolescent $node;
                final /* synthetic */ VariableView this$0;
                final /* synthetic */ XValueNode $node$inlined;

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public void consume(Object param) {
                    EvaluateResult it = (EvaluateResult)param;
                    if (it.getWasThrown()) {
                        VariableView.access$setEvaluatedValue(this.this$0, this.this$0.getViewSupport().transformErrorOnGetUsedReferenceValue(it.getValue(), null), null, this.$node$inlined);
                    } else {
                        VariableView.access$setValue$p(this.this$0, it.getValue());
                        VariableView.access$computePresentation(this.this$0, it.getValue(), this.$node$inlined);
                    }
                }
                {
                    this.$node = $captured_local_variable$1;
                    this.this$0 = variableView;
                    this.$node$inlined = xValueNode;
                    super($super_call_param$2);
                }
            });
            $receiver$iv.rejected((Consumer)new ObsolescentConsumer<Throwable>((Obsolescent)node, (Obsolescent)node, this, node){
                final /* synthetic */ Obsolescent $node;
                final /* synthetic */ VariableView this$0;
                final /* synthetic */ XValueNode $node$inlined;

                public void consume(Throwable param) {
                    Throwable it = param;
                    VariableView.access$setEvaluatedValue(this.this$0, this.this$0.getViewSupport().transformErrorOnGetUsedReferenceValue(null, it.getMessage()), it.getMessage(), this.$node$inlined);
                }
                {
                    this.$node = $captured_local_variable$1;
                    this.this$0 = variableView;
                    this.$node$inlined = xValueNode;
                    super($super_call_param$2);
                }
            });
            return;
        }
        node.setPresentation((Icon)null, new XValuePresentation(){

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
                renderer.renderValue("\u2026");
            }
        }, false);
        node.setFullValueEvaluator(new XFullValueEvaluator(this, node, " (invoke getter)"){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ XValueNode $node;

            /*
             * WARNING - void declaration
             */
            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                void node$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
                ValueModifier valueModifier = ((ObjectProperty)VariableView.access$getVariable$p(this.this$0)).getValueModifier();
                VariableContext nonProtoContext = VariableView.access$getContext$p(this.this$0);
                while (nonProtoContext instanceof VariableView && Intrinsics.areEqual((Object)((VariableView)nonProtoContext).getVariableName(), (Object)VariableViewKt.access$getPROTOTYPE_PROP$p())) {
                    valueModifier = VariableView.access$getVariable$p((VariableView)nonProtoContext).getValueModifier();
                    nonProtoContext = ((VariableView)nonProtoContext).getParent();
                }
                ValueModifier valueModifier2 = valueModifier;
                if (valueModifier2 == null) {
                    Intrinsics.throwNpe();
                }
                Promise<Value> promise2 = valueModifier2.evaluateGet(VariableView.access$getVariable$p(this.this$0), this.this$0.getEvaluateContext());
                Obsolescent obsolescent = (Obsolescent)this.$node;
                $receiver$iv.done((Consumer)new ObsolescentConsumer<Value>((Obsolescent)node$iv, (Obsolescent)node$iv, this, callback){
                    final /* synthetic */ Obsolescent $node;
                    final /* synthetic */ computePresentation.4 this$0;
                    final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback$inlined;

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public void consume(Object param) {
                        Value it = (Value)param;
                        this.$callback$inlined.evaluated("");
                        VariableView.access$setEvaluatedValue(this.this$0.this$0, it, null, this.this$0.$node);
                    }
                    {
                        this.$node = $captured_local_variable$1;
                        this.this$0 = var3_3;
                        this.$callback$inlined = xFullValueEvaluationCallback;
                        super($super_call_param$2);
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$node = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }.setShowValuePopup(false));
    }

    private final void setEvaluatedValue(Value value, String error, XValueNode node) {
        if (value == null) {
            String string = null;
            String string2 = error;
            if (string2 == null) {
                string2 = "Internal Error";
            }
            node.setPresentation(AllIcons.Debugger.Db_primitive, string, string2, false);
        } else {
            this.value = value;
            this.computePresentation(value, node);
        }
    }

    private final void computePresentation(Value value, XValueNode node) {
        switch (VariableView$WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
            case 1: 
            case 2: {
                Value value2 = value;
                if (value2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
                }
                this.context.getViewSupport().computeObjectPresentation((ObjectValue)value2, this.variable, this.context, node, this.getIcon());
                break;
            }
            case 3: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new ObjectValuePresentation(VariableViewKt.trimFunctionDescription(value)), true);
                break;
            }
            case 4: {
                this.context.getViewSupport().computeArrayPresentation(value, this.variable, this.context, node, this.getIcon());
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                Icon icon = this.getIcon();
                String string = value.getValueString();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                node.setPresentation(icon, (XValuePresentation)new XKeywordValuePresentation(string), false);
                break;
            }
            case 8: {
                Icon icon = this.getIcon();
                String string = value.getValueString();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                node.setPresentation(icon, VariableViewKt.access$createNumberPresentation(string), false);
                break;
            }
            case 9: {
                Icon icon = this.getIcon();
                String string = value.getValueString();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                node.setPresentation(icon, (XValuePresentation)new XStringValuePresentation(string), false);
                if (!(value instanceof StringValue) || !((StringValue)value).isTruncated()) {
                    String string2 = value.getValueString();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (string2.length() <= 1000) break;
                }
                node.setFullValueEvaluator((XFullValueEvaluator)new MyFullValueEvaluator(value));
                break;
            }
            default: {
                Icon icon = this.getIcon();
                String string = null;
                String string3 = value.getValueString();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                node.setPresentation(icon, string, string3, true);
            }
        }
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Promise $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        node.setAlreadySorted(true);
        if (!(this.value instanceof ObjectValue)) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        List<? extends Variable> list = this.remainingChildren;
        if (list != null) {
            int to = Math.min(this.remainingChildrenOffset + 100, list.size());
            boolean isLast = to == list.size();
            node.addChildren(VariablesKt.createVariablesList(list, this.remainingChildrenOffset, to, this, this._memberFilter), isLast);
            if (!isLast) {
                node.tooManyChildren(list.size() - to);
                this.remainingChildrenOffset += 100;
            }
            return;
        }
        Value value = this.value;
        if (value == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
        }
        ObjectValue objectValue = (ObjectValue)value;
        boolean hasNamedProperties = Intrinsics.areEqual((Object)objectValue.hasProperties(), (Object)ThreeState.NO) ^ true;
        boolean hasIndexedProperties = Intrinsics.areEqual((Object)objectValue.hasIndexedProperties(), (Object)ThreeState.NO) ^ true;
        SmartList promises = new SmartList();
        Promise<Object> additionalProperties = this.getViewSupport().computeAdditionalObjectProperties(objectValue, this.variable, this, node);
        if (additionalProperties != null) {
            promises.add(additionalProperties);
        }
        if (hasIndexedProperties) {
            ObjectValue objectValue2 = objectValue;
            if (objectValue2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.values.ArrayValue");
            }
            promises.add(this.computeIndexedProperties((ArrayValue)objectValue2, node, !hasNamedProperties && additionalProperties == null));
        }
        if (hasNamedProperties) {
            if (additionalProperties == null || Intrinsics.areEqual((Object)additionalProperties.getState(), (Object)Promise.State.PENDING) ^ true) {
                promises.add(this.computeNamedProperties(objectValue, node, !hasIndexedProperties && additionalProperties == null));
            } else {
                Promise<Object> promise2 = additionalProperties;
                SmartList smartList = promises;
                Promise promise3 = $receiver$iv.thenAsync((Function)new ValueNodeAsyncFunction<Object, Unit>((Obsolescent)node, (Obsolescent)node, this, objectValue, node){
                    final /* synthetic */ Obsolescent $node;
                    final /* synthetic */ VariableView this$0;
                    final /* synthetic */ ObjectValue $objectValue$inlined;
                    final /* synthetic */ XCompositeNode $node$inlined;

                    public Promise<Unit> fun(Object param) {
                        Object it = param;
                        return VariableView.access$computeNamedProperties(this.this$0, this.$objectValue$inlined, this.$node$inlined, true);
                    }
                    {
                        this.$node = $captured_local_variable$1;
                        this.this$0 = variableView;
                        this.$objectValue$inlined = objectValue;
                        this.$node$inlined = xCompositeNode;
                        super($super_call_param$2);
                    }
                });
                smartList.add((Object)promise3);
            }
        }
        if (hasIndexedProperties == hasNamedProperties || additionalProperties != null) {
            $receiver$iv = Promises.all((Collection)((Collection)promises));
            Promise promise4 = $receiver$iv;
            if (promise4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
            }
            promise4.processed((Consumer)new ObsolescentConsumer<Object>((Obsolescent)node, (Obsolescent)node, node){
                final /* synthetic */ Obsolescent $node;
                final /* synthetic */ XCompositeNode $node$inlined;

                public void consume(Object param) {
                    this.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                }
                {
                    this.$node = $captured_local_variable$1;
                    this.$node$inlined = xCompositeNode;
                    super($super_call_param$2);
                }
            });
        }
    }

    private final Promise<?> computeIndexedProperties(ArrayValue value, XCompositeNode node, boolean isLastChildren) {
        return ObjectValue.DefaultImpls.getIndexedProperties$default(value, 0, value.getLength(), 100, new ObsolescentIndexedVariablesConsumer(this, value, node, isLastChildren, node){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ ArrayValue $value;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ boolean $isLastChildren;

            public void consumeRanges(@Nullable int[] ranges) {
                if (ranges == null) {
                    XValueChildrenList groupList = new XValueChildrenList();
                    LazyVariablesGroupKt.addGroups(this.$value, computeIndexedProperties.consumeRanges.1.INSTANCE, groupList, 0, this.$value.getLength(), 100, this.this$0);
                    this.$node.addChildren(groupList, this.$isLastChildren);
                } else {
                    LazyVariablesGroupKt.addRanges(this.$value, ranges, this.$node, this.this$0, this.$isLastChildren);
                }
            }

            public void consumeVariables(@NotNull List<? extends Variable> variables) {
                Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
                this.$node.addChildren(VariablesKt.createVariablesList(variables, this.this$0, null), this.$isLastChildren);
            }
            {
                this.this$0 = $outer;
                this.$value = $captured_local_variable$1;
                this.$node = $captured_local_variable$2;
                this.$isLastChildren = $captured_local_variable$3;
                super($super_call_param$4);
            }
        }, null, 16, null);
    }

    private final Promise<Unit> computeNamedProperties(ObjectValue value, XCompositeNode node, boolean isLastChildren) {
        return VariablesKt.processVariables(this, value.getProperties(), (Obsolescent)node, (Function2<? super MemberFilter, ? super List<? extends Variable>, Unit>)((Function2)new Function2<MemberFilter, List<? extends Variable>, Unit>(this, value, node, isLastChildren){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ ObjectValue $value;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ boolean $isLastChildren;

            public final void invoke(@NotNull MemberFilter memberFilter, @NotNull List<? extends Variable> variables) {
                FunctionValue functionValue;
                Intrinsics.checkParameterIsNotNull((Object)memberFilter, (String)"memberFilter");
                Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
                VariableView.access$set_memberFilter$p(this.this$0, memberFilter);
                if (Intrinsics.areEqual((Object)((Object)this.$value.getType()), (Object)((Object)ValueType.ARRAY)) && !(this.$value instanceof ArrayValue)) {
                    VariableView.access$computeArrayRanges(this.this$0, variables, this.$node);
                    return;
                }
                ObjectValue objectValue = this.$value;
                if (!(objectValue instanceof FunctionValue)) {
                    objectValue = null;
                }
                if ((functionValue = (FunctionValue)objectValue) != null && Intrinsics.areEqual((Object)functionValue.hasScopes(), (Object)ThreeState.NO)) {
                    functionValue = null;
                }
                VariableView.access$setRemainingChildren$p(this.this$0, VariablesKt.processNamedObjectProperties(variables, this.$node, this.this$0, memberFilter, 100, this.$isLastChildren && functionValue == null));
                if (VariableView.access$getRemainingChildren$p(this.this$0) != null) {
                    VariableView.access$setRemainingChildrenOffset$p(this.this$0, 100);
                }
                if (functionValue != null) {
                    this.$node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new FunctionScopesValueGroup(functionValue, VariableView.access$getContext$p(this.this$0))), this.$isLastChildren);
                }
            }
            {
                this.this$0 = variableView;
                this.$value = objectValue;
                this.$node = xCompositeNode;
                this.$isLastChildren = bl;
                super(2);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void computeArrayRanges(List<? extends Variable> properties, XCompositeNode node) {
        int notGroupedVariablesOffset;
        int bucketSize;
        List<Variable> variables;
        int count;
        MemberFilter memberFilter = this._memberFilter;
        if (memberFilter == null) {
            Intrinsics.throwNpe();
        }
        if ((count = (variables = VariablesKt.filterAndSort(properties, memberFilter)).size()) <= (bucketSize = 100)) {
            node.addChildren(VariablesKt.createVariablesList(variables, this, null), true);
            return;
        }
        while (count > 0 && !Character.isDigit(variables.get(count - 1).getName().charAt(0))) {
            --count;
        }
        XValueChildrenList groupList = new XValueChildrenList();
        if (count > 0) {
            LazyVariablesGroupKt.addGroups(variables, computeArrayRanges.1.INSTANCE, groupList, 0, count, bucketSize, this);
        }
        if (variables.size() - count > bucketSize) {
            for (notGroupedVariablesOffset = variables.size(); notGroupedVariablesOffset > 0 && StringsKt.startsWith$default((String)variables.get(notGroupedVariablesOffset - 1).getName(), (String)"__", (boolean)false, (int)2, null); --notGroupedVariablesOffset) {
            }
            if (notGroupedVariablesOffset > 0) {
                LazyVariablesGroupKt.addGroups(variables, computeArrayRanges.2.INSTANCE, groupList, count, notGroupedVariablesOffset, bucketSize, this);
            }
        } else {
            notGroupedVariablesOffset = count;
        }
        int n = notGroupedVariablesOffset;
        int n2 = variables.size() - 1;
        if (n <= n2) {
            while (true) {
                void i2;
                Variable variable = variables.get((int)i2);
                MemberFilter memberFilter2 = this._memberFilter;
                if (memberFilter2 == null) {
                    Intrinsics.throwNpe();
                }
                groupList.add((XNamedValue)new VariableView(memberFilter2.rawNameToSource(variable), variable, this));
                if (i2 == n2) break;
                ++i2;
            }
        }
        node.addChildren(groupList, true);
    }

    private final Icon getIcon() {
        Value value = this.value;
        if (value == null) {
            Intrinsics.throwNpe();
        }
        return Companion.getIcon(value);
    }

    @Nullable
    public XValueModifier getModifier() {
        if (!this.variable.isMutable()) {
            return null;
        }
        return new XValueModifier(this){
            final /* synthetic */ VariableView this$0;

            @Nullable
            public String getInitialValueEditorText() {
                String string;
                Value value = VariableView.access$getValue$p(this.this$0);
                if (value == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)((Object)value.getType()), (Object)((Object)ValueType.STRING))) {
                    Value value2 = VariableView.access$getValue$p(this.this$0);
                    if (value2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = value2.getValueString();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string3 = string2;
                    StringBuilder builder = new StringBuilder(string3.length());
                    builder.append('\"');
                    StringUtil.escapeStringCharacters((int)string3.length(), (String)string3, (StringBuilder)builder);
                    builder.append('\"');
                    return builder.toString();
                }
                Value value3 = VariableView.access$getValue$p(this.this$0);
                if (value3 == null) {
                    Intrinsics.throwNpe();
                }
                if (value3.getType().isObjectType()) {
                    string = null;
                } else {
                    Value value4 = VariableView.access$getValue$p(this.this$0);
                    if (value4 == null) {
                        Intrinsics.throwNpe();
                    }
                    string = value4.getValueString();
                }
                return string;
            }

            public void setValue(@NotNull String expression, @NotNull XValueModifier.XModificationCallback callback) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
                ValueModifier valueModifier = VariableView.access$getVariable$p(this.this$0).getValueModifier();
                if (valueModifier == null) {
                    Intrinsics.throwNpe();
                }
                Promise<?> $receiver$iv = valueModifier.setValue(VariableView.access$getVariable$p(this.this$0), expression, this.this$0.getEvaluateContext());
                $receiver$iv.done((Consumer)new Consumer<Object>(this, callback){
                    final /* synthetic */ getModifier.1 this$0;
                    final /* synthetic */ XValueModifier.XModificationCallback $callback$inlined;

                    public final void consume(Object it) {
                        VariableView.access$setValue$p(this.this$0.this$0, null);
                        this.$callback$inlined.valueModified();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$callback$inlined = xModificationCallback;
                    }
                }).rejected((Consumer)new Consumer<Throwable>(callback){
                    final /* synthetic */ XValueModifier.XModificationCallback $callback;

                    public final void consume(Throwable it) {
                        String string = it.getMessage();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$callback.errorOccurred(string);
                    }
                    {
                        this.$callback = xModificationCallback;
                    }
                });
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Nullable
    public final Value getValue() {
        return this.variable.getValue();
    }

    public boolean canNavigateToSource() {
        return this.value instanceof FunctionValue || this.getViewSupport().canNavigateToSource(this.variable, this.context);
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        if (this.value instanceof FunctionValue) {
            Value value = this.value;
            if (value == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.values.FunctionValue");
            }
            ((FunctionValue)value).resolve().done((Consumer)new Consumer<FunctionValue>(this, navigatable){
                final /* synthetic */ VariableView this$0;
                final /* synthetic */ XNavigatable $navigatable;

                public final void consume(FunctionValue function) {
                    Vm vm = this.this$0.getVm();
                    if (vm == null) {
                        Intrinsics.throwNpe();
                    }
                    ScriptManager scriptManager = vm.getScriptManager();
                    FunctionValue functionValue = function;
                    Intrinsics.checkExpressionValueIsNotNull((Object)functionValue, (String)"function");
                    scriptManager.getScript(functionValue).done((Consumer)new Consumer<Script>(this, function){
                        final /* synthetic */ computeSourcePosition.1 this$0;
                        final /* synthetic */ FunctionValue $function;

                        /*
                         * Unable to fully structure code
                         * Could not resolve type clashes
                         */
                        public final void consume(Script it) {
                            v0 = this.this$0.$navigatable;
                            v1 = it;
                            if (v1 == null) ** GOTO lbl-1000
                            var2_2 = v1;
                            var5_3 = v0;
                            it = var2_2;
                            var6_5 /* !! */  = this.this$0.this$0.getViewSupport().getSourceInfo((String)null, (Script)it, this.$function.getOpenParenLine(), this.$function.getOpenParenColumn());
                            v0 = var5_3;
                            v1 = var6_5 /* !! */ ;
                            if (v1 != null) {
                                var2_2 = v1;
                                var5_3 = v0;
                                it = (SourceInfo)var2_2;
                                var6_5 /* !! */  = new XSourcePositionWrapper((SourceInfo)it, (XSourcePosition)it){
                                    final /* synthetic */ SourceInfo $it;

                                    @NotNull
                                    public Navigatable createNavigatable(@NotNull Project project2) {
                                        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                                        Navigatable navigatable = (Navigatable)PsiVisitors.visit(this.myPosition, project2, computeSourcePosition.2.createNavigatable.1.INSTANCE);
                                        if (navigatable == null) {
                                            Navigatable navigatable2 = super.createNavigatable(project2);
                                            navigatable = navigatable2;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)navigatable2, (String)"super.createNavigatable(project)");
                                        }
                                        return navigatable;
                                    }
                                    {
                                        this.$it = $captured_local_variable$0;
                                        super($super_call_param$1);
                                    }
                                };
                                v0 = var5_3;
                                v2 = var6_5 /* !! */ ;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = null;
                            }
                            v0.setSourcePosition((XSourcePosition)v2);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$function = functionValue;
                        }
                    });
                }
                {
                    this.this$0 = variableView;
                    this.$navigatable = xNavigatable;
                }
            });
        } else {
            DebuggerViewSupport debuggerViewSupport = this.getViewSupport();
            String string = this.getVariableName();
            Value value = this.value;
            if (value == null) {
                Intrinsics.throwNpe();
            }
            debuggerViewSupport.computeSourcePosition(string, value, this.variable, this.context, navigatable);
        }
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        return this.getViewSupport().computeInlineDebuggerData(this.getVariableName(), this.variable, this.context, callback);
    }

    @Nullable
    public String getEvaluationExpression() {
        if (!this.watchableAsEvaluationExpression()) {
            return null;
        }
        SmartList list = new SmartList();
        VariableContext variableContext = this.getParent();
        String string = this.variable.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name");
        this.addVarName((SmartList<String>)list, variableContext, string);
        for (VariableContext parent = this.context; parent != null && parent.getVariableName() != null; parent = parent.getParent()) {
            VariableContext variableContext2 = parent.getParent();
            String string2 = parent.getVariableName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            this.addVarName((SmartList<String>)list, variableContext2, string2);
        }
        return this.context.getViewSupport().propertyNamesToString((List)list, false);
    }

    private final void addVarName(SmartList<String> list, VariableContext parent, String name) {
        if (parent == null || parent.getVariableName() != null) {
            list.add((Object)name);
        } else {
            list.addAll((Collection)CollectionsKt.reversed((Iterable)StringsKt.split$default((CharSequence)name, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null)));
        }
    }

    @Override
    @NotNull
    public String getVariableName() {
        return this.variableName;
    }

    public VariableView(@NotNull String variableName, @NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variableName, (String)"variableName");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(variableName);
        this.variableName = variableName;
        this.variable = variable;
        this.parent = this.context = context;
    }

    public static final /* synthetic */ void access$setEvaluatedValue(VariableView $this, @Nullable Value value, @Nullable String error, @NotNull XValueNode node) {
        $this.setEvaluatedValue(value, error, node);
    }

    @Nullable
    public static final /* synthetic */ Value access$getValue$p(VariableView $this) {
        return $this.value;
    }

    public static final /* synthetic */ void access$setValue$p(VariableView $this, @Nullable Value value) {
        $this.value = value;
    }

    public static final /* synthetic */ void access$computePresentation(VariableView $this, @NotNull Value value, @NotNull XValueNode node) {
        $this.computePresentation(value, node);
    }

    @NotNull
    public static final /* synthetic */ Variable access$getVariable$p(VariableView $this) {
        return $this.variable;
    }

    @NotNull
    public static final /* synthetic */ VariableContext access$getContext$p(VariableView $this) {
        return $this.context;
    }

    @NotNull
    public static final /* synthetic */ Promise access$computeNamedProperties(VariableView $this, @NotNull ObjectValue value, @NotNull XCompositeNode node, boolean isLastChildren) {
        return $this.computeNamedProperties(value, node, isLastChildren);
    }

    @Nullable
    public static final /* synthetic */ MemberFilter access$get_memberFilter$p(VariableView $this) {
        return $this._memberFilter;
    }

    public static final /* synthetic */ void access$set_memberFilter$p(VariableView $this, @Nullable MemberFilter memberFilter) {
        $this._memberFilter = memberFilter;
    }

    public static final /* synthetic */ void access$computeArrayRanges(VariableView $this, @NotNull List properties, @NotNull XCompositeNode node) {
        $this.computeArrayRanges(properties, node);
    }

    @Nullable
    public static final /* synthetic */ List access$getRemainingChildren$p(VariableView $this) {
        return $this.remainingChildren;
    }

    public static final /* synthetic */ void access$setRemainingChildren$p(VariableView $this, @Nullable List list) {
        $this.remainingChildren = list;
    }

    public static final /* synthetic */ int access$getRemainingChildrenOffset$p(VariableView $this) {
        return $this.remainingChildrenOffset;
    }

    public static final /* synthetic */ void access$setRemainingChildrenOffset$p(VariableView $this, int n) {
        $this.remainingChildrenOffset = n;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/debugger/VariableView$ObsolescentIndexedVariablesConsumer;", "Lorg/jetbrains/debugger/values/IndexedVariablesConsumer;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "(Lcom/intellij/xdebugger/frame/XCompositeNode;)V", "isObsolete", "", "()Z", "getNode", "()Lcom/intellij/xdebugger/frame/XCompositeNode;", "script-debugger-ui"})
    public static abstract class ObsolescentIndexedVariablesConsumer
    extends IndexedVariablesConsumer {
        @NotNull
        private final XCompositeNode node;

        @Override
        public boolean isObsolete() {
            return this.node.isObsolete();
        }

        @NotNull
        protected final XCompositeNode getNode() {
            return this.node;
        }

        public ObsolescentIndexedVariablesConsumer(@NotNull XCompositeNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            this.node = node;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/debugger/VariableView$MyFullValueEvaluator;", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "value", "Lorg/jetbrains/debugger/values/Value;", "(Lorg/jetbrains/debugger/values/Value;)V", "startEvaluation", "", "callback", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator$XFullValueEvaluationCallback;", "script-debugger-ui"})
    private static final class MyFullValueEvaluator
    extends XFullValueEvaluator {
        private final Value value;

        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            if (!(this.value instanceof StringValue) || !((StringValue)this.value).isTruncated()) {
                String string = this.value.getValueString();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                callback.evaluated(string);
                return;
            }
            AtomicBoolean evaluated = new AtomicBoolean();
            ((StringValue)this.value).getFullString().done((Consumer)new Consumer<String>(this, callback, evaluated){
                final /* synthetic */ MyFullValueEvaluator this$0;
                final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback;
                final /* synthetic */ AtomicBoolean $evaluated;

                public final void consume(String it) {
                    if (!this.$callback.isObsolete() && this.$evaluated.compareAndSet(false, true)) {
                        String string = MyFullValueEvaluator.access$getValue$p(this.this$0).getValueString();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$callback.evaluated(string);
                    }
                }
                {
                    this.this$0 = myFullValueEvaluator;
                    this.$callback = xFullValueEvaluationCallback;
                    this.$evaluated = atomicBoolean;
                }
            }).rejected((Consumer)new Consumer<Throwable>(callback){
                final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback;

                public final void consume(Throwable it) {
                    String string = it.getMessage();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$callback.errorOccurred(string);
                }
                {
                    this.$callback = xFullValueEvaluationCallback;
                }
            });
        }

        public MyFullValueEvaluator(@NotNull Value value) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (value instanceof StringValue) {
                n = ((StringValue)value).getLength();
            } else {
                String string = value.getValueString();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                n = string.length();
            }
            super(n);
            this.value = value;
        }

        @NotNull
        public static final /* synthetic */ Value access$getValue$p(MyFullValueEvaluator $this) {
            return $this.value;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/debugger/VariableView$Companion;", "", "()V", "getIcon", "Ljavax/swing/Icon;", "value", "Lorg/jetbrains/debugger/values/Value;", "setArrayPresentation", "", "context", "Lorg/jetbrains/debugger/VariableContext;", "icon", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "setObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "script-debugger-ui"})
    public static final class Companion {
        public final void setObjectPresentation(@NotNull ObjectValue value, @NotNull Icon icon, @NotNull XValueNode node) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            node.setPresentation(icon, (XValuePresentation)new ObjectValuePresentation(VariableViewKt.getObjectValueDescription(value)), Intrinsics.areEqual((Object)value.hasProperties(), (Object)ThreeState.NO) ^ true);
        }

        public final void setArrayPresentation(@NotNull Value value, @NotNull VariableContext context, @NotNull Icon icon, @NotNull XValueNode node) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            boolean bl = Intrinsics.areEqual((Object)((Object)value.getType()), (Object)((Object)ValueType.ARRAY));
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (value instanceof ArrayValue) {
                int length = ((ArrayValue)value).getLength();
                node.setPresentation(icon, (XValuePresentation)new ArrayPresentation(length, ((ArrayValue)value).getClassName()), length > 0);
                return;
            }
            String valueString = value.getValueString();
            if (valueString != null && StringsKt.endsWith$default((String)valueString, (String)"]", (boolean)false, (int)2, null) && VariableViewKt.access$getARRAY_DESCRIPTION_PATTERN$p().matcher(valueString).find()) {
                node.setPresentation(icon, (String)null, valueString, true);
            } else {
                Promise $receiver$iv;
                Promise<EvaluateResult> promise2 = context.getEvaluateContext().evaluate("a.length", Collections.singletonMap("a", value), false);
                $receiver$iv = $receiver$iv.done((Consumer)new ObsolescentConsumer<EvaluateResult>((Obsolescent)node, (Obsolescent)node, node, icon){
                    final /* synthetic */ Obsolescent $node;
                    final /* synthetic */ XValueNode $node$inlined;
                    final /* synthetic */ Icon $icon$inlined;

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public void consume(Object param) {
                        EvaluateResult it = (EvaluateResult)param;
                        this.$node$inlined.setPresentation(this.$icon$inlined, (String)null, "Array[" + it.getValue().getValueString() + "]", true);
                    }
                    {
                        this.$node = $captured_local_variable$1;
                        this.$node$inlined = xValueNode;
                        this.$icon$inlined = icon;
                        super($super_call_param$2);
                    }
                });
                $receiver$iv.rejected((Consumer)new ObsolescentConsumer<Throwable>((Obsolescent)node, (Obsolescent)node, node, icon){
                    final /* synthetic */ Obsolescent $node;
                    final /* synthetic */ XValueNode $node$inlined;
                    final /* synthetic */ Icon $icon$inlined;

                    public void consume(Throwable param) {
                        Throwable it = param;
                        this.$node$inlined.setPresentation(this.$icon$inlined, (String)null, "Internal error: " + it, false);
                    }
                    {
                        this.$node = $captured_local_variable$1;
                        this.$node$inlined = xValueNode;
                        this.$icon$inlined = icon;
                        super($super_call_param$2);
                    }
                });
            }
        }

        @NotNull
        public final Icon getIcon(@NotNull Value value) {
            Icon icon;
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            ValueType type = value.getType();
            switch (VariableView$Companion$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Icon icon2 = AllIcons.Nodes.Function;
                    icon = icon2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Nodes.Function");
                    break;
                }
                case 2: {
                    Icon icon3 = AllIcons.Debugger.Db_array;
                    icon = icon3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_array");
                    break;
                }
                default: {
                    Icon icon4 = type.isObjectType() ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
                    icon = icon4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"if (type.isObjectType) A\u2026ons.Debugger.Db_primitive");
                }
            }
            return icon;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

