/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.config.FilterPattern;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class GenerateToStringUtils {
    private static final Logger log = Logger.getInstance((String)"#GenerateToStringUtils");

    private GenerateToStringUtils() {
    }

    @NotNull
    public static PsiField[] filterAvailableFields(PsiClass clazz, FilterPattern pattern) {
        PsiField[] fields;
        if (log.isDebugEnabled()) {
            log.debug("Filtering fields using the pattern: " + pattern);
        }
        ArrayList<PsiField> availableFields = new ArrayList<PsiField>();
        for (PsiField field : fields = clazz.getFields()) {
            if (pattern.fieldMatches(field)) continue;
            availableFields.add(field);
        }
        PsiField[] psiFieldArray = availableFields.toArray(new PsiField[availableFields.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/generate/GenerateToStringUtils", "filterAvailableFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiMethod[] filterAvailableMethods(PsiClass clazz, @NotNull FilterPattern pattern) {
        PsiMethod[] methods;
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/jetbrains/java/generate/GenerateToStringUtils", "filterAvailableMethods"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Filtering methods using the pattern: " + pattern);
        }
        ArrayList<PsiMethod> availableMethods = new ArrayList<PsiMethod>();
        for (PsiMethod method2 : methods = clazz.getMethods()) {
            String methodName;
            String fieldName;
            PsiType returnType;
            if (!PsiAdapter.isGetterMethod(method2) || (returnType = method2.getReturnType()) == null || PsiType.VOID.equals((Object)returnType) || !method2.hasModifierProperty("public") || method2.hasModifierProperty("static") || method2.hasModifierProperty("abstract") || clazz.findFieldByName(fieldName = PsiAdapter.getGetterFieldName(method2), false) != null || "toString".equals(methodName = method2.getName()) || "getClass".equals(methodName) || "hashCode".equals(methodName) || pattern.methodMatches(method2)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Adding the method " + methodName + " as there is not a field for this getter");
            }
            availableMethods.add(method2);
        }
        PsiMethod[] psiMethodArray = availableMethods.toArray(new PsiMethod[availableMethods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/generate/GenerateToStringUtils", "filterAvailableMethods"));
        }
        return psiMethodArray;
    }
}

