/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.Bindable;
import android.databinding.BindingBuildInfo;
import android.databinding.annotationprocessor.AnnotationUtil;
import android.databinding.annotationprocessor.ProcessDataBinding;
import android.databinding.tool.CompilerChef;
import android.databinding.tool.util.GenerationalClassUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.BRWriter;
import android.databinding.tool.writer.JavaFileWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;

public class ProcessBindable
extends ProcessDataBinding.ProcessingStep
implements CompilerChef.BindableHolder {
    Intermediate mProperties;
    HashMap<String, HashSet<String>> mLayoutVariables = new HashMap();

    @Override
    public boolean onHandleStep(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, BindingBuildInfo buildInfo) {
        if (this.mProperties == null) {
            this.mProperties = new IntermediateV1(buildInfo.modulePackage());
            this.mergeLayoutVariables();
            this.mLayoutVariables.clear();
            TypeElement observableType = processingEnv.getElementUtils().getTypeElement("android.databinding.Observable");
            Types typeUtils = processingEnv.getTypeUtils();
            for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, Bindable.class)) {
                String name;
                TypeElement enclosing;
                Element enclosingElement = element.getEnclosingElement();
                ElementKind kind = enclosingElement.getKind();
                if (kind != ElementKind.CLASS && kind != ElementKind.INTERFACE) {
                    L.e("Bindable must be on a member field or method. The enclosing type is %s", new Object[]{enclosingElement.getKind()});
                }
                if (!typeUtils.isAssignable((enclosing = (TypeElement)enclosingElement).asType(), observableType.asType())) {
                    L.e("Bindable must be on a member in an Observable class. %s is not Observable", enclosingElement.getSimpleName());
                }
                if ((name = this.getPropertyName(element)) == null) continue;
                Preconditions.checkNotNull(this.mProperties, "Must receive app / library info before Bindable fields.", new Object[0]);
                this.mProperties.addProperty(enclosing.getQualifiedName().toString(), name);
            }
            GenerationalClassUtil.writeIntermediateFile(processingEnv, this.mProperties.getPackage(), this.createIntermediateFileName(this.mProperties.getPackage()), this.mProperties);
            this.generateBRClasses(!buildInfo.isLibrary(), this.mProperties.getPackage());
        }
        return false;
    }

    @Override
    public void addVariable(String variableName, String containingClassName) {
        HashSet<String> variableNames = this.mLayoutVariables.get(containingClassName);
        if (variableNames == null) {
            variableNames = new HashSet();
            this.mLayoutVariables.put(containingClassName, variableNames);
        }
        variableNames.add(variableName);
    }

    @Override
    public void onProcessingOver(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) {
    }

    private String createIntermediateFileName(String appPkg) {
        return appPkg + GenerationalClassUtil.ExtensionFilter.BR.getExtension();
    }

    private void generateBRClasses(boolean useFinalFields, String pkg) {
        L.d("************* Generating BR file %s. use final: %s", pkg, useFinalFields);
        HashSet<String> properties = new HashSet<String>();
        this.mProperties.captureProperties(properties);
        List<Intermediate> previousIntermediates = this.loadPreviousBRFiles();
        for (Intermediate intermediate : previousIntermediates) {
            intermediate.captureProperties(properties);
        }
        JavaFileWriter writer = this.getWriter();
        BRWriter brWriter = new BRWriter(properties, useFinalFields);
        writer.writeToFile(pkg + ".BR", brWriter.write(pkg));
        if (useFinalFields) {
            for (Intermediate intermediate : previousIntermediates) {
                writer.writeToFile(intermediate.getPackage() + ".BR", brWriter.write(intermediate.getPackage()));
            }
        }
        this.mCallback.onBrWriterReady(brWriter);
    }

    private String getPropertyName(Element element) {
        switch (element.getKind()) {
            case FIELD: {
                return ProcessBindable.stripPrefixFromField((VariableElement)element);
            }
            case METHOD: {
                return this.stripPrefixFromMethod((ExecutableElement)element);
            }
        }
        L.e("@Bindable is not allowed on %s", new Object[]{element.getKind()});
        return null;
    }

    private static String stripPrefixFromField(VariableElement element) {
        Name name = element.getSimpleName();
        if (name.length() >= 2) {
            char firstChar = name.charAt(0);
            char secondChar = name.charAt(1);
            if (name.length() > 2 && firstChar == 'm' && secondChar == '_') {
                char thirdChar = name.charAt(2);
                if (Character.isJavaIdentifierStart(thirdChar)) {
                    return "" + Character.toLowerCase(thirdChar) + name.subSequence(3, name.length());
                }
            } else if (firstChar == 'm' && Character.isUpperCase(secondChar) || firstChar == '_' && Character.isJavaIdentifierStart(secondChar)) {
                return "" + Character.toLowerCase(secondChar) + name.subSequence(2, name.length());
            }
        }
        return name.toString();
    }

    private String stripPrefixFromMethod(ExecutableElement element) {
        CharSequence propertyName;
        Name name = element.getSimpleName();
        if (ProcessBindable.isGetter(element) || ProcessBindable.isSetter(element)) {
            propertyName = name.subSequence(3, name.length());
        } else if (ProcessBindable.isBooleanGetter(element)) {
            propertyName = name.subSequence(2, name.length());
        } else {
            L.e("@Bindable associated with method must follow JavaBeans convention %s", element);
            return null;
        }
        char firstChar = propertyName.charAt(0);
        return "" + Character.toLowerCase(firstChar) + propertyName.subSequence(1, propertyName.length());
    }

    private void mergeLayoutVariables() {
        for (String containingClass : this.mLayoutVariables.keySet()) {
            for (String variable : this.mLayoutVariables.get(containingClass)) {
                this.mProperties.addProperty(containingClass, variable);
            }
        }
    }

    private static boolean prefixes(CharSequence sequence, String prefix) {
        boolean prefixes = false;
        if (sequence.length() > prefix.length()) {
            int count = prefix.length();
            prefixes = true;
            for (int i = 0; i < count; ++i) {
                if (sequence.charAt(i) == prefix.charAt(i)) continue;
                prefixes = false;
                break;
            }
        }
        return prefixes;
    }

    private static boolean isGetter(ExecutableElement element) {
        Name name = element.getSimpleName();
        return ProcessBindable.prefixes(name, "get") && Character.isJavaIdentifierStart(name.charAt(3)) && element.getParameters().isEmpty() && element.getReturnType().getKind() != TypeKind.VOID;
    }

    private static boolean isSetter(ExecutableElement element) {
        Name name = element.getSimpleName();
        return ProcessBindable.prefixes(name, "set") && Character.isJavaIdentifierStart(name.charAt(3)) && element.getParameters().size() == 1 && element.getReturnType().getKind() == TypeKind.VOID;
    }

    private static boolean isBooleanGetter(ExecutableElement element) {
        Name name = element.getSimpleName();
        return ProcessBindable.prefixes(name, "is") && Character.isJavaIdentifierStart(name.charAt(2)) && element.getParameters().isEmpty() && element.getReturnType().getKind() == TypeKind.BOOLEAN;
    }

    private List<Intermediate> loadPreviousBRFiles() {
        return GenerationalClassUtil.loadObjects(GenerationalClassUtil.ExtensionFilter.BR);
    }

    private static class IntermediateV1
    implements Serializable,
    Intermediate {
        private static final long serialVersionUID = 2L;
        private String mPackage;
        private final HashMap<String, HashSet<String>> mProperties = new HashMap();

        public IntermediateV1(String aPackage) {
            this.mPackage = aPackage;
        }

        @Override
        public void captureProperties(Set<String> properties) {
            for (HashSet<String> propertySet : this.mProperties.values()) {
                properties.addAll(propertySet);
            }
        }

        @Override
        public void addProperty(String className, String propertyName) {
            HashSet<String> properties = this.mProperties.get(className);
            if (properties == null) {
                properties = new HashSet();
                this.mProperties.put(className, properties);
            }
            properties.add(propertyName);
        }

        @Override
        public boolean hasValues() {
            return !this.mProperties.isEmpty();
        }

        @Override
        public String getPackage() {
            return this.mPackage;
        }
    }

    private static interface Intermediate
    extends Serializable {
        public void captureProperties(Set<String> var1);

        public void addProperty(String var1, String var2);

        public boolean hasValues();

        public String getPackage();
    }
}

