/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class FieldConflictsResolver {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.introduce.parameter.FieldConflictsResolver");
    private final GrCodeBlock myScope;
    private PsiField myField = null;
    private List<GrReferenceExpression> myReferenceExpressions = null;
    private PsiClass myQualifyingClass;

    public FieldConflictsResolver(String name, GrCodeBlock scope) {
        this.myScope = scope;
        if (this.myScope == null) {
            return;
        }
        GroovyPsiElement resolved = ResolveUtil.resolveProperty(this.myScope, name);
        if (resolved instanceof GrReferenceExpression || resolved == null) {
            return;
        }
        assert (resolved instanceof PsiVariable);
        PsiVariable oldVariable = (PsiVariable)resolved;
        PsiField psiField = this.myField = oldVariable instanceof PsiField ? (PsiField)oldVariable : null;
        if (!(oldVariable instanceof PsiField)) {
            return;
        }
        this.myReferenceExpressions = new ArrayList<GrReferenceExpression>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myField, (SearchScope)new LocalSearchScope((PsiElement)this.myScope), (boolean)false)) {
            GrReferenceExpression referenceExpression;
            PsiElement element = reference.getElement();
            if (!(element instanceof GrReferenceExpression) || (referenceExpression = (GrReferenceExpression)element).getQualifier() != null) continue;
            this.myReferenceExpressions.add(referenceExpression);
        }
        if (this.myField.hasModifierProperty("static")) {
            this.myQualifyingClass = this.myField.getContainingClass();
        }
    }

    public GrExpression fixInitializer(GrExpression initializer) {
        if (this.myField == null) {
            return initializer;
        }
        final GrReferenceExpression[] replacedRef = new GrReferenceExpression[]{null};
        initializer.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/FieldConflictsResolver$1", "visitReferenceExpression"));
                }
                GrExpression qualifierExpression = (GrExpression)expression.getQualifier();
                if (qualifierExpression != null) {
                    qualifierExpression.accept(this);
                } else {
                    PsiElement result = expression.resolve();
                    if (expression.getManager().areElementsEquivalent(result, (PsiElement)FieldConflictsResolver.this.myField)) {
                        try {
                            replacedRef[0] = FieldConflictsResolver.qualifyReference(expression, (PsiMember)FieldConflictsResolver.this.myField, FieldConflictsResolver.this.myQualifyingClass);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
        });
        if (!initializer.isValid()) {
            return replacedRef[0];
        }
        return initializer;
    }

    public void fix() throws IncorrectOperationException {
        if (this.myField == null) {
            return;
        }
        PsiManager manager = this.myScope.getManager();
        for (GrReferenceExpression referenceExpression : this.myReferenceExpressions) {
            PsiElement newlyResolved;
            if (!referenceExpression.isValid() || manager.areElementsEquivalent(newlyResolved = referenceExpression.resolve(), (PsiElement)this.myField)) continue;
            FieldConflictsResolver.qualifyReference(referenceExpression, (PsiMember)this.myField, this.myQualifyingClass);
        }
    }

    public static GrReferenceExpression qualifyReference(GrReferenceExpression referenceExpression, PsiMember member, @Nullable PsiClass qualifyingClass) throws IncorrectOperationException {
        GrReferenceExpression expressionFromText;
        PsiManager manager = referenceExpression.getManager();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(referenceExpression.getProject());
        if (qualifyingClass == null) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
            PsiClass containingClass = member.getContainingClass();
            if (parentClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)containingClass, (boolean)true)) {
                while (parentClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)containingClass, (boolean)true)) {
                    parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, (boolean)true);
                }
                LOG.assertTrue(parentClass != null);
                expressionFromText = factory.createReferenceExpressionFromText("A.this." + member.getName());
                ((GrExpression)((GrReferenceExpression)expressionFromText.getQualifier()).getQualifier()).replace(factory.createReferenceElementForClass(parentClass));
            } else {
                expressionFromText = (GrReferenceExpression)factory.createExpressionFromText("this." + member.getName());
            }
        } else {
            expressionFromText = (GrReferenceExpression)factory.createExpressionFromText("A." + member.getName());
            expressionFromText.setQualifier(factory.createReferenceElementForClass(qualifyingClass));
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        expressionFromText = (GrReferenceExpression)codeStyleManager.reformat((PsiElement)expressionFromText);
        return (GrReferenceExpression)referenceExpression.replace(expressionFromText);
    }
}

