/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.Hash;
import git4idea.actions.GitLogSingleCommitAction;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.repo.GitRepository;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class GitCreateNewBranchAction
extends GitLogSingleCommitAction {
    protected void actionPerformed(@NotNull GitRepository repository, @NotNull Hash commit) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/actions/GitCreateNewBranchAction", "actionPerformed"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/actions/GitCreateNewBranchAction", "actionPerformed"));
        }
        Project project = repository.getProject();
        String name = GitBranchUtil.getNewBranchNameFromUser(project, Collections.singleton(repository), "Checkout New Branch From " + commit.toShortString());
        if (name != null) {
            GitBrancher brancher = GitBrancher.getInstance(project);
            brancher.checkoutNewBranchStartingFrom(name, commit.asString(), Collections.singletonList(repository), null);
        }
    }
}

