/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.PushTargetEditorListener;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.dvcs.push.ui.VcsEditableTextComponent;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import git4idea.GitRemoteBranch;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.remote.GitDefineRemoteDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushTargetPanel
extends PushTargetPanel<GitPushTarget> {
    private static final Logger LOG = Logger.getInstance(GitPushTargetPanel.class);
    private static final Comparator<GitRemoteBranch> REMOTE_BRANCH_COMPARATOR = new MyRemoteBranchComparator();
    private static final String SEPARATOR = " : ";
    private static final Color NEW_BRANCH_LABEL_FG = new JBColor(46397, 2397500);
    private static final Color NEW_BRANCH_LABEL_BG = ColorUtil.toAlpha((Color)NEW_BRANCH_LABEL_FG, (int)40);
    private static final RelativeFont NEW_BRANCH_LABEL_FONT = RelativeFont.TINY.small();
    private static final TextIcon NEW_BRANCH_LABEL = new TextIcon("New", NEW_BRANCH_LABEL_FG, NEW_BRANCH_LABEL_BG, 0);
    @NotNull
    private final GitPushSupport myPushSupport;
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsEditableTextComponent myTargetRenderer;
    @NotNull
    private final PushTargetTextField myTargetEditor;
    @NotNull
    private final VcsLinkedTextComponent myRemoteRenderer;
    @NotNull
    private final Project myProject;
    @Nullable
    private GitPushTarget myCurrentTarget;
    @Nullable
    private String myError;
    @Nullable
    private Runnable myFireOnChangeAction;

    public GitPushTargetPanel(@NotNull GitPushSupport support, @NotNull GitRepository repository, @Nullable GitPushTarget defaultTarget) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "git4idea/push/GitPushTargetPanel", "<init>"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushTargetPanel", "<init>"));
        }
        this.myPushSupport = support;
        this.myRepository = repository;
        this.myGit = Git.getInstance();
        this.myProject = this.myRepository.getProject();
        this.myTargetRenderer = new VcsEditableTextComponent("", null);
        this.myTargetEditor = new PushTargetTextField(repository.getProject(), GitPushTargetPanel.getTargetNames(this.myRepository), "");
        this.myRemoteRenderer = new VcsLinkedTextComponent("", new VcsLinkListener(){

            public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                if (sourceNode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "git4idea/push/GitPushTargetPanel$1", "hyperlinkActivated"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/push/GitPushTargetPanel$1", "hyperlinkActivated"));
                }
                if (GitPushTargetPanel.this.myRepository.getRemotes().isEmpty()) {
                    GitPushTargetPanel.this.showDefineRemoteDialog();
                } else {
                    Component eventComponent = event.getComponent();
                    if (eventComponent != null) {
                        GitPushTargetPanel.this.showRemoteSelector(eventComponent, event.getPoint());
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel remoteAndSeparator = new JPanel(new BorderLayout());
        remoteAndSeparator.setOpaque(false);
        remoteAndSeparator.add((Component)this.myRemoteRenderer, "Center");
        remoteAndSeparator.add((Component)new JBLabel(SEPARATOR), "East");
        this.add(remoteAndSeparator, "West");
        this.add((Component)this.myTargetEditor, "Center");
        this.updateComponents(defaultTarget);
        this.setFocusCycleRoot(true);
        this.myRemoteRenderer.setFocusable(true);
        this.myTargetEditor.setFocusable(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyGitTargetFocusTraversalPolicy()));
        this.myRemoteRenderer.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.showRemoteSelector((Component)GitPushTargetPanel.this.myRemoteRenderer, new Point(GitPushTargetPanel.this.myRemoteRenderer.getLocation()));
                }
            }
        });
        this.myTargetEditor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
    }

    private void updateComponents(@Nullable GitPushTarget target) {
        this.myCurrentTarget = target;
        String initialBranch = "";
        String initialRemote = "";
        boolean noRemotes = this.myRepository.getRemotes().isEmpty();
        if (target == null) {
            if (this.myRepository.getCurrentBranch() == null) {
                this.myError = "Detached HEAD";
            } else if (this.myRepository.isFresh()) {
                this.myError = "Empty repository";
            } else if (!noRemotes) {
                this.myError = "Can't push";
            }
        } else {
            initialBranch = GitPushTargetPanel.getTextFieldText(target);
            initialRemote = target.getBranch().getRemote().getName();
        }
        this.myTargetRenderer.updateLinkText(initialBranch);
        this.myTargetEditor.setText(initialBranch);
        this.myRemoteRenderer.updateLinkText(noRemotes ? "Define remote" : initialRemote);
        this.myTargetEditor.setVisible(!noRemotes);
    }

    private void showDefineRemoteDialog() {
        GitDefineRemoteDialog dialog = new GitDefineRemoteDialog(this.myRepository, this.myGit);
        if (dialog.showAndGet()) {
            this.addRemoteUnderModal(dialog.getRemoteName(), dialog.getRemoteUrl());
        }
    }

    private void addRemoteUnderModal(final @NotNull String remoteName, final @NotNull String remoteUrl) {
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteName", "git4idea/push/GitPushTargetPanel", "addRemoteUnderModal"));
        }
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteUrl", "git4idea/push/GitPushTargetPanel", "addRemoteUnderModal"));
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myRepository.getProject(), "Adding Remote...", true){
            private GitCommandResult myResult;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/push/GitPushTargetPanel$3", "run"));
                }
                indicator.setIndeterminate(true);
                this.myResult = GitPushTargetPanel.this.myGit.addRemote(GitPushTargetPanel.this.myRepository, remoteName, remoteUrl);
                GitPushTargetPanel.this.myRepository.update();
            }

            public void onSuccess() {
                if (this.myResult.success()) {
                    GitPushTargetPanel.this.updateComponents(GitPushTargetPanel.this.myPushSupport.getDefaultTarget(GitPushTargetPanel.this.myRepository));
                    if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                        GitPushTargetPanel.this.myFireOnChangeAction.run();
                    }
                } else {
                    String message = "Couldn't add remote: " + this.myResult.getErrorOutputAsHtmlString();
                    LOG.warn(message);
                    Messages.showErrorDialog((Project)this.myProject, (String)message, (String)"Add Remote");
                }
            }
        });
    }

    private void showRemoteSelector(@NotNull Component component, @NotNull Point point) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "git4idea/push/GitPushTargetPanel", "showRemoteSelector"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "git4idea/push/GitPushTargetPanel", "showRemoteSelector"));
        }
        List<PopupItem> remotes = this.getPopupItems();
        if (remotes.size() <= 1) {
            return;
        }
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<PopupItem>(null, remotes){

            public PopupStep onChosen(@NotNull PopupItem selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedValue", "git4idea/push/GitPushTargetPanel$4", "onChosen"));
                }
                return this.doFinalStep(() -> {
                    if (selectedValue == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedValue", "git4idea/push/GitPushTargetPanel$4", "lambda$onChosen$0"));
                    }
                    if (selectedValue.isDefineRemote()) {
                        GitPushTargetPanel.this.showDefineRemoteDialog();
                    } else {
                        GitPushTargetPanel.this.myRemoteRenderer.updateLinkText(selectedValue.getPresentable());
                        if (GitPushTargetPanel.this.myFireOnChangeAction != null && !GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                            GitPushTargetPanel.this.myFireOnChangeAction.run();
                        }
                    }
                });
            }

            @Nullable
            public ListSeparator getSeparatorAbove(PopupItem value) {
                return value.isDefineRemote() ? new ListSeparator() : null;
            }
        }){

            public void cancel(InputEvent e) {
                super.cancel(e);
                if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.repaint();
                    IdeFocusManager.getInstance((Project)GitPushTargetPanel.this.myProject).requestFocus((Component)GitPushTargetPanel.this.myTargetEditor, true);
                }
            }
        };
        popup.show(new RelativePoint(component, point));
    }

    @NotNull
    private List<PopupItem> getPopupItems() {
        ArrayList items = ContainerUtil.newArrayList((Iterable)ContainerUtil.map(this.myRepository.getRemotes(), PopupItem::forRemote));
        items.add(PopupItem.DEFINE_REMOTE);
        ArrayList arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getPopupItems"));
        }
        return arrayList;
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer, boolean isSelected, boolean isActive, @Nullable String forceRenderedText) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "git4idea/push/GitPushTargetPanel", "render"));
        }
        SimpleTextAttributes targetTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)isActive);
        if (this.myError != null) {
            renderer.append(this.myError, PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.ERROR_ATTRIBUTES, (boolean)isActive));
        } else {
            Collection<GitRemote> remotes = this.myRepository.getRemotes();
            this.myRemoteRenderer.setSelected(isSelected);
            this.myRemoteRenderer.setTransparent(!remotes.isEmpty() && !isActive);
            this.myRemoteRenderer.render(renderer);
            if (!remotes.isEmpty()) {
                renderer.append(SEPARATOR, targetTextAttributes);
                if (forceRenderedText != null) {
                    renderer.append(forceRenderedText);
                    return;
                }
                GitPushTarget target = this.getValue();
                boolean newRemoteBranch = target != null && target.isNewBranchCreated();
                this.myTargetRenderer.setSelected(isSelected);
                this.myTargetRenderer.setTransparent(!isActive);
                this.myTargetRenderer.render(renderer);
                if (newRemoteBranch) {
                    renderer.setIconOnTheRight(true);
                    NEW_BRANCH_LABEL.setInsets((Insets)JBUI.insets((int)2));
                    NEW_BRANCH_LABEL.setRound(JBUI.scale((int)4));
                    NEW_BRANCH_LABEL.setFont(NEW_BRANCH_LABEL_FONT.derive(renderer.getFont()));
                    renderer.setIcon((Icon)NEW_BRANCH_LABEL);
                }
            }
        }
    }

    @Nullable
    public GitPushTarget getValue() {
        return this.myCurrentTarget;
    }

    @NotNull
    private static String getTextFieldText(@Nullable GitPushTarget target) {
        String string = target != null ? target.getBranch().getNameForRemoteOperations() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getTextFieldText"));
        }
        return string;
    }

    public void fireOnCancel() {
        this.myTargetEditor.setText(GitPushTargetPanel.getTextFieldText(this.myCurrentTarget));
    }

    public void fireOnChange() {
        if (this.myError != null || this.myRepository.getRemotes().isEmpty()) {
            return;
        }
        String remoteName = this.myRemoteRenderer.getText();
        String branchName = this.myTargetEditor.getText();
        try {
            this.myCurrentTarget = GitPushTarget.parse(this.myRepository, remoteName, branchName);
            this.myTargetRenderer.updateLinkText(branchName);
        }
        catch (ParseException e) {
            LOG.error("Invalid remote name shouldn't be allowed. [" + remoteName + ", " + branchName + "]", (Throwable)e);
        }
    }

    @Nullable
    public ValidationInfo verify() {
        if (this.myError != null) {
            return new ValidationInfo(this.myError, (JComponent)this.myTargetEditor);
        }
        try {
            GitPushTarget.parse(this.myRepository, this.myRemoteRenderer.getText(), this.myTargetEditor.getText());
            return null;
        }
        catch (ParseException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myTargetEditor);
        }
    }

    public void setFireOnChangeAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "git4idea/push/GitPushTargetPanel", "setFireOnChangeAction"));
        }
        this.myFireOnChangeAction = action;
    }

    @NotNull
    private static List<String> getTargetNames(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushTargetPanel", "getTargetNames"));
        }
        List<String> list = repository.getBranches().getRemoteBranches().stream().sorted(REMOTE_BRANCH_COMPARATOR).map(GitRemoteBranch::getNameForRemoteOperations).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getTargetNames"));
        }
        return list;
    }

    public void addTargetEditorListener(final @NotNull PushTargetEditorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "git4idea/push/GitPushTargetPanel", "addTargetEditorListener"));
        }
        this.myTargetEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                GitPushTargetPanel.this.processActiveUserChanges(listener);
            }
        });
        this.myTargetEditor.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GitPushTargetPanel.this.processActiveUserChanges(listener);
            }
        });
        this.myTargetEditor.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    GitPushTargetPanel.this.myTargetEditor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)(!GitPushTargetPanel.this.myTargetEditor.isShowing() ? 1 : 0));
                }
            }
        });
    }

    private void processActiveUserChanges(@NotNull PushTargetEditorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "git4idea/push/GitPushTargetPanel", "processActiveUserChanges"));
        }
        if (this.myTargetEditor.isShowing()) {
            listener.onTargetInEditModeChanged(this.myTargetEditor.getText());
        }
    }

    public void forceUpdateEditableUiModel(@NotNull String forcedText) {
        if (forcedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forcedText", "git4idea/push/GitPushTargetPanel", "forceUpdateEditableUiModel"));
        }
        if (!this.myTargetEditor.isShowing()) {
            this.myTargetEditor.setText(forcedText);
        }
    }

    private class MyGitTargetFocusTraversalPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyGitTargetFocusTraversalPolicy() {
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new Component[]{GitPushTargetPanel.this.myTargetEditor.getFocusTarget(), GitPushTargetPanel.this.myRemoteRenderer});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel$MyGitTargetFocusTraversalPolicy", "getOrderedComponents"));
            }
            return arrayList;
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (GitPushTargetPanel.this.getPopupItems().size() > 1) {
                return super.getComponentAfter(aContainer, aComponent);
            }
            return aComponent;
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (GitPushTargetPanel.this.getPopupItems().size() > 1) {
                return super.getComponentBefore(aContainer, aComponent);
            }
            return aComponent;
        }
    }

    private static class PopupItem {
        static final PopupItem DEFINE_REMOTE = new PopupItem(null);
        @Nullable
        GitRemote remote;

        @NotNull
        static PopupItem forRemote(@NotNull GitRemote remote) {
            if (remote == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/push/GitPushTargetPanel$PopupItem", "forRemote"));
            }
            PopupItem popupItem = new PopupItem(remote);
            if (popupItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel$PopupItem", "forRemote"));
            }
            return popupItem;
        }

        private PopupItem(@Nullable GitRemote remote) {
            this.remote = remote;
        }

        @NotNull
        String getPresentable() {
            String string = this.remote == null ? "Define Remote" : this.remote.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel$PopupItem", "getPresentable"));
            }
            return string;
        }

        boolean isDefineRemote() {
            return this.remote == null;
        }

        public String toString() {
            return this.getPresentable();
        }
    }

    private static class MyRemoteBranchComparator
    implements Comparator<GitRemoteBranch> {
        private MyRemoteBranchComparator() {
        }

        @Override
        public int compare(@NotNull GitRemoteBranch o1, @NotNull GitRemoteBranch o2) {
            String remoteName2;
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "git4idea/push/GitPushTargetPanel$MyRemoteBranchComparator", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "git4idea/push/GitPushTargetPanel$MyRemoteBranchComparator", "compare"));
            }
            String remoteName1 = o1.getRemote().getName();
            int remoteComparison = remoteName1.compareTo(remoteName2 = o2.getRemote().getName());
            if (remoteComparison != 0) {
                if (remoteName1.equals("origin")) {
                    return -1;
                }
                if (remoteName2.equals("origin")) {
                    return 1;
                }
                return remoteComparison;
            }
            return o1.getNameForLocalOperations().compareTo(o2.getNameForLocalOperations());
        }
    }
}

