/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.concurrency.JobScheduler;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.io.FilenameFilter;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.auth.SvnInteractiveAuthenticationProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoClient;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnAuthenticationNotifier
extends GenericNotifierImpl<AuthenticationRequest, SVNURL> {
    private static final Logger LOG = Logger.getInstance(SvnAuthenticationNotifier.class);
    private static final List<String> ourAuthKinds = Arrays.asList("svn.simple", "svn.ssh", "svn.ssl.client-passphrase", "svn.username", "svn.ssl.server", "svn.ssh.server");
    private final SvnVcs myVcs;
    private final RootsToWorkingCopies myRootsToWorkingCopies;
    private final Map<SVNURL, Boolean> myCopiesPassiveResults;
    private ScheduledFuture<?> myTimer;
    private volatile boolean myVerificationInProgress;

    public SvnAuthenticationNotifier(SvnVcs svnVcs) {
        super(svnVcs.getProject(), svnVcs.getDisplayName(), "Not Logged In to Subversion", NotificationType.ERROR);
        this.myVcs = svnVcs;
        this.myRootsToWorkingCopies = this.myVcs.getRootsToWorkingCopies();
        this.myCopiesPassiveResults = Collections.synchronizedMap(new HashMap());
        this.myVerificationInProgress = false;
    }

    public void init() {
        if (this.myTimer != null) {
            this.stop();
        }
        this.myTimer = JobScheduler.getScheduler().scheduleWithFixedDelay(this.myCopiesPassiveResults::clear, 10L, 600L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.myTimer.cancel(false);
        this.myTimer = null;
    }

    protected boolean ask(final AuthenticationRequest obj, String description) {
        if (this.myVerificationInProgress) {
            return this.showAlreadyChecking();
        }
        this.myVerificationInProgress = true;
        final Ref resultRef = new Ref();
        Runnable checker = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean result = SvnAuthenticationNotifier.interactiveValidation(obj.myProject, obj.getUrl(), obj.getRealm(), obj.getKind());
                    SvnAuthenticationNotifier.log("ask result for: " + obj.getUrl() + " is: " + result);
                    resultRef.set((Object)result);
                    if (result) {
                        SvnAuthenticationNotifier.this.onStateChangedToSuccess(obj);
                    }
                }
                finally {
                    SvnAuthenticationNotifier.this.myVerificationInProgress = false;
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (!application.isReadAccessAllowed() && ProgressManager.getInstance().hasProgressIndicator()) {
            checker.run();
            return (Boolean)resultRef.get();
        }
        application.executeOnPooledThread(checker);
        return false;
    }

    private boolean showAlreadyChecking() {
        IdeFrame frameFor = WindowManagerEx.getInstanceEx().findFrameFor(this.myProject);
        if (frameFor != null) {
            JComponent component = frameFor.getComponent();
            Point point = component.getMousePosition();
            if (point == null) {
                point = new Point((int)((double)component.getWidth() * 0.7), 0);
            }
            SwingUtilities.convertPointToScreen(point, component);
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("Already checking...", MessageType.WARNING, null).createBalloon().show(new RelativePoint(point), Balloon.Position.below);
        }
        return false;
    }

    private void onStateChangedToSuccess(AuthenticationRequest obj) {
        this.myCopiesPassiveResults.put(this.getKey(obj), true);
        this.myVcs.invokeRefreshSvnRoots();
        final LinkedList<SVNURL> outdatedRequests = new LinkedList<SVNURL>();
        Collection keys = this.getAllCurrentKeys();
        for (SVNURL key : keys) {
            SVNURL commonURLAncestor = SVNURLUtil.getCommonURLAncestor((SVNURL)key, (SVNURL)obj.getUrl());
            if (commonURLAncestor == null || StringUtil.isEmptyOrSpaces((String)commonURLAncestor.getHost()) || StringUtil.isEmptyOrSpaces((String)commonURLAncestor.getPath())) continue;
            outdatedRequests.add(key);
        }
        SvnAuthenticationNotifier.log("on state changed ");
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                for (SVNURL key : outdatedRequests) {
                    SvnAuthenticationNotifier.this.removeLazyNotificationByKey(key);
                }
            }
        }, ModalityState.NON_MODAL);
    }

    public boolean ensureNotify(AuthenticationRequest obj) {
        SVNURL key = this.getKey(obj);
        this.myCopiesPassiveResults.remove(key);
        return super.ensureNotify((Object)obj);
    }

    protected boolean onFirstNotification(AuthenticationRequest obj) {
        if (ProgressManager.getInstance().hasProgressIndicator()) {
            return this.ask(obj, null);
        }
        return false;
    }

    @NotNull
    public SVNURL getKey(AuthenticationRequest obj) {
        SVNURL sVNURL = obj.getWcUrl();
        if (sVNURL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier", "getKey"));
        }
        return sVNURL;
    }

    @Nullable
    public SVNURL getWcUrl(AuthenticationRequest obj) {
        if (obj.isOutsideCopies()) {
            return null;
        }
        if (obj.getWcUrl() != null) {
            return obj.getWcUrl();
        }
        WorkingCopy copy = this.myRootsToWorkingCopies.getMatchingCopy(obj.getUrl());
        if (copy != null) {
            obj.setOutsideCopies(false);
            obj.setWcUrl(copy.getUrl());
        } else {
            obj.setOutsideCopies(true);
        }
        return copy == null ? null : copy.getUrl();
    }

    public ThreeState isAuthenticatedFor(@NotNull VirtualFile vf, @Nullable ClientFactory factory) {
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier", "isAuthenticatedFor"));
        }
        WorkingCopy wcCopy = this.myRootsToWorkingCopies.getWcRoot(vf);
        if (wcCopy == null) {
            return ThreeState.UNSURE;
        }
        boolean haveCancellation = this.getStateFor(wcCopy.getUrl());
        if (haveCancellation) {
            return ThreeState.NO;
        }
        Boolean keptResult = this.myCopiesPassiveResults.get(wcCopy.getUrl());
        if (Boolean.TRUE.equals(keptResult)) {
            return ThreeState.YES;
        }
        if (Boolean.FALSE.equals(keptResult)) {
            return ThreeState.NO;
        }
        boolean calculatedResult = factory == null ? SvnAuthenticationNotifier.passiveValidation(this.myVcs.getProject(), wcCopy.getUrl()) : SvnAuthenticationNotifier.passiveValidation(factory, wcCopy.getUrl());
        this.myCopiesPassiveResults.put(wcCopy.getUrl(), calculatedResult);
        return calculatedResult ? ThreeState.YES : ThreeState.NO;
    }

    private static boolean passiveValidation(@NotNull ClientFactory factory, @NotNull SVNURL url) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier", "passiveValidation"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier", "passiveValidation"));
        }
        Info info = null;
        try {
            info = factory.create(InfoClient.class, false).doInfo(SvnTarget.fromURL((SVNURL)url), SVNRevision.UNDEFINED);
        }
        catch (SvnBindException svnBindException) {
            // empty catch block
        }
        return info != null;
    }

    @NotNull
    protected String getNotificationContent(AuthenticationRequest obj) {
        String string = "<a href=\"\">Click to fix.</a> Not logged In to Subversion '" + obj.getRealm() + "' (" + obj.getUrl().toDecodedString() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier", "getNotificationContent"));
        }
        return string;
    }

    static void log(Throwable t) {
        LOG.debug(t);
    }

    static void log(String s) {
        LOG.debug(s);
    }

    public static boolean passiveValidation(Project project, SVNURL url) {
        SvnConfiguration configuration = SvnConfiguration.getInstance(project);
        SvnAuthenticationManager passiveManager = configuration.getPassiveAuthenticationManager(project);
        return SvnAuthenticationNotifier.validationImpl(project, url, configuration, passiveManager, false, null, null, false);
    }

    public static boolean interactiveValidation(Project project, SVNURL url, String realm, String kind) {
        SvnConfiguration configuration = SvnConfiguration.getInstance(project);
        SvnAuthenticationManager passiveManager = configuration.getInteractiveManager(SvnVcs.getInstance(project));
        return SvnAuthenticationNotifier.validationImpl(project, url, configuration, passiveManager, true, realm, kind, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validationImpl(Project project, SVNURL url, SvnConfiguration configuration, SvnAuthenticationManager manager, boolean checkWrite, String realm, String kind, boolean interactive) {
        Proxy proxyToRelease = null;
        if (!interactive && configuration.isIsUseDefaultProxy()) {
            HttpConfigurable instance = HttpConfigurable.getInstance();
            if (instance.USE_HTTP_PROXY && instance.PROXY_AUTHENTICATION && (StringUtil.isEmptyOrSpaces((String)instance.getProxyLogin()) || StringUtil.isEmptyOrSpaces((String)instance.getPlainProxyPassword()))) {
                return false;
            }
            if (instance.USE_PROXY_PAC) {
                List select;
                try {
                    select = CommonProxy.getInstance().select(new URI(url.toString()));
                }
                catch (URISyntaxException e) {
                    LOG.info("wrong URL: " + url.toString());
                    return false;
                }
                if (select != null && !select.isEmpty()) {
                    for (Proxy proxy : select) {
                        if (!HttpConfigurable.isRealProxy((Proxy)proxy) || !Proxy.Type.HTTP.equals((Object)proxy.type())) continue;
                        InetSocketAddress address = (InetSocketAddress)proxy.address();
                        PasswordAuthentication password = HttpConfigurable.getInstance().getGenericPassword(address.getHostName(), address.getPort());
                        if (password != null) continue;
                        CommonProxy.getInstance().noAuthentication("http", address.getHostName(), address.getPort());
                        proxyToRelease = proxy;
                    }
                }
            }
        }
        SvnInteractiveAuthenticationProvider.clearCallState();
        try {
            SvnVcs.getInstance(project).getSvnKitManager().createWCClient((ISVNAuthenticationManager)manager).doInfo(url, SVNRevision.UNDEFINED, SVNRevision.HEAD);
        }
        catch (SVNAuthenticationException | SVNCancelException e) {
            SvnAuthenticationNotifier.log(e);
            boolean select = false;
            return select;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode().isAuthentication()) {
                SvnAuthenticationNotifier.log(e);
                boolean select = false;
                return select;
            }
            LOG.info("some other exc", (Throwable)e);
            if (interactive) {
                SvnAuthenticationNotifier.showAuthenticationFailedWithHotFixes(project, configuration, e);
            }
            boolean select = false;
            return select;
        }
        finally {
            if (!interactive && configuration.isIsUseDefaultProxy() && proxyToRelease != null) {
                InetSocketAddress address = (InetSocketAddress)proxyToRelease.address();
                CommonProxy.getInstance().noAuthentication("http", address.getHostName(), address.getPort());
            }
        }
        if (!checkWrite) {
            return true;
        }
        if (SvnInteractiveAuthenticationProvider.wasCalled() && SvnInteractiveAuthenticationProvider.wasCancelled()) {
            return false;
        }
        if (SvnInteractiveAuthenticationProvider.wasCalled()) {
            return true;
        }
        SvnVcs svnVcs = SvnVcs.getInstance(project);
        SvnInteractiveAuthenticationProvider provider = new SvnInteractiveAuthenticationProvider(svnVcs, manager);
        SVNAuthentication svnAuthentication = provider.requestClientAuthentication(kind, url, realm, null, null, true);
        if (svnAuthentication != null) {
            configuration.acknowledge(kind, realm, svnAuthentication);
            try {
                configuration.getAuthenticationManager(svnVcs).acknowledgeAuthentication(true, kind, realm, null, svnAuthentication);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
            }
            return true;
        }
        return false;
    }

    private static void showAuthenticationFailedWithHotFixes(final Project project, final SvnConfiguration configuration, final SVNException e) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)("Authentication failed: " + e.getMessage()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[]{new NamedRunnable(SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0])){

                    public void run() {
                        SvnAuthenticationNotifier.clearAuthenticationCache(project, null, configuration.getConfigurationDirectory());
                    }
                }, new NamedRunnable(SvnBundle.message("action.title.select.configuration.directory", new Object[0])){

                    public void run() {
                        SvnConfigurable.selectConfigurationDirectory(configuration.getConfigurationDirectory(), new Consumer<String>(){

                            public void consume(String s) {
                                configuration.setConfigurationDirParameters(false, s);
                            }
                        }, project, null);
                    }
                }});
            }
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    public static void clearAuthenticationCache(@NotNull Project project, Component component, String configDirPath) {
        int result;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier", "clearAuthenticationCache"));
        }
        if (configDirPath != null && (result = component == null ? Messages.showYesNoDialog((Project)project, (String)SvnBundle.message("confirmation.text.delete.stored.authentication.information", new Object[0]), (String)SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0]), (Icon)Messages.getWarningIcon()) : Messages.showYesNoDialog((Component)component, (String)SvnBundle.message("confirmation.text.delete.stored.authentication.information", new Object[0]), (String)SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0]), (Icon)Messages.getWarningIcon())) == 0) {
            SvnConfiguration.RUNTIME_AUTH_CACHE.clear();
            SvnAuthenticationNotifier.clearAuthenticationDirectory(SvnConfiguration.getInstance(project));
        }
    }

    public static void clearAuthenticationDirectory(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier", "clearAuthenticationDirectory"));
        }
        final File authDir = new File(configuration.getConfigurationDirectory(), "auth");
        if (authDir.exists()) {
            Runnable process = new Runnable(){

                @Override
                public void run() {
                    File[] files;
                    ProgressIndicator ind = ProgressManager.getInstance().getProgressIndicator();
                    if (ind != null) {
                        ind.setIndeterminate(true);
                        ind.setText("Clearing stored credentials in " + authDir.getAbsolutePath());
                    }
                    for (File dir : files = authDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(@NotNull File dir, @NotNull String name) {
                            if (dir == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier$4$1", "accept"));
                            }
                            if (name == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/auth/SvnAuthenticationNotifier$4$1", "accept"));
                            }
                            return ourAuthKinds.contains(name);
                        }
                    })) {
                        if (ind != null) {
                            ind.setText("Deleting " + dir.getAbsolutePath());
                        }
                        FileUtil.delete((File)dir);
                    }
                }
            };
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode() || !application.isDispatchThread()) {
                process.run();
            } else {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(process, "button.text.clear.authentication.cache", false, configuration.getProject());
            }
        }
    }

    public static class AuthenticationRequest {
        private final Project myProject;
        private final String myKind;
        private final SVNURL myUrl;
        private final String myRealm;
        private SVNURL myWcUrl;
        private boolean myOutsideCopies;
        private boolean myForceSaving;

        public AuthenticationRequest(Project project, String kind, SVNURL url, String realm) {
            this.myProject = project;
            this.myKind = kind;
            this.myUrl = url;
            this.myRealm = realm;
        }

        public boolean isForceSaving() {
            return this.myForceSaving;
        }

        public void setForceSaving(boolean forceSaving) {
            this.myForceSaving = forceSaving;
        }

        public boolean isOutsideCopies() {
            return this.myOutsideCopies;
        }

        public void setOutsideCopies(boolean outsideCopies) {
            this.myOutsideCopies = outsideCopies;
        }

        public SVNURL getWcUrl() {
            return this.myWcUrl;
        }

        public void setWcUrl(SVNURL wcUrl) {
            this.myWcUrl = wcUrl;
        }

        public String getKind() {
            return this.myKind;
        }

        public SVNURL getUrl() {
            return this.myUrl;
        }

        public String getRealm() {
            return this.myRealm;
        }
    }
}

