/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HighlightData {
    private final int myStartOffset;
    private int myEndOffset;
    private final TextAttributesKey myHighlightType;

    public HighlightData(int startOffset, TextAttributesKey highlightType) {
        this.myStartOffset = startOffset;
        this.myHighlightType = highlightType;
    }

    public HighlightData(int startOffset, int endOffset, TextAttributesKey highlightType) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myHighlightType = highlightType;
    }

    public void addToCollection(@NotNull Collection<HighlightData> list, boolean highlighted) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/colors/highlighting/HighlightData", "addToCollection"));
        }
        list.add(this);
        if (highlighted) {
            list.add(new HighlightData(this.getStartOffset(), this.getEndOffset(), CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES));
        }
    }

    public void addHighlToView(Editor view, EditorColorsScheme scheme2, Map<TextAttributesKey, String> displayText) {
        if (HighlighterColors.BAD_CHARACTER.equals((Object)this.myHighlightType)) {
            return;
        }
        TextAttributes attr = scheme2.getAttributes(this.myHighlightType);
        if (attr != null) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                try {
                    view.getMarkupModel().addRangeHighlighter(this.myStartOffset, this.myEndOffset, 3000, TextAttributes.ERASE_MARKER, HighlighterTargetArea.EXACT_RANGE);
                    RangeHighlighter highlighter = view.getMarkupModel().addRangeHighlighter(this.myStartOffset, this.myEndOffset, 3000, attr, HighlighterTargetArea.EXACT_RANGE);
                    Color errorStripeColor = attr.getErrorStripeColor();
                    highlighter.setErrorStripeMarkColor(errorStripeColor);
                    String tooltip = (String)displayText.get(this.myHighlightType);
                    highlighter.setErrorStripeTooltip((Object)tooltip);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public void setEndOffset(int endOffset) {
        this.myEndOffset = endOffset;
    }

    public String getHighlightType() {
        return this.myHighlightType.getExternalName();
    }

    public TextAttributesKey getHighlightKey() {
        return this.myHighlightType;
    }
}

