/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporterEP;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemeActions<T extends Scheme> {
    private final Collection<String> mySchemeImportersNames;
    private final Collection<String> mySchemeExporterNames;
    private final AbstractSchemesPanel<T> mySchemesPanel;

    protected AbstractSchemeActions(@NotNull AbstractSchemesPanel<T> schemesPanel) {
        if (schemesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesPanel", "com/intellij/application/options/schemes/AbstractSchemeActions", "<init>"));
        }
        this.mySchemesPanel = schemesPanel;
        this.mySchemeImportersNames = this.getSchemeImportersNames();
        this.mySchemeExporterNames = this.getSchemeExporterNames();
    }

    protected Collection<String> getSchemeImportersNames() {
        ArrayList<String> importersNames = new ArrayList<String>();
        for (SchemeImporterEP<T> importerEP : SchemeImporterEP.getExtensions(this.getSchemeType())) {
            importersNames.add(importerEP.name);
        }
        return importersNames;
    }

    private Collection<String> getSchemeExporterNames() {
        ArrayList<String> exporterNames = new ArrayList<String>();
        for (SchemeExporterEP<T> exporterEP : SchemeExporterEP.getExtensions(this.getSchemeType())) {
            exporterNames.add(exporterEP.name);
        }
        return exporterNames;
    }

    public final Collection<AnAction> getActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.mySchemesPanel.supportsProjectSchemes()) {
            actions.add((AnAction)new CopyToProjectAction());
            actions.add((AnAction)new CopyToIDEAction());
            actions.add((AnAction)new Separator());
        }
        actions.add((AnAction)new CopyAction());
        actions.add((AnAction)new RenameAction());
        actions.add((AnAction)new ResetAction());
        actions.add((AnAction)new DeleteAction());
        if (!this.mySchemeExporterNames.isEmpty()) {
            actions.add((AnAction)new ActionGroupPopupAction(ApplicationBundle.message((String)"settings.editor.scheme.export", (Object[])new Object[0]), (Collection)this.mySchemeExporterNames){

                @Override
                @NotNull
                protected AnAction createAction(@NotNull String actionName) {
                    if (actionName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/application/options/schemes/AbstractSchemeActions$1", "createAction"));
                    }
                    ExportAction exportAction = new ExportAction(actionName);
                    if (exportAction == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/AbstractSchemeActions$1", "createAction"));
                    }
                    return exportAction;
                }
            });
        }
        actions.add((AnAction)new Separator());
        if (!this.mySchemeImportersNames.isEmpty()) {
            actions.add((AnAction)new ActionGroupPopupAction(ApplicationBundle.message((String)"settings.editor.scheme.import", (Object[])new Object[0]), (Collection)this.mySchemeImportersNames){

                @Override
                @NotNull
                protected AnAction createAction(@NotNull String actionName) {
                    if (actionName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/application/options/schemes/AbstractSchemeActions$2", "createAction"));
                    }
                    ImportAction importAction = new ImportAction(actionName);
                    if (importAction == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/AbstractSchemeActions$2", "createAction"));
                    }
                    return importAction;
                }
            });
        }
        this.addAdditionalActions(actions);
        return actions;
    }

    protected void addAdditionalActions(@NotNull List<AnAction> defaultActions) {
        if (defaultActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultActions", "com/intellij/application/options/schemes/AbstractSchemeActions", "addAdditionalActions"));
        }
    }

    protected abstract void importScheme(@NotNull String var1);

    protected abstract void resetScheme(@NotNull T var1);

    protected abstract void duplicateScheme(@NotNull T var1, @NotNull String var2);

    protected abstract void deleteScheme(@NotNull T var1);

    protected abstract void exportScheme(@NotNull T var1, @NotNull String var2);

    protected abstract void onSchemeChanged(@Nullable T var1);

    protected abstract void renameScheme(@NotNull T var1, @NotNull String var2);

    protected void copyToProject(@NotNull T scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/schemes/AbstractSchemeActions", "copyToProject"));
        }
    }

    protected void copyToIDE(@NotNull T scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/schemes/AbstractSchemeActions", "copyToIDE"));
        }
    }

    @NotNull
    protected SchemesModel<T> getModel() {
        SchemesModel<T> schemesModel = this.mySchemesPanel.getModel();
        if (schemesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/AbstractSchemeActions", "getModel"));
        }
        return schemesModel;
    }

    @Nullable
    protected final T getCurrentScheme() {
        return this.mySchemesPanel.getSelectedScheme();
    }

    protected abstract Class<T> getSchemeType();

    public final AbstractSchemesPanel<T> getSchemesPanel() {
        return this.mySchemesPanel;
    }

    private class ExportAction
    extends DumbAwareAction {
        private String myExporterName;

        public ExportAction(String exporterName) {
            if (exporterName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exporterName", "com/intellij/application/options/schemes/AbstractSchemeActions$ExportAction", "<init>"));
            }
            super(exporterName);
            this.myExporterName = exporterName;
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.exportScheme(currentScheme, this.myExporterName);
            }
        }
    }

    private class ImportAction
    extends DumbAwareAction {
        private String myImporterName;

        public ImportAction(String importerName) {
            if (importerName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importerName", "com/intellij/application/options/schemes/AbstractSchemeActions$ImportAction", "<init>"));
            }
            super(importerName);
            this.myImporterName = importerName;
        }

        public void actionPerformed(AnActionEvent e) {
            AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
            AbstractSchemeActions.this.importScheme(this.myImporterName);
        }
    }

    private abstract class ActionGroupPopupAction
    extends DumbAwareAction {
        private final Collection<String> myActionNames;

        public ActionGroupPopupAction(@NotNull String groupName, Collection<String> actionNames) {
            if (groupName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/intellij/application/options/schemes/AbstractSchemeActions$ActionGroupPopupAction", "<init>"));
            }
            if (actionNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionNames", "com/intellij/application/options/schemes/AbstractSchemeActions$ActionGroupPopupAction", "<init>"));
            }
            super(groupName);
            this.myActionNames = actionNames;
        }

        public void actionPerformed(AnActionEvent e) {
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(this.getTemplatePresentation().getText(), new ActionGroup(){

                @NotNull
                public AnAction[] getChildren(@Nullable AnActionEvent e) {
                    ArrayList<AnAction> namedActions = new ArrayList<AnAction>();
                    for (String actionName : ActionGroupPopupAction.this.myActionNames) {
                        namedActions.add(ActionGroupPopupAction.this.createAction(actionName));
                    }
                    AnAction[] anActionArray = namedActions.toArray(new AnAction[namedActions.size()]);
                    if (anActionArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/AbstractSchemeActions$ActionGroupPopupAction$1", "getChildren"));
                    }
                    return anActionArray;
                }
            }, e.getDataContext(), null, true);
            listPopup.showUnderneathOf((Component)AbstractSchemeActions.this.mySchemesPanel.getToolbar());
        }

        @NotNull
        protected abstract AnAction createAction(@NotNull String var1);
    }

    private class DeleteAction
    extends DumbAwareAction {
        public DeleteAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.delete", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.deleteScheme(currentScheme);
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDeleteScheme(scheme2));
        }
    }

    private class RenameAction
    extends DumbAwareAction {
        public RenameAction() {
            super("Rename...");
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.startEdit();
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canRenameScheme(scheme2));
        }
    }

    private class CopyAction
    extends DumbAwareAction {
        public CopyAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.duplicateScheme(currentScheme, SchemeNameGenerator.getUniqueName(SchemeManager.getDisplayName(currentScheme), name -> AbstractSchemeActions.this.mySchemesPanel.getModel().containsScheme((String)name)));
                currentScheme = AbstractSchemeActions.this.getCurrentScheme();
                if (currentScheme != null) {
                    AbstractSchemeActions.this.mySchemesPanel.startEdit();
                }
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDuplicateScheme(scheme2));
        }
    }

    private class ResetAction
    extends DumbAwareAction {
        public ResetAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.reset", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.resetScheme(currentScheme);
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            if (scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canResetScheme(scheme2)) {
                p.setVisible(true);
                p.setEnabled(AbstractSchemeActions.this.mySchemesPanel.getModel().differsFromDefault(scheme2));
            } else {
                p.setEnabledAndVisible(false);
            }
        }
    }

    private class CopyToIDEAction
    extends DumbAwareAction {
        public CopyToIDEAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy.to.ide", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToIDE(currentScheme);
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }
    }

    private class CopyToProjectAction
    extends DumbAwareAction {
        public CopyToProjectAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy.to.project", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToProject(currentScheme);
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }
    }
}

