/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.MessageType;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemesPanel<T extends Scheme>
extends JPanel {
    private SchemesCombo<T> mySchemesCombo;
    private AbstractSchemeActions<T> myActions;
    private JComponent myToolbar;
    private JLabel myInfoLabel;

    public AbstractSchemesPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.createUIComponents();
    }

    private void createUIComponents() {
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new BoxLayout(controlsPanel, 2));
        controlsPanel.add(new JLabel(ApplicationBundle.message((String)"editbox.scheme.name", (Object[])new Object[0])));
        controlsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.myActions = this.createSchemeActions();
        this.mySchemesCombo = new SchemesCombo(this);
        controlsPanel.add(this.mySchemesCombo.getComponent());
        this.myToolbar = this.createToolbar();
        controlsPanel.add(this.myToolbar);
        this.myInfoLabel = new JLabel();
        controlsPanel.add(this.myInfoLabel);
        controlsPanel.add(Box.createHorizontalGlue());
        controlsPanel.setMaximumSize(new Dimension(controlsPanel.getMaximumSize().width, this.mySchemesCombo.getComponent().getPreferredSize().height));
        this.add(controlsPanel);
        this.add(Box.createVerticalGlue());
        this.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    private JComponent createToolbar() {
        DefaultActionGroup toolbarActionGroup = new DefaultActionGroup();
        toolbarActionGroup.add((AnAction)new TopActionGroup());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)toolbarActionGroup, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setMaximumSize(new Dimension(toolbarComponent.getPreferredSize().width, Short.MAX_VALUE));
        return toolbarComponent;
    }

    public final JComponent getToolbar() {
        return this.myToolbar;
    }

    protected abstract AbstractSchemeActions<T> createSchemeActions();

    public final T getSelectedScheme() {
        return this.mySchemesCombo.getSelectedScheme();
    }

    public final void selectScheme(@Nullable T scheme2) {
        this.mySchemesCombo.selectScheme(scheme2);
    }

    public final void resetSchemes(@NotNull Collection<T> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/application/options/schemes/AbstractSchemesPanel", "resetSchemes"));
        }
        this.mySchemesCombo.resetSchemes(schemes);
    }

    public void disposeUIResources() {
        this.removeAll();
    }

    public final void startEdit() {
        this.mySchemesCombo.startEdit();
    }

    public final void cancelEdit() {
        this.mySchemesCombo.cancelEdit();
    }

    public final void showInfo(@Nullable String message, @NotNull MessageType messageType) {
        if (messageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageType", "com/intellij/application/options/schemes/AbstractSchemesPanel", "showInfo"));
        }
        this.myInfoLabel.setText(message);
        this.myInfoLabel.setForeground(messageType.getTitleForeground());
    }

    public final void clearInfo() {
        this.myInfoLabel.setText(null);
    }

    public final AbstractSchemeActions<T> getActions() {
        return this.myActions;
    }

    @NotNull
    public abstract SchemesModel<T> getModel();

    public final void updateOnCurrentSettingsChange() {
        this.mySchemesCombo.updateSelected();
    }

    public abstract boolean supportsProjectSchemes();

    private class TopActionGroup
    extends ActionGroup
    implements DumbAware {
        public TopActionGroup() {
            super("", true);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Collection<AnAction> actions = AbstractSchemesPanel.this.myActions.getActions();
            AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/AbstractSchemesPanel$TopActionGroup", "getChildren"));
            }
            return anActionArray;
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            p.setIcon(AllIcons.General.GearPlain);
        }
    }
}

