/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.function.Predicate;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemesCombo<T extends Scheme> {
    public static final String PROJECT_LEVEL = "Project";
    public static final String IDE_LEVEL = "IDE";
    public static final String EMPTY_NAME_MESSAGE = "The name must not be empty";
    public static final String NAME_ALREADY_EXISTS_MESSAGE = "The name already exists";
    private ComboBox<MySchemeListItem<T>> myComboBox;
    private JPanel myRootPanel;
    private AbstractSchemesPanel<T> mySchemesPanel;
    private final CardLayout myLayout;
    private final JTextField myNameEditorField;
    private final MyComboBoxModel myComboBoxModel;
    private static final KeyStroke ESC_KEY_STROKE = KeyStroke.getKeyStroke(27, 0, false);
    private static final KeyStroke ENTER_KEY_STROKE = KeyStroke.getKeyStroke(10, 0, false);

    public SchemesCombo(@NotNull AbstractSchemesPanel<T> schemesPanel) {
        if (schemesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesPanel", "com/intellij/application/options/schemes/SchemesCombo", "<init>"));
        }
        this.mySchemesPanel = schemesPanel;
        this.myLayout = new CardLayout();
        this.myRootPanel = new JPanel(this.myLayout);
        this.myComboBoxModel = new MyComboBoxModel();
        this.createCombo();
        this.myRootPanel.add((Component)this.myComboBox);
        this.myNameEditorField = this.createNameEditorField();
        this.myRootPanel.add(this.myNameEditorField);
        this.myRootPanel.setMaximumSize(new Dimension(this.myNameEditorField.getPreferredSize().width, Short.MAX_VALUE));
    }

    private JTextField createNameEditorField() {
        JTextField nameEditorField = new JTextField(15);
        nameEditorField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemesCombo.this.cancelEdit();
            }
        }, ESC_KEY_STROKE, 0);
        nameEditorField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemesCombo.this.stopEdit();
            }
        }, ENTER_KEY_STROKE, 0);
        nameEditorField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SchemesCombo.this.stopEdit();
            }
        });
        return nameEditorField;
    }

    public void updateSelected() {
        this.myComboBox.repaint();
    }

    private void stopEdit() {
        String newName = this.myNameEditorField.getText();
        MySchemeListItem<T> selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            if (newName.equals(selectedItem.getSchemeName())) {
                this.cancelEdit();
                return;
            }
            String validationMessage = this.validateSchemeName(newName);
            if (validationMessage != null) {
                this.mySchemesPanel.showInfo(validationMessage, MessageType.ERROR);
            } else {
                this.cancelEdit();
                if (selectedItem.getScheme() != null) {
                    this.mySchemesPanel.getActions().renameScheme(selectedItem.getScheme(), newName);
                }
            }
        }
    }

    public void cancelEdit() {
        this.mySchemesPanel.clearInfo();
        this.myLayout.first(this.myRootPanel);
        this.myRootPanel.requestFocus();
    }

    private void createCombo() {
        this.myComboBox = new ComboBox((ComboBoxModel)this.myComboBoxModel);
        this.myComboBox.setRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        this.myComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemesCombo.this.mySchemesPanel.getActions().onSchemeChanged(SchemesCombo.this.getSelectedScheme());
            }
        });
    }

    public void startEdit() {
        T scheme2 = this.getSelectedScheme();
        if (scheme2 != null) {
            this.myNameEditorField.setText(scheme2.getName());
            this.myLayout.last(this.myRootPanel);
            this.myNameEditorField.requestFocus();
        }
    }

    private SimpleTextAttributes getSchemeAttributes(@NotNull MySchemeListItem<T> item) {
        SimpleTextAttributes baseAttributes;
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/application/options/schemes/SchemesCombo", "getSchemeAttributes"));
        }
        SchemesModel<T> model = this.mySchemesPanel.getModel();
        T scheme2 = item.getScheme();
        SimpleTextAttributes simpleTextAttributes = baseAttributes = scheme2 != null && model.canDeleteScheme(scheme2) ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
        if (scheme2 != null && model.canResetScheme(scheme2) && model.differsFromDefault(scheme2)) {
            return baseAttributes.derive(-1, (Color)JBColor.BLUE, null, null);
        }
        return baseAttributes;
    }

    public void resetSchemes(@NotNull Collection<T> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/application/options/schemes/SchemesCombo", "resetSchemes"));
        }
        this.myComboBoxModel.removeAllElements();
        SchemesModel model = this.mySchemesPanel.getModel();
        if (this.mySchemesPanel.supportsProjectSchemes()) {
            this.myComboBoxModel.addElement(new MySeparatorItem(PROJECT_LEVEL));
            this.addItems(schemes, scheme2 -> model.isProjectScheme(scheme2));
            this.myComboBoxModel.addElement(new MySeparatorItem(IDE_LEVEL));
            this.addItems(schemes, scheme2 -> !model.isProjectScheme(scheme2));
        } else {
            this.addItems(schemes, scheme2 -> true);
        }
    }

    private void addItems(@NotNull Collection<T> schemes, Predicate<T> filter) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/application/options/schemes/SchemesCombo", "addItems"));
        }
        for (Scheme scheme2 : schemes) {
            if (!filter.test(scheme2)) continue;
            this.myComboBoxModel.addElement(new MySchemeListItem<Scheme>(scheme2));
        }
    }

    @Nullable
    public T getSelectedScheme() {
        MySchemeListItem<T> item = this.getSelectedItem();
        return item != null ? (T)item.getScheme() : null;
    }

    @Nullable
    public MySchemeListItem<T> getSelectedItem() {
        int i2 = this.myComboBox.getSelectedIndex();
        return i2 >= 0 ? (MySchemeListItem)this.myComboBox.getItemAt(i2) : null;
    }

    public void selectScheme(@Nullable T scheme2) {
        for (int i2 = 0; i2 < this.myComboBox.getItemCount(); ++i2) {
            if (((MySchemeListItem)this.myComboBox.getItemAt(i2)).getScheme() != scheme2) continue;
            this.myComboBox.setSelectedIndex(i2);
            break;
        }
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    @Nullable
    public String validateSchemeName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/schemes/SchemesCombo", "validateSchemeName"));
        }
        if (name.isEmpty()) {
            return EMPTY_NAME_MESSAGE;
        }
        if (this.mySchemesPanel.getModel().containsScheme(name)) {
            return NAME_ALREADY_EXISTS_MESSAGE;
        }
        return null;
    }

    private class MyComboBoxModel
    extends DefaultComboBoxModel<MySchemeListItem<T>> {
        private MyComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof MySchemeListItem && ((MySchemeListItem)anObject).isSeparator()) {
                return;
            }
            super.setSelectedItem(anObject);
        }
    }

    private static class MySchemeListItem<T extends Scheme> {
        @Nullable
        private T myScheme;

        public MySchemeListItem(@Nullable T scheme2) {
            this.myScheme = scheme2;
        }

        @Nullable
        public String getSchemeName() {
            return this.myScheme != null ? this.myScheme.getName() : null;
        }

        @Nullable
        public T getScheme() {
            return this.myScheme;
        }

        @NotNull
        public String getPresentableText() {
            String string = this.myScheme != null ? SchemeManager.getDisplayName(this.myScheme) : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/SchemesCombo$MySchemeListItem", "getPresentableText"));
            }
            return string;
        }

        public boolean isSeparator() {
            return false;
        }
    }

    private class MySeparatorItem
    extends MySchemeListItem<T> {
        private String myTitle;

        public MySeparatorItem(String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/schemes/SchemesCombo$MySeparatorItem", "<init>"));
            }
            super(null);
            this.myTitle = title;
        }

        @Override
        public boolean isSeparator() {
            return true;
        }

        @Override
        @NotNull
        public String getPresentableText() {
            String string = this.myTitle;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/SchemesCombo$MySeparatorItem", "getPresentableText"));
            }
            return string;
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer<MySchemeListItem<T>> {
        private ListCellRendererWrapper<MySchemeListItem> myWrapper = new ListCellRendererWrapper<MySchemeListItem>(){

            public void customize(JList list, MySchemeListItem value, int index, boolean selected, boolean hasFocus) {
                if (value.isSeparator()) {
                    this.setText(" Stored in " + value.getPresentableText());
                    this.setSeparator();
                }
            }
        };

        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends MySchemeListItem<T>> list, MySchemeListItem<T> value, int index, boolean selected, boolean hasFocus) {
            Component c;
            if (value.isSeparator() && (c = this.myWrapper.getListCellRendererComponent(list, value, index, selected, hasFocus)) instanceof TitledSeparator) {
                ((TitledSeparator)c).getLabel().setForeground((Color)JBColor.GRAY);
                return c;
            }
            return super.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends MySchemeListItem<T>> list, MySchemeListItem<T> value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/schemes/SchemesCombo$MyListCellRenderer", "customizeCellRenderer"));
            }
            Object scheme2 = value.getScheme();
            if (scheme2 != null) {
                this.append(value.getPresentableText(), SchemesCombo.this.getSchemeAttributes(value));
                if (SchemesCombo.this.mySchemesPanel.supportsProjectSchemes() && index == -1) {
                    this.append("  " + (SchemesCombo.this.mySchemesPanel.getModel().isProjectScheme(scheme2) ? SchemesCombo.PROJECT_LEVEL : SchemesCombo.IDE_LEVEL), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }
    }
}

