/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightUtilBase
extends CodeInsightUtilCore {
    private CodeInsightUtilBase() {
    }

    public boolean prepareFileForWrite(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        Project project2 = psiFile.getProject();
        if (ReadonlyStatusHandler.ensureFilesWritable((Project)project2, (VirtualFile[])new VirtualFile[]{file2})) {
            return true;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, file2), true);
            if (editor != null && editor.getComponent().isDisplayable()) {
                HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"error.hint.file.is.readonly", (Object[])new Object[]{file2.getPresentableUrl()}));
            }
        }, project2.getDisposed());
        return false;
    }

    public boolean preparePsiElementForWrite(@Nullable PsiElement element) {
        PsiFile file2 = element == null ? null : element.getContainingFile();
        return this.prepareFileForWrite(file2);
    }

    public boolean preparePsiElementsForWrite(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/CodeInsightUtilBase", "preparePsiElementsForWrite"));
        }
        return this.preparePsiElementsForWrite(Arrays.asList(elements));
    }

    public boolean preparePsiElementsForWrite(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/CodeInsightUtilBase", "preparePsiElementsForWrite"));
        }
        if (elements.isEmpty()) {
            return true;
        }
        THashSet files = new THashSet();
        Project project2 = null;
        for (PsiElement psiElement : elements) {
            PsiFile file2;
            if (psiElement == null || (file2 = psiElement.getContainingFile()) == null || !file2.isPhysical()) continue;
            project2 = file2.getProject();
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null) continue;
            files.add(virtualFile);
        }
        if (!files.isEmpty()) {
            VirtualFile[] virtualFiles = VfsUtilCore.toVirtualFileArray((Collection)files);
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance(project2).ensureFilesWritable(virtualFiles);
            return !operationStatus.hasReadonlyFiles();
        }
        return true;
    }

    public boolean prepareVirtualFilesForWrite(@NotNull Project project2, @NotNull Collection<VirtualFile> files) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/CodeInsightUtilBase", "prepareVirtualFilesForWrite"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/CodeInsightUtilBase", "prepareVirtualFilesForWrite"));
        }
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(files);
        return !status.hasReadonlyFiles();
    }

    @Deprecated
    public static boolean prepareEditorForWrite(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/CodeInsightUtilBase", "prepareEditorForWrite"));
        }
        return EditorModificationUtil.showReadOnlyViewWarning((Editor)editor);
    }

    @Deprecated
    public static void showReadOnlyViewWarning(Editor editor) {
        EditorModificationUtil.showReadOnlyViewWarning((Editor)editor);
    }
}

