/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaMemberNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.ModifierChooser;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.ScopeFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.getters.JavaMembersGetter;
import com.intellij.psi.filters.position.AfterElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.filters.position.StartElementFilter;
import com.intellij.psi.filters.position.SuperParentFilter;
import com.intellij.psi.filters.position.TokenTypeFilter;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassLevelDeclarationStatement;
import com.intellij.psi.jsp.JspElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaKeywordCompletion {
    public static final ElementPattern<PsiElement> AFTER_DOT = PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."});
    static final ElementPattern<PsiElement> VARIABLE_AFTER_FINAL = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"final"})).inside(PsiDeclarationStatement.class);
    private static final ElementPattern<PsiElement> INSIDE_PARAMETER_LIST = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).insideStarting((ElementPattern)PsiJavaPatterns.psiElement().withTreeParent((ElementPattern)PsiJavaPatterns.psiElement(PsiParameterList.class).andNot((ElementPattern)PsiJavaPatterns.psiElement(PsiAnnotationParameterList.class)))));
    private static final AndFilter START_OF_CODE_FRAGMENT = new AndFilter((ElementFilter)new ScopeFilter(new AndFilter(new ClassFilter(JavaCodeFragment.class), new ClassFilter(PsiExpressionCodeFragment.class, false), new ClassFilter(PsiJavaCodeReferenceCodeFragment.class, false), new ClassFilter(PsiTypeCodeFragment.class, false))), (ElementFilter)new StartElementFilter());
    static final NotNullLazyValue<ElementFilter> END_OF_BLOCK = new AtomicNotNullLazyValue<ElementFilter>(){

        @NotNull
        protected ElementFilter compute() {
            OrFilter orFilter = new OrFilter(new AndFilter((ElementFilter)new LeftNeighbour(new OrFilter(new AndFilter((ElementFilter)new TextFilter("{", "}", ";", ":", "else"), (ElementFilter)new NotFilter(new SuperParentFilter(new ClassFilter(PsiAnnotation.class)))), new ElementFilter(){

                public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                    return ((PsiElement)element).getText().endsWith("*/");
                }

                public boolean isClassAcceptable(Class hintClass) {
                    return true;
                }
            }, new TokenTypeFilter(JspElementType.HOLDER_TEMPLATE_DATA), new ClassFilter(OuterLanguageElement.class), new AndFilter((ElementFilter)new TextFilter(")"), (ElementFilter)new NotFilter(new OrFilter(new ParentElementFilter(new ClassFilter(PsiExpressionList.class)), new ParentElementFilter(new ClassFilter(PsiParameterList.class)), new ParentElementFilter(new ClassFilter(PsiTypeCastExpression.class))))))), (ElementFilter)new NotFilter(new TextFilter("."))), START_OF_CODE_FRAGMENT);
            if (orFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaKeywordCompletion$1", "compute"));
            }
            return orFilter;
        }
    };
    static final ElementPattern<PsiElement> START_SWITCH = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("{")).withParents(new Class[]{PsiCodeBlock.class, PsiSwitchStatement.class}));
    private static final ElementPattern<PsiElement> SUPER_OR_THIS_PATTERN = PsiJavaPatterns.and((ElementPattern[])new ElementPattern[]{JavaSmartCompletionContributor.INSIDE_EXPRESSION, StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"case"})), StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(".")).afterLeaf(new String[]{"this", "super"}))), StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().inside(PsiAnnotation.class)), StandardPatterns.not(START_SWITCH), StandardPatterns.not(JavaMemberNameCompletionContributor.INSIDE_TYPE_PARAMS_PATTERN)});
    static final Set<String> PRIMITIVE_TYPES = ContainerUtil.newLinkedHashSet((Object[])new String[]{"short", "boolean", "double", "long", "int", "float", "char", "byte"});
    private static final NotNullLazyValue<ElementFilter> CLASS_BODY = new AtomicNotNullLazyValue<ElementFilter>(){

        @NotNull
        protected ElementFilter compute() {
            OrFilter orFilter = new OrFilter(new AfterElementFilter(new TextFilter("{")), new ScopeFilter(new ClassFilter(JspClassLevelDeclarationStatement.class)));
            if (orFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaKeywordCompletion$2", "compute"));
            }
            return orFilter;
        }
    };
    static final ElementPattern<PsiElement> START_FOR = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("(")).afterLeaf(new String[]{"for"}))).withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiExpressionStatement.class, PsiForStatement.class});
    private static final ElementPattern<PsiElement> CLASS_REFERENCE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().referencing((ElementPattern)PsiJavaPatterns.psiClass().andNot((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeParameter.class))));
    private static final ElementPattern<PsiElement> EXPR_KEYWORDS = PsiJavaPatterns.and((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent((ElementPattern)StandardPatterns.not((ElementPattern)PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiTypeCastExpression.class), PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class), PsiJavaPatterns.psiElement(PsiExpressionStatement.class), PsiJavaPatterns.psiElement(PsiPrefixExpression.class)})))), StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."}))});
    static final NotNullLazyValue<ElementPattern<PsiElement>> DECLARATION_START = new NotNullLazyValue<ElementPattern<PsiElement>>(){

        @NotNull
        protected ElementPattern<PsiElement> compute() {
            ObjectPattern objectPattern = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().andNot((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@", "."}))).andOr(new ElementPattern[]{((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().and((ElementPattern)new FilterPattern((ElementFilter)CLASS_BODY.getValue()))).andOr(new ElementPattern[]{new FilterPattern((ElementFilter)END_OF_BLOCK.getValue()), PsiJavaPatterns.psiElement().afterLeaf(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().inside(PsiModifierList.class), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withElementType(JavaTokenType.GT)).inside(PsiTypeParameterList.class)}))}), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiTypeElement.class, PsiMember.class}), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiTypeElement.class, PsiClassLevelDeclarationStatement.class})});
            if (objectPattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaKeywordCompletion$3", "compute"));
            }
            return objectPattern;
        }
    };

    public static boolean isInsideParameterList(PsiElement position) {
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        PsiModifierList modifierList = (PsiModifierList)PsiTreeUtil.getParentOfType((PsiElement)prev, PsiModifierList.class);
        if (modifierList != null) {
            if (PsiTreeUtil.isAncestor((PsiElement)modifierList, (PsiElement)position, (boolean)false)) {
                return false;
            }
            PsiElement parent = modifierList.getParent();
            return parent instanceof PsiParameterList || parent instanceof PsiParameter && parent.getParent() instanceof PsiParameterList;
        }
        return INSIDE_PARAMETER_LIST.accepts((Object)position);
    }

    private static TailType getReturnTail(PsiElement position) {
        PsiElement scope = position;
        while (!(scope instanceof PsiFile) && !(scope instanceof PsiClassInitializer)) {
            if (scope instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)scope;
                if (method2.isConstructor() || PsiType.VOID.equals((Object)method2.getReturnType())) {
                    return TailType.SEMICOLON;
                }
                return TailType.HUMBLE_SPACE_BEFORE_WORD;
            }
            if (scope instanceof PsiLambdaExpression) {
                PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)scope));
                if (PsiType.VOID.equals((Object)returnType)) {
                    return TailType.SEMICOLON;
                }
                return TailType.HUMBLE_SPACE_BEFORE_WORD;
            }
            scope = scope.getParent();
        }
        return TailType.NONE;
    }

    private static void addStatementKeywords(Consumer<LookupElement> variant, PsiElement position, @Nullable PsiElement prevLeaf) {
        variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "switch"), TailTypes.SWITCH_LPARENTH));
        variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "while"), TailTypes.WHILE_LPARENTH));
        variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "do"), TailTypes.DO_LBRACE));
        variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "for"), TailTypes.FOR_LPARENTH));
        variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "if"), TailTypes.IF_LPARENTH));
        variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "try"), TailTypes.TRY_LBRACE));
        variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "throw"), TailType.INSERT_SPACE));
        variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "new"), TailType.INSERT_SPACE));
        variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "synchronized"), TailTypes.SYNCHRONIZED_LPARENTH));
        if (PsiUtil.getLanguageLevel((PsiElement)position).isAtLeast(LanguageLevel.JDK_1_4)) {
            variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "assert"), TailType.INSERT_SPACE));
        }
        TailType returnTail = JavaKeywordCompletion.getReturnTail(position);
        Object ret = JavaKeywordCompletion.createKeyword(position, "return");
        if (returnTail != TailType.NONE) {
            ret = new OverrideableSpace((LookupElement)ret, returnTail);
        }
        variant.consume(ret);
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(";")).withSuperParent(2, PsiIfStatement.class)).accepts((Object)prevLeaf) || ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("}")).withSuperParent(3, PsiIfStatement.class)).accepts((Object)prevLeaf)) {
            variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "else"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("}")).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiCodeBlock.class).withParent(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiTryStatement.class), PsiJavaPatterns.psiElement(PsiCatchSection.class)})))).accepts((Object)prevLeaf)) {
            variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "catch"), TailTypes.CATCH_LPARENTH));
            variant.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "finally"), TailTypes.FINALLY_LBRACE));
        }
    }

    static void addKeywords(CompletionParameters parameters, JavaCompletionSession session2, Consumer<LookupElement> result2) {
        PsiElement position = parameters.getPosition();
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{PsiLiteralExpression.class, PsiComment.class}) != null) {
            return;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        JavaKeywordCompletion.addFinal(result2, position, prevLeaf);
        boolean statementPosition = JavaKeywordCompletion.isStatementPosition(position);
        if (statementPosition) {
            JavaKeywordCompletion.addCaseDefault(result2, position);
            if (START_SWITCH.accepts((Object)position)) {
                return;
            }
            JavaKeywordCompletion.addBreakContinue(result2, position);
            JavaKeywordCompletion.addStatementKeywords(result2, position, prevLeaf);
        }
        JavaKeywordCompletion.addThisSuper(result2, position);
        JavaKeywordCompletion.addExpressionKeywords(parameters, result2, position, prevLeaf, statementPosition);
        JavaKeywordCompletion.addFileHeaderKeywords(result2, position, prevLeaf);
        JavaKeywordCompletion.addInstanceof(result2, position);
        JavaKeywordCompletion.addClassKeywords(result2, position, prevLeaf);
        JavaKeywordCompletion.addMethodHeaderKeywords(result2, position, prevLeaf);
        JavaKeywordCompletion.addPrimitiveTypes(result2, position, session2);
        JavaKeywordCompletion.addClassLiteral(result2, position);
        JavaKeywordCompletion.addUnfinishedMethodTypeParameters(position, result2);
        JavaKeywordCompletion.addExtendsSuperImplements(result2, position, prevLeaf);
    }

    private static void addMethodHeaderKeywords(Consumer<LookupElement> result2, PsiElement position, @Nullable PsiElement prevLeaf) {
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(")")).withParents(new Class[]{PsiParameterList.class, PsiMethod.class})).accepts((Object)prevLeaf)) {
            assert (prevLeaf != null);
            if (prevLeaf.getParent().getParent() instanceof PsiAnnotationMethod) {
                result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "default"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            } else {
                result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "throws"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        }
    }

    private static void addCaseDefault(Consumer<LookupElement> result2, PsiElement position) {
        if (JavaKeywordCompletion.getSwitchFromLabelPosition(position) != null) {
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "case"), TailType.INSERT_SPACE));
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "default"), TailType.CASE_COLON));
        }
    }

    private static PsiSwitchStatement getSwitchFromLabelPosition(PsiElement position) {
        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiStatement.class, (boolean)false, (Class[])new Class[]{PsiMember.class});
        if (statement2 != null && !(statement2 instanceof PsiSwitchLabelStatement) && statement2.getParent() instanceof PsiCodeBlock) {
            return (PsiSwitchStatement)ObjectUtils.tryCast((Object)statement2.getParent().getParent(), PsiSwitchStatement.class);
        }
        return null;
    }

    static void addEnumCases(CompletionResultSet result2, PsiElement position) {
        PsiClass switchType;
        PsiSwitchStatement switchStatement = JavaKeywordCompletion.getSwitchFromLabelPosition(position);
        PsiExpression expression = switchStatement == null ? null : switchStatement.getExpression();
        PsiClass psiClass = switchType = expression == null ? null : PsiUtil.resolveClassInClassTypeOnly((PsiType)expression.getType());
        if (switchType == null || !switchType.isEnum()) {
            return;
        }
        Set<PsiField> used = ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch(switchStatement);
        for (PsiField field : switchType.getAllFields()) {
            String name = field.getName();
            if (!(field instanceof PsiEnumConstant) || used.contains(CompletionUtil.getOriginalOrSelf(field)) || name == null) continue;
            String prefix = "case ";
            String suffix = name + ":";
            LookupElementBuilder caseConst = LookupElementBuilder.create((Object)field, (String)(prefix + suffix)).bold().withPresentableText(prefix).withTailText(suffix).withLookupString(name);
            result2.addElement((LookupElement)new JavaCompletionContributor.IndentingDecorator((LookupElement)caseConst));
        }
    }

    private static void addFinal(Consumer<LookupElement> result2, PsiElement position, @Nullable PsiElement prevLeaf) {
        PsiTryStatement tryStatement;
        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiExpressionStatement.class);
        if (statement2 == null) {
            statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiDeclarationStatement.class);
        }
        if (!(statement2 == null || statement2.getTextRange().getStartOffset() != position.getTextRange().getStartOffset() || ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withSuperParent(2, PsiSwitchStatement.class)).afterLeaf(new String[]{"{"})).accepts((Object)statement2) || (tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)prevLeaf, PsiTryStatement.class)) != null && tryStatement.getCatchSections().length <= 0 && tryStatement.getFinallyBlock() == null && tryStatement.getResourceList() == null)) {
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "final"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            return;
        }
        if ((JavaKeywordCompletion.isInsideParameterList(position) || JavaKeywordCompletion.isAtResourceVariableStart(position) || JavaKeywordCompletion.isAtCatchVariableStart(position)) && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"final"})).accepts((Object)position) && !AFTER_DOT.accepts((Object)position)) {
            result2.consume(TailTypeDecorator.withTail(JavaKeywordCompletion.createKeyword(position, "final"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
    }

    private static void addThisSuper(Consumer<LookupElement> result2, PsiElement position) {
        if (SUPER_OR_THIS_PATTERN.accepts((Object)position)) {
            boolean insideInheritorClass;
            boolean afterDot = AFTER_DOT.accepts((Object)position);
            boolean insideQualifierClass = JavaKeywordCompletion.isInsideQualifierClass(position);
            boolean bl = insideInheritorClass = PsiUtil.isLanguageLevel8OrHigher((PsiElement)position) && JavaKeywordCompletion.isInsideInheritorClass(position);
            if (!afterDot || insideQualifierClass || insideInheritorClass) {
                if (!afterDot || insideQualifierClass) {
                    result2.consume((Object)JavaKeywordCompletion.createKeyword(position, "this"));
                }
                LookupElement superItem = JavaKeywordCompletion.createKeyword(position, "super");
                if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("{")).withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiMethod().constructor(true)))).accepts((Object)position)) {
                    PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethod.class, (boolean)false, (Class[])new Class[]{PsiClass.class});
                    assert (method2 != null);
                    final boolean hasParams = JavaKeywordCompletion.superConstructorHasParameters(method2);
                    result2.consume((Object)LookupElementDecorator.withInsertHandler((LookupElement)superItem, (InsertHandler)new ParenthesesInsertHandler<LookupElement>(){

                        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
                            return hasParams;
                        }

                        public void handleInsert(InsertionContext context, LookupElement item) {
                            super.handleInsert(context, item);
                            TailType.insertChar((Editor)context.getEditor(), (int)context.getTailOffset(), (char)';');
                        }
                    }));
                    return;
                }
                result2.consume((Object)superItem);
            }
        }
    }

    private static void addExpressionKeywords(CompletionParameters parameters, Consumer<LookupElement> result2, PsiElement position, @Nullable PsiElement prevLeaf, boolean statementPosition) {
        if (PsiJavaPatterns.psiElement((IElementType)JavaTokenType.DOUBLE_COLON).accepts((Object)prevLeaf)) {
            PsiMethodReferenceExpression parent = (PsiMethodReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiMethodReferenceExpression.class);
            TailType tail = parent != null && !LambdaHighlightingUtil.insertSemicolon(parent.getParent()) ? TailType.SEMICOLON : TailType.NONE;
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "new"), tail));
            return;
        }
        if (JavaKeywordCompletion.isExpressionPosition(position)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class) == null) {
                if (!statementPosition) {
                    result2.consume(TailTypeDecorator.withTail(JavaKeywordCompletion.createKeyword(position, "new"), TailType.INSERT_SPACE));
                }
                result2.consume((Object)JavaKeywordCompletion.createKeyword(position, "null"));
            }
            if (JavaKeywordCompletion.mayExpectBoolean(parameters)) {
                result2.consume((Object)JavaKeywordCompletion.createKeyword(position, "true"));
                result2.consume((Object)JavaKeywordCompletion.createKeyword(position, "false"));
            }
        }
    }

    private static void addFileHeaderKeywords(Consumer<LookupElement> result2, PsiElement position, @Nullable PsiElement prevLeaf) {
        PsiFile file2 = position.getContainingFile();
        if (!(file2 instanceof PsiExpressionCodeFragment || file2 instanceof PsiJavaCodeReferenceCodeFragment || file2 instanceof PsiTypeCodeFragment)) {
            if (prevLeaf == null) {
                result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "package"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "import"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            } else if (((ElementFilter)END_OF_BLOCK.getValue()).isAcceptable((Object)position, position) && PsiTreeUtil.getParentOfType((PsiElement)position, PsiMember.class) == null) {
                result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "import"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        }
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)position) && prevLeaf != null && prevLeaf.textMatches((CharSequence)"import")) {
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "static"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
    }

    private static void addInstanceof(Consumer<LookupElement> result2, PsiElement position) {
        if (JavaKeywordCompletion.isInstanceofPlace(position)) {
            result2.consume((Object)LookupElementDecorator.withInsertHandler((LookupElement)JavaKeywordCompletion.createKeyword(position, "instanceof"), (InsertHandler)new InsertHandler<LookupElementDecorator<LookupElement>>(){

                public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
                    TailType tailType = TailType.HUMBLE_SPACE_BEFORE_WORD;
                    if (tailType.isApplicable(context)) {
                        tailType.processTail(context.getEditor(), context.getTailOffset());
                    }
                    if ('!' == context.getCompletionChar()) {
                        context.setAddCompletionChar(false);
                        context.commitDocument();
                        PsiInstanceOfExpression expr = (PsiInstanceOfExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiInstanceOfExpression.class, (boolean)false);
                        if (expr != null) {
                            String space = context.getCodeStyleSettings().SPACE_WITHIN_PARENTHESES ? " " : "";
                            context.getDocument().insertString(expr.getTextRange().getStartOffset(), (CharSequence)("!(" + space));
                            context.getDocument().insertString(context.getTailOffset(), (CharSequence)(space + ")"));
                        }
                    }
                }
            }));
        }
    }

    private static void addClassKeywords(Consumer<LookupElement> result2, PsiElement position, @Nullable PsiElement prevLeaf) {
        if (JavaKeywordCompletion.isSuitableForClass(position)) {
            for (String s : ModifierChooser.getKeywords(position)) {
                result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, s), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "class"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class}) == null) {
                result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "interface"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)position)) {
                    result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "enum"), TailType.INSERT_SPACE));
                }
            }
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("@")).andNot((ElementPattern)PsiJavaPatterns.psiElement().inside(PsiParameterList.class))).andNot((ElementPattern)PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiNameValuePair()))).accepts((Object)prevLeaf)) {
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "interface"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
    }

    private static void addClassLiteral(Consumer<LookupElement> result2, PsiElement position) {
        if (JavaKeywordCompletion.isAfterTypeDot(position)) {
            result2.consume((Object)JavaKeywordCompletion.createKeyword(position, "class"));
        }
    }

    private static void addExtendsSuperImplements(Consumer<LookupElement> result2, PsiElement position, @Nullable PsiElement prevLeaf) {
        if (JavaMemberNameCompletionContributor.INSIDE_TYPE_PARAMS_PATTERN.accepts((Object)position)) {
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "extends"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "super"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
        if (prevLeaf == null || !(prevLeaf instanceof PsiIdentifier) && !prevLeaf.textMatches((CharSequence)">")) {
            return;
        }
        PsiClass psiClass = null;
        PsiElement prevParent = prevLeaf.getParent();
        if (prevLeaf instanceof PsiIdentifier && prevParent instanceof PsiClass) {
            psiClass = (PsiClass)prevParent;
        } else {
            PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)prevLeaf, PsiReferenceList.class);
            if (referenceList != null && referenceList.getParent() instanceof PsiClass) {
                psiClass = (PsiClass)referenceList.getParent();
            } else if (prevParent instanceof PsiTypeParameterList && prevParent.getParent() instanceof PsiClass) {
                psiClass = (PsiClass)prevParent.getParent();
            }
        }
        if (psiClass != null) {
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "extends"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            if (!psiClass.isInterface()) {
                result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "implements"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        }
    }

    private static boolean mayExpectBoolean(CompletionParameters parameters) {
        for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
            PsiType type = info.getType();
            if (!(type instanceof PsiClassType) && !PsiType.BOOLEAN.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExpressionPosition(PsiElement position) {
        return EXPR_KEYWORDS.accepts((Object)position) || ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiClassObjectAccessExpression.class))).accepts((Object)position);
    }

    public static boolean isInstanceofPlace(PsiElement position) {
        PsiType type;
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        if (prev == null) {
            return false;
        }
        PsiElement expr = PsiTreeUtil.getParentOfType((PsiElement)prev, PsiExpression.class);
        if (expr != null && expr.getTextRange().getEndOffset() == prev.getTextRange().getEndOffset()) {
            return true;
        }
        return position instanceof PsiIdentifier && position.getParent() instanceof PsiLocalVariable && (type = ((PsiLocalVariable)position.getParent()).getType()) instanceof PsiClassType && ((PsiClassType)type).resolve() == null;
    }

    public static boolean isSuitableForClass(PsiElement position) {
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@"})).accepts((Object)position) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{PsiLiteralExpression.class, PsiComment.class, PsiExpressionCodeFragment.class}) != null) {
            return false;
        }
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        if (prev == null) {
            return true;
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withoutText(".")).inside((ElementPattern)PsiJavaPatterns.psiElement(PsiModifierList.class).withParent((ElementPattern)StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement(PsiParameter.class)).andNot((ElementPattern)PsiJavaPatterns.psiElement(PsiParameterList.class))))).accepts((Object)prev) && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotationParameterList.class)).accepts((Object)prev)) {
            return true;
        }
        return ((ElementFilter)END_OF_BLOCK.getValue()).isAcceptable((Object)position, position);
    }

    static void addExpectedTypeMembers(CompletionParameters parameters, CompletionResultSet result2) {
        if (parameters.getInvocationCount() <= 1) {
            for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
                new JavaMembersGetter(info.getDefaultType(), parameters).addMembers(false, (Consumer<LookupElement>)result2);
            }
        }
    }

    private static void addUnfinishedMethodTypeParameters(PsiElement position, Consumer<LookupElement> result2) {
        ProcessingContext context = new ProcessingContext();
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(">")).withParent((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiTypeParameterList.class).withParent(PsiErrorElement.class)).save("typeParameterList"))))).accepts((Object)position, context)) {
            PsiTypeParameterList list = (PsiTypeParameterList)context.get((Object)"typeParameterList");
            PsiElement current = list.getParent().getParent();
            if (current instanceof PsiField) {
                current = current.getParent();
            }
            if (current instanceof PsiClass) {
                for (PsiTypeParameter typeParameter : list.getTypeParameters()) {
                    result2.consume((Object)new JavaPsiClassReferenceElement((PsiClass)typeParameter));
                }
            }
        }
    }

    static boolean isAfterPrimitiveOrArrayType(PsiElement element) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withFirstChild((ElementPattern)PsiJavaPatterns.psiElement(PsiClassObjectAccessExpression.class).withLastChild((ElementPattern)StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().withText("class")))))).accepts((Object)element);
    }

    static boolean isAfterTypeDot(PsiElement position) {
        if (JavaKeywordCompletion.isInsideParameterList(position) || position.getContainingFile() instanceof PsiJavaCodeReferenceCodeFragment) {
            return false;
        }
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(".")).afterLeaf(CLASS_REFERENCE))).accepts((Object)position) || JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position);
    }

    static void addPrimitiveTypes(Consumer<LookupElement> result2, PsiElement position, JavaCompletionSession session2) {
        boolean inGenerics;
        if (AFTER_DOT.accepts((Object)position) || ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiAnnotation())).accepts((Object)position) && !JavaKeywordCompletion.expectsClassLiteral(position)) {
            return;
        }
        boolean afterNew = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("new")).andNot((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"throw", "."})))).accepts((Object)position);
        if (afterNew) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)position.getProject());
            for (String primitiveType : PRIMITIVE_TYPES) {
                result2.consume((Object)PsiTypeLookupItem.createLookupItem(factory.createTypeFromText(primitiveType + "[]", null), null));
            }
            result2.consume((Object)PsiTypeLookupItem.createLookupItem(factory.createTypeFromText("void[]", null), null));
            return;
        }
        boolean inCast = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("(")).withParent((ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class})))).accepts((Object)position);
        boolean typeFragment = position.getContainingFile() instanceof PsiTypeCodeFragment && PsiTreeUtil.prevVisibleLeaf((PsiElement)position) == null;
        boolean declaration = ((ElementPattern)DECLARATION_START.getValue()).accepts((Object)position);
        boolean expressionPosition = JavaKeywordCompletion.isExpressionPosition(position);
        boolean bl = inGenerics = PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceParameterList.class) != null;
        if (START_FOR.accepts((Object)position) || JavaKeywordCompletion.isInsideParameterList(position) || inGenerics || VARIABLE_AFTER_FINAL.accepts((Object)position) || inCast || declaration || typeFragment || expressionPosition || JavaKeywordCompletion.isStatementPosition(position)) {
            for (String primitiveType : PRIMITIVE_TYPES) {
                if (session2.isKeywordAlreadyProcessed(primitiveType)) continue;
                result2.consume((Object)JavaKeywordCompletion.createKeyword(position, primitiveType));
            }
        }
        if (declaration) {
            result2.consume((Object)new OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "void"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        } else if (typeFragment && ((PsiTypeCodeFragment)position.getContainingFile()).isVoidValid()) {
            result2.consume((Object)JavaKeywordCompletion.createKeyword(position, "void"));
        }
    }

    private static boolean expectsClassLiteral(PsiElement position) {
        return ContainerUtil.find((Object[])JavaSmartCompletionContributor.getExpectedTypes(position, false), info -> InheritanceUtil.isInheritor((PsiType)info.getType(), (String)"java.lang.Class")) != null;
    }

    private static boolean isAtResourceVariableStart(PsiElement position) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).withParent(PsiResourceList.class))).accepts((Object)position);
    }

    private static boolean isAtCatchVariableStart(PsiElement position) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).withParent(PsiCatchSection.class))).accepts((Object)position);
    }

    private static void addBreakContinue(Consumer<LookupElement> result2, PsiElement position) {
        PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiMember.class});
        Object br = JavaKeywordCompletion.createKeyword(position, "break");
        Object cont = JavaKeywordCompletion.createKeyword(position, "continue");
        TailType tailType = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideSequence(true, new ElementPattern[]{PsiJavaPatterns.psiElement(PsiLabeledStatement.class), PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiFile.class), PsiJavaPatterns.psiElement(PsiMethod.class), PsiJavaPatterns.psiElement(PsiClassInitializer.class)})})).accepts((Object)position) ? TailType.HUMBLE_SPACE_BEFORE_WORD : TailType.SEMICOLON;
        br = TailTypeDecorator.withTail(br, tailType);
        cont = TailTypeDecorator.withTail(cont, tailType);
        if (loop != null && PsiTreeUtil.isAncestor((PsiElement)loop.getBody(), (PsiElement)position, (boolean)false)) {
            result2.consume(br);
            result2.consume(cont);
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiSwitchStatement.class)).accepts((Object)position)) {
            result2.consume(br);
        }
        for (PsiLabeledStatement labeled : SyntaxTraverser.psiApi().parents((Object)position).takeWhile(Conditions.notInstanceOf(PsiMember.class)).filter(PsiLabeledStatement.class)) {
            result2.consume(TailTypeDecorator.withTail(LookupElementBuilder.create((String)("break " + labeled.getName())).bold(), TailType.SEMICOLON));
        }
    }

    private static boolean isStatementPosition(PsiElement position) {
        PsiElement stmt;
        PsiIfStatement ifStatement;
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withSuperParent(2, PsiConditionalExpression.class)).andNot((ElementPattern)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiConditionalExpression.class)))).accepts((Object)position)) {
            return false;
        }
        if (((ElementFilter)END_OF_BLOCK.getValue()).isAcceptable((Object)position, position) && PsiTreeUtil.getParentOfType((PsiElement)position, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class}) != null) {
            return true;
        }
        return ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiExpressionStatement.class, PsiIfStatement.class})).andNot((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."}))).accepts((Object)position) && ((ifStatement = (PsiIfStatement)(stmt = position.getParent().getParent()).getParent()).getElseBranch() == stmt || ifStatement.getThenBranch() == stmt);
    }

    protected static LookupElement createKeyword(PsiElement position, String keyword) {
        return BasicExpressionCompletionContributor.createKeywordLookupItem(position, keyword);
    }

    private static boolean isInsideQualifierClass(PsiElement position) {
        PsiElement qualifierClass;
        PsiElement qualifier;
        if (position.getParent() instanceof PsiJavaCodeReferenceElement && (qualifier = ((PsiJavaCodeReferenceElement)position.getParent()).getQualifier()) instanceof PsiJavaCodeReferenceElement && (qualifierClass = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass) {
            PsiElement parent = position;
            PsiManager psiManager = position.getManager();
            while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)true)) != null) {
                if (!psiManager.areElementsEquivalent(parent, qualifierClass)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInsideInheritorClass(PsiElement position) {
        PsiElement qualifierClass;
        PsiElement qualifier;
        if (position.getParent() instanceof PsiJavaCodeReferenceElement && (qualifier = ((PsiJavaCodeReferenceElement)position.getParent()).getQualifier()) instanceof PsiJavaCodeReferenceElement && (qualifierClass = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass && ((PsiClass)qualifierClass).isInterface()) {
            PsiElement parent = position;
            while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)true)) != null) {
                if (PsiUtil.getEnclosingStaticElement((PsiElement)position, (PsiClass)((PsiClass)parent)) != null || !((PsiClass)parent).isInheritor((PsiClass)qualifierClass, true)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean superConstructorHasParameters(PsiMethod method2) {
        PsiClass psiClass = method2.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass superClass = psiClass.getSuperClass();
        if (superClass != null) {
            for (PsiMethod psiMethod : superClass.getConstructors()) {
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)method2.getProject()).getResolveHelper();
                if (!resolveHelper.isAccessible((PsiMember)psiMethod, (PsiElement)method2, null) || psiMethod.getParameterList().getParameters().length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static class OverrideableSpace
    extends TailTypeDecorator<LookupElement> {
        private final TailType myTail;

        public OverrideableSpace(LookupElement keyword, TailType tail) {
            super(keyword);
            this.myTail = tail;
        }

        @Override
        protected TailType computeTailType(InsertionContext context) {
            return context.shouldAddCompletionChar() ? TailType.NONE : this.myTail;
        }
    }
}

