/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.simple.RParenthTailType;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartCastProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> TYPECAST_TYPE_CANDIDATE = PlatformPatterns.psiElement().afterLeaf(new String[]{"("});

    SmartCastProvider() {
    }

    static boolean shouldSuggestCast(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        PsiElement parent = SmartCastProvider.getParenthesisOwner(position);
        if (parent instanceof PsiTypeCastExpression) {
            return true;
        }
        if (parent instanceof PsiParenthesizedExpression) {
            return parameters.getOffset() == position.getTextRange().getStartOffset();
        }
        return false;
    }

    private static PsiElement getParenthesisOwner(PsiElement position) {
        PsiElement lParen = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        return lParen == null || !lParen.textMatches((CharSequence)"(") ? null : lParen.getParent();
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/SmartCastProvider", "addCompletions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/SmartCastProvider", "addCompletions"));
        }
        SmartCastProvider.addCastVariants(parameters, result2.getPrefixMatcher(), (Consumer<LookupElement>)result2);
    }

    static void addCastVariants(@NotNull CompletionParameters parameters, PrefixMatcher matcher, @NotNull Consumer<LookupElement> result2) {
        PsiElement parent;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/SmartCastProvider", "addCastVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/SmartCastProvider", "addCastVariants"));
        }
        if (!SmartCastProvider.shouldSuggestCast(parameters)) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PsiElement parenthesisOwner = SmartCastProvider.getParenthesisOwner(position);
        boolean insideCast = parenthesisOwner instanceof PsiTypeCastExpression;
        if (insideCast && (parent = parenthesisOwner.getParent()) instanceof PsiParenthesizedExpression) {
            ExpectedTypeInfo info;
            if (parent.getParent() instanceof PsiReferenceExpression) {
                for (ExpectedTypeInfo info2 : ExpectedTypesProvider.getExpectedTypes((PsiExpression)((PsiParenthesizedExpression)parent), false)) {
                    result2.consume((Object)PsiTypeLookupItem.createLookupItem(info2.getType(), parent));
                }
            }
            if ((info = SmartCastProvider.getParenthesizedCastExpectationByOperandType(position)) != null) {
                SmartCastProvider.addHierarchyTypes(parameters, matcher, info, (Consumer<PsiType>)((Consumer)type -> {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/SmartCastProvider", "lambda$addCastVariants$0"));
                    }
                    result2.consume((Object)PsiTypeLookupItem.createLookupItem(type, parent));
                }));
            }
            return;
        }
        for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
            PsiClassType boxedType;
            PsiType castedType;
            PsiType type2 = info.getDefaultType();
            if (type2 instanceof PsiWildcardType) {
                type2 = ((PsiWildcardType)type2).getBound();
            }
            if (type2 == null || PsiType.VOID.equals((Object)type2)) continue;
            if (type2 instanceof PsiPrimitiveType && (castedType = SmartCastProvider.getCastedExpressionType(parenthesisOwner)) != null && !(castedType instanceof PsiPrimitiveType) && (boxedType = ((PsiPrimitiveType)type2).getBoxedType(position)) != null) {
                type2 = boxedType;
            }
            result2.consume((Object)SmartCastProvider.createSmartCastElement(parameters, insideCast, type2));
        }
    }

    @Nullable
    static ExpectedTypeInfo getParenthesizedCastExpectationByOperandType(PsiElement position) {
        PsiElement parenthesisOwner = SmartCastProvider.getParenthesisOwner(position);
        PsiExpression operand = SmartCastProvider.getCastedExpression(parenthesisOwner);
        if (operand == null || !(parenthesisOwner.getParent() instanceof PsiParenthesizedExpression)) {
            return null;
        }
        PsiType dfaType = GuessManager.getInstance(operand.getProject()).getControlFlowExpressionType(operand);
        if (dfaType != null) {
            return new ExpectedTypeInfoImpl(dfaType, 2, dfaType, TailType.NONE, null, (NullableComputable<String>)((NullableComputable)() -> null));
        }
        PsiType type = operand.getType();
        return type == null || type.equalsToText("java.lang.Object") ? null : new ExpectedTypeInfoImpl(type, 1, type, TailType.NONE, null, (NullableComputable<String>)((NullableComputable)() -> null));
    }

    private static void addHierarchyTypes(CompletionParameters parameters, PrefixMatcher matcher, ExpectedTypeInfo info, Consumer<PsiType> result2) {
        PsiType infoType = info.getType();
        PsiClass infoClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)infoType);
        if (info.getKind() == 2) {
            InheritanceUtil.processSupers((PsiClass)infoClass, (boolean)true, superClass -> {
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) {
                    result2.consume((Object)JavaPsiFacade.getElementFactory((Project)superClass.getProject()).createType(superClass));
                }
                return true;
            });
        } else {
            JavaInheritorsGetter.processInheritors(parameters, Collections.singleton((PsiClassType)infoType), matcher, (Consumer<PsiType>)((Consumer)type -> {
                if (!infoType.equals(type)) {
                    result2.consume(type);
                }
            }));
        }
    }

    private static PsiType getCastedExpressionType(PsiElement parenthesisOwner) {
        PsiExpression operand = SmartCastProvider.getCastedExpression(parenthesisOwner);
        return operand == null ? null : operand.getType();
    }

    private static PsiExpression getCastedExpression(PsiElement parenthesisOwner) {
        if (parenthesisOwner instanceof PsiTypeCastExpression) {
            return ((PsiTypeCastExpression)parenthesisOwner).getOperand();
        }
        if (parenthesisOwner instanceof PsiParenthesizedExpression) {
            PsiElement next;
            for (next = parenthesisOwner.getNextSibling(); next != null && (next instanceof PsiEmptyExpressionImpl || next instanceof PsiErrorElement || next instanceof PsiWhiteSpace); next = next.getNextSibling()) {
            }
            if (next instanceof PsiExpression) {
                return (PsiExpression)next;
            }
        }
        return null;
    }

    private static LookupElement createSmartCastElement(final CompletionParameters parameters, final boolean overwrite, PsiType type) {
        return AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE.applyPolicy((LookupElement)new LookupElementDecorator<PsiTypeLookupItem>(PsiTypeLookupItem.createLookupItem(type, parameters.getPosition())){

            public void handleInsert(InsertionContext context) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.casting");
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                if (overwrite) {
                    document.deleteString(context.getSelectionEndOffset(), context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
                }
                CommonCodeStyleSettings csSettings = context.getCodeStyleSettings();
                int oldTail = context.getTailOffset();
                context.setTailOffset(RParenthTailType.addRParenth(editor, oldTail, csSettings.SPACE_WITHIN_CAST_PARENTHESES));
                ((PsiTypeLookupItem)this.getDelegate()).handleInsert(CompletionUtil.newContext(context, this.getDelegate(), context.getStartOffset(), oldTail));
                PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting();
                if (csSettings.SPACE_AFTER_TYPE_CAST) {
                    context.setTailOffset(TailType.insertChar((Editor)editor, (int)context.getTailOffset(), (char)' '));
                }
                if (parameters.getCompletionType() == CompletionType.SMART) {
                    editor.getCaretModel().moveToOffset(context.getTailOffset());
                }
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        });
    }
}

