/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.CleanupOnScopeIntention;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.EditCleanupProfileIntentionAction;
import com.intellij.codeInsight.daemon.impl.EditorNotificationActions;
import com.intellij.codeInsight.daemon.impl.GutterIntentionAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.actions.CleanupAllIntention;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionsPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.ShowIntentionsPass");
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myPassIdToShowIntentionsFor;
    private final IntentionsInfo myIntentionsInfo;
    private volatile boolean myShowBulb;
    private volatile boolean myHasToRecreate;

    @NotNull
    public static List<HighlightInfo.IntentionActionDescriptor> getAvailableFixes(@NotNull Editor editor, @NotNull PsiFile file2, int passId) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getAvailableFixes"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getAvailableFixes"));
        }
        int offset = ((EditorEx)editor).getExpectedCaretOffset();
        Project project2 = file2.getProject();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(editor.getDocument(), project2, HighlightSeverity.INFORMATION, offset, true, (Processor<HighlightInfo>)new CommonProcessors.CollectProcessor(infos));
        ArrayList<HighlightInfo.IntentionActionDescriptor> result2 = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        infos.forEach(info -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "lambda$getAvailableFixes$0"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "lambda$getAvailableFixes$0"));
            }
            ShowIntentionsPass.addAvailableFixesForGroups(info, editor, file2, result2, passId, offset);
        });
        ArrayList<HighlightInfo.IntentionActionDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getAvailableFixes"));
        }
        return arrayList;
    }

    private static void addAvailableFixesForGroups(@NotNull HighlightInfo info, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull List<HighlightInfo.IntentionActionDescriptor> outList, int group, int offset) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "addAvailableFixesForGroups"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "addAvailableFixesForGroups"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "addAvailableFixesForGroups"));
        }
        if (outList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outList", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "addAvailableFixesForGroups"));
        }
        if (info.quickFixActionMarkers == null) {
            return;
        }
        if (group != -1 && group != info.getGroup()) {
            return;
        }
        boolean fixRangeIsNotEmpty = !info.getFixTextRange().isEmpty();
        Editor injectedEditor = null;
        PsiFile injectedFile = null;
        for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
            PsiFile fileToUse;
            Editor editorToUse;
            HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
            RangeMarker range = (RangeMarker)pair.second;
            if (!range.isValid() || fixRangeIsNotEmpty && ShowIntentionsPass.isEmpty((Segment)range) || DumbService.isDumb((Project)file2.getProject()) && !DumbService.isDumbAware((Object)actionInGroup.getAction())) continue;
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            Project project2 = file2.getProject();
            if (start > offset || offset > end) continue;
            if (info.isFromInjection()) {
                if (injectedEditor == null) {
                    injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
                    injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
                }
                editorToUse = injectedEditor;
                fileToUse = injectedFile;
            } else {
                editorToUse = editor;
                fileToUse = file2;
            }
            if (!actionInGroup.getAction().isAvailable(project2, editorToUse, fileToUse)) continue;
            outList.add(actionInGroup);
        }
    }

    private static boolean isEmpty(@NotNull Segment segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "isEmpty"));
        }
        return segment.getEndOffset() <= segment.getStartOffset();
    }

    ShowIntentionsPass(@NotNull Project project2, @NotNull Editor editor, int passId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "<init>"));
        }
        super(project2, editor.getDocument(), false);
        this.myIntentionsInfo = new IntentionsInfo();
        this.myPassIdToShowIntentionsFor = passId;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        this.myFile = documentManager.getPsiFile(this.myEditor.getDocument());
        assert (this.myFile != null) : FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "doCollectInformation"));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (state != null && !state.isFinished()) {
            return;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        this.getIntentionActionsToShow();
        this.updateActions(codeAnalyzer);
    }

    @Override
    public void doApplyInformationToEditor() {
        Point xy;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        LogicalPosition caretPos = this.myEditor.getCaretModel().getLogicalPosition();
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        if (!visibleArea.contains(xy = this.myEditor.logicalPositionToXY(caretPos))) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (this.myShowBulb && (state == null || state.isFinished()) && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(false)) {
            DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
            codeAnalyzer.setLastIntentionHint(this.myProject, this.myFile, this.myEditor, this.myIntentionsInfo, this.myHasToRecreate);
        }
    }

    private void getIntentionActionsToShow() {
        ShowIntentionsPass.getActionsToShow(this.myEditor, this.myFile, this.myIntentionsInfo, this.myPassIdToShowIntentionsFor);
        if (this.myIntentionsInfo.isEmpty()) {
            return;
        }
        this.myShowBulb = !this.myIntentionsInfo.guttersToShow.isEmpty() || !this.myIntentionsInfo.notificationActionsToShow.isEmpty() || ContainerUtil.exists((Iterable)ContainerUtil.concat((List[])new List[]{this.myIntentionsInfo.errorFixesToShow, this.myIntentionsInfo.inspectionFixesToShow, this.myIntentionsInfo.intentionsToShow}), descriptor -> IntentionManagerSettings.getInstance().isShowLightBulb(descriptor.getAction()));
    }

    private static boolean appendCleanupCode(@NotNull List<HighlightInfo.IntentionActionDescriptor> actionDescriptors, @NotNull PsiFile file2) {
        if (actionDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionDescriptors", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "appendCleanupCode"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "appendCleanupCode"));
        }
        for (HighlightInfo.IntentionActionDescriptor descriptor : actionDescriptors) {
            if (!descriptor.canCleanup((PsiElement)file2)) continue;
            ArrayList<IntentionAction> options = new ArrayList<IntentionAction>();
            options.add(EditCleanupProfileIntentionAction.INSTANCE);
            options.add(CleanupOnScopeIntention.INSTANCE);
            actionDescriptors.add(new HighlightInfo.IntentionActionDescriptor(CleanupAllIntention.INSTANCE, options, "Code Cleanup Options"));
            return true;
        }
        return false;
    }

    private void updateActions(@NotNull DaemonCodeAnalyzerImpl codeAnalyzer) {
        if (codeAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeAnalyzer", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "updateActions"));
        }
        IntentionHintComponent hintComponent = codeAnalyzer.getLastIntentionHint();
        if (!this.myShowBulb || hintComponent == null || !hintComponent.isForEditor(this.myEditor)) {
            return;
        }
        IntentionHintComponent.PopupUpdateResult result2 = hintComponent.updateActions(this.myIntentionsInfo);
        if (result2 != IntentionHintComponent.PopupUpdateResult.HIDE_AND_RECREATE && result2 == IntentionHintComponent.PopupUpdateResult.CHANGED_INVISIBLE) {
            this.myHasToRecreate = true;
        }
    }

    public static void getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions, int passIdToShowIntentionsFor) {
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostEditor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getActionsToShow"));
        }
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getActionsToShow"));
        }
        if (intentions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "getActionsToShow"));
        }
        PsiElement psiElement = hostFile.findElementAt(hostEditor.getCaretModel().getOffset());
        LOG.assertTrue(psiElement == null || psiElement.isValid(), (Object)psiElement);
        int offset = hostEditor.getCaretModel().getOffset();
        Project project2 = hostFile.getProject();
        List<HighlightInfo.IntentionActionDescriptor> fixes = ShowIntentionsPass.getAvailableFixes(hostEditor, hostFile, passIdToShowIntentionsFor);
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project2);
        Document hostDocument = hostEditor.getDocument();
        HighlightInfo infoAtCursor = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(hostDocument, offset, true);
        if (infoAtCursor == null) {
            intentions.errorFixesToShow.addAll(fixes);
        } else {
            boolean isError = infoAtCursor.getSeverity() == HighlightSeverity.ERROR;
            for (HighlightInfo.IntentionActionDescriptor fix : fixes) {
                if (fix.isError() && isError) {
                    intentions.errorFixesToShow.add(fix);
                    continue;
                }
                intentions.inspectionFixesToShow.add(fix);
            }
        }
        for (IntentionAction action : IntentionManager.getInstance().getAvailableIntentionActions()) {
            Pair<PsiFile, Editor> place = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, (PairProcessor<PsiFile, Editor>)((PairProcessor)(psiFile, editor) -> ShowIntentionActionsHandler.availableFor(psiFile, editor, action)));
            if (place == null) continue;
            ArrayList<IntentionAction> enableDisableIntentionAction = new ArrayList<IntentionAction>();
            enableDisableIntentionAction.add(new IntentionHintComponent.EnableDisableIntentionAction(action));
            enableDisableIntentionAction.add(new IntentionHintComponent.EditIntentionSettingsAction(action));
            HighlightInfo.IntentionActionDescriptor descriptor = new HighlightInfo.IntentionActionDescriptor(action, enableDisableIntentionAction, null);
            if (fixes.contains(descriptor)) continue;
            intentions.intentionsToShow.add(descriptor);
        }
        if (HighlightingLevelManager.getInstance(project2).shouldInspect((PsiElement)hostFile)) {
            PsiElement prev;
            PsiElement intentionElement = psiElement;
            int intentionOffset = offset;
            if (psiElement instanceof PsiWhiteSpace && offset == psiElement.getTextRange().getStartOffset() && offset > 0 && (prev = hostFile.findElementAt(offset - 1)) != null && prev.isValid()) {
                intentionElement = prev;
                intentionOffset = offset - 1;
            }
            if (intentionElement != null && intentionElement.getManager().isInProject(intentionElement)) {
                ShowIntentionsPass.collectIntentionsFromDoNotShowLeveledInspections(project2, hostFile, intentionElement, intentionOffset, intentions);
            }
        }
        int line = hostDocument.getLineNumber(offset);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(hostDocument, project2, true);
        ArrayList<RangeHighlighterEx> result2 = new ArrayList<RangeHighlighterEx>();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        model.processRangeHighlightersOverlappingWith(hostDocument.getLineStartOffset(line), hostDocument.getLineEndOffset(line), (Processor<? super RangeHighlighterEx>)processor2);
        GutterIntentionAction.addActions(hostEditor, intentions, project2, result2);
        boolean cleanup = ShowIntentionsPass.appendCleanupCode(intentions.inspectionFixesToShow, hostFile);
        if (!cleanup) {
            ShowIntentionsPass.appendCleanupCode(intentions.errorFixesToShow, hostFile);
        }
        EditorNotificationActions.collectDescriptorsForEditor(hostEditor, intentions.notificationActionsToShow);
        intentions.filterActions(hostFile);
    }

    private static void collectIntentionsFromDoNotShowLeveledInspections(@NotNull Project project2, @NotNull PsiFile hostFile, PsiElement psiElement, final int offset, final @NotNull IntentionsInfo intentions) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "collectIntentionsFromDoNotShowLeveledInspections"));
        }
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "collectIntentionsFromDoNotShowLeveledInspections"));
        }
        if (intentions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "collectIntentionsFromDoNotShowLeveledInspections"));
        }
        if (psiElement != null) {
            InspectionToolWrapper[] tools;
            if (!psiElement.isPhysical()) {
                VirtualFile virtualFile = hostFile.getVirtualFile();
                String text = hostFile.getText();
                LOG.error("not physical: '" + psiElement.getText() + "' @" + offset + psiElement.getTextRange() + " elem:" + psiElement + " (" + psiElement.getClass().getName() + ") in:" + psiElement.getContainingFile() + " host:" + hostFile + "(" + hostFile.getClass().getName() + ")", new Attachment[]{new Attachment(virtualFile != null ? virtualFile.getPresentableUrl() : "null", text != null ? text : "null")});
            }
            if (DumbService.isDumb((Project)project2)) {
                return;
            }
            ArrayList<LocalInspectionToolWrapper> intentionTools = new ArrayList<LocalInspectionToolWrapper>();
            InspectionProfile profile2 = InspectionProjectProfileManager.getInstance(project2).getInspectionProfile();
            for (InspectionToolWrapper toolWrapper2 : tools = profile2.getInspectionTools((PsiElement)hostFile)) {
                HighlightDisplayKey key2;
                if (!(toolWrapper2 instanceof LocalInspectionToolWrapper) || ((LocalInspectionToolWrapper)toolWrapper2).isUnfair() || !profile2.isToolEnabled(key2 = HighlightDisplayKey.find((String)toolWrapper2.getShortName()), (PsiElement)hostFile) || !HighlightDisplayLevel.DO_NOT_SHOW.equals(profile2.getErrorLevel(key2, (PsiElement)hostFile))) continue;
                intentionTools.add((LocalInspectionToolWrapper)toolWrapper2);
            }
            if (!intentionTools.isEmpty()) {
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                for (PsiElement el = psiElement; el != null; el = el.getParent()) {
                    elements.add(el);
                    if (el instanceof PsiFile) break;
                }
                Set<String> dialectIds = InspectionEngine.calcElementDialectIds(elements);
                LocalInspectionToolSession session2 = new LocalInspectionToolSession(hostFile, 0, hostFile.getTextLength());
                Processor processor2 = toolWrapper -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "lambda$collectIntentionsFromDoNotShowLeveledInspections$3"));
                    }
                    if (hostFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "lambda$collectIntentionsFromDoNotShowLeveledInspections$3"));
                    }
                    if (intentions == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass", "lambda$collectIntentionsFromDoNotShowLeveledInspections$3"));
                    }
                    LocalInspectionTool localInspectionTool = (LocalInspectionTool)toolWrapper.getTool();
                    final HighlightDisplayKey key2 = HighlightDisplayKey.find((String)toolWrapper.getShortName());
                    final String displayName = toolWrapper.getDisplayName();
                    ProblemsHolder holder = new ProblemsHolder(InspectionManager.getInstance((Project)project2), hostFile, true){

                        public void registerProblem(@NotNull ProblemDescriptor problemDescriptor) {
                            QuickFix[] fixes;
                            TextRange range;
                            if (problemDescriptor == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$1", "registerProblem"));
                            }
                            super.registerProblem(problemDescriptor);
                            if (problemDescriptor instanceof ProblemDescriptorBase && (range = ((ProblemDescriptorBase)problemDescriptor).getTextRange()) != null && range.contains(offset) && (fixes = problemDescriptor.getFixes()) != null) {
                                for (int k = 0; k < fixes.length; ++k) {
                                    IntentionAction intentionAction = QuickFixWrapper.wrap(problemDescriptor, k);
                                    HighlightInfo.IntentionActionDescriptor actionDescriptor = new HighlightInfo.IntentionActionDescriptor(intentionAction, null, displayName, null, key2, null, HighlightSeverity.INFORMATION);
                                    intentions.intentionsToShow.add(actionDescriptor);
                                }
                            }
                        }
                    };
                    InspectionEngine.createVisitorAndAcceptElements(localInspectionTool, holder, true, session2, elements, dialectIds, InspectionEngine.getDialectIdsSpecifiedForTool(toolWrapper));
                    localInspectionTool.inspectionFinished(session2, holder);
                    return true;
                };
                JobLauncher.getInstance().invokeConcurrentlyUnderProgress(intentionTools, new DaemonProgressIndicator(), false, processor2);
            }
        }
    }

    public static class IntentionsInfo {
        public final List<HighlightInfo.IntentionActionDescriptor> intentionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> errorFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> inspectionFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> guttersToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> notificationActionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();

        void filterActions(@Nullable PsiFile psiFile) {
            IntentionActionFilter[] filters = (IntentionActionFilter[])IntentionActionFilter.EXTENSION_POINT_NAME.getExtensions();
            IntentionsInfo.filter(this.intentionsToShow, psiFile, filters);
            IntentionsInfo.filter(this.errorFixesToShow, psiFile, filters);
            IntentionsInfo.filter(this.inspectionFixesToShow, psiFile, filters);
            IntentionsInfo.filter(this.guttersToShow, psiFile, filters);
            IntentionsInfo.filter(this.notificationActionsToShow, psiFile, filters);
        }

        private static void filter(@NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @Nullable PsiFile psiFile, @NotNull IntentionActionFilter[] filters) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo", "filter"));
            }
            if (filters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo", "filter"));
            }
            Iterator<HighlightInfo.IntentionActionDescriptor> it = descriptors.iterator();
            block0: while (it.hasNext()) {
                HighlightInfo.IntentionActionDescriptor actionDescriptor = it.next();
                for (IntentionActionFilter filter : filters) {
                    if (filter.accept(actionDescriptor.getAction(), psiFile)) continue;
                    it.remove();
                    continue block0;
                }
            }
        }

        public boolean isEmpty() {
            return this.intentionsToShow.isEmpty() && this.errorFixesToShow.isEmpty() && this.inspectionFixesToShow.isEmpty() && this.guttersToShow.isEmpty() && this.notificationActionsToShow.isEmpty();
        }

        @NonNls
        public String toString() {
            return "Errors: " + this.errorFixesToShow + "; Inspection fixes: " + this.inspectionFixesToShow + "; Intentions: " + this.intentionsToShow + "; Gutters: " + this.guttersToShow + "Notifications: " + this.notificationActionsToShow;
        }
    }
}

