/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.ModuleHighlightUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.OutboundSemiGraph;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleGraphUtil {
    private JavaModuleGraphUtil() {
    }

    @Nullable
    public static PsiJavaModule findDescriptorByElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "findDescriptorByElement"));
        }
        PsiFileSystemItem fsItem = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        return fsItem != null ? ModuleHighlightUtil.getModuleDescriptor(fsItem) : null;
    }

    @Nullable
    public static PsiJavaModule findDescriptorByModule(@Nullable Module module2) {
        return ModuleHighlightUtil.getModuleDescriptor(module2);
    }

    @Nullable
    public static Collection<PsiJavaModule> findCycle(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "findCycle"));
        }
        Project project2 = module2.getProject();
        List cycles = (List)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> CachedValueProvider.Result.create(JavaModuleGraphUtil.findCycles(project2), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        return (Collection)ContainerUtil.find((Iterable)cycles, set2 -> {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "lambda$findCycle$1"));
            }
            return set2.contains(module2);
        });
    }

    public static boolean exports(@NotNull PsiJavaModule source, @NotNull String packageName, @NotNull PsiJavaModule target) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exports"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exports"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exports"));
        }
        Map exports = (Map)CachedValuesManager.getCachedValue((PsiElement)source, () -> {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "lambda$exports$2"));
            }
            return CachedValueProvider.Result.create(JavaModuleGraphUtil.exportsMap(source), (Object[])new Object[]{source.getContainingFile()});
        });
        Set targets = (Set)exports.get(packageName);
        return targets != null && (targets.isEmpty() || targets.contains(target.getModuleName()));
    }

    public static boolean reads(@NotNull PsiJavaModule source, @NotNull PsiJavaModule destination) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "reads"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "reads"));
        }
        Project project2 = source.getProject();
        RequiresGraph graph = (RequiresGraph)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> CachedValueProvider.Result.create((Object)JavaModuleGraphUtil.buildRequiresGraph(project2), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        return graph.reads(source, destination);
    }

    private static List<Set<PsiJavaModule>> findCycles(Project project2) {
        HashSet projectModules = ContainerUtil.newHashSet();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            Collection<VirtualFile> files = FilenameIndex.getVirtualFilesByName(project2, "module-info.java", module2.getModuleScope(false));
            if (files.size() > 1) {
                return Collections.emptyList();
            }
            Optional.ofNullable(ContainerUtil.getFirstItem(files)).map(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)project2)).findFile(arg_0)).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).ifPresent(projectModules::add);
        }
        if (!projectModules.isEmpty()) {
            ChameleonGraph graph;
            DFSTBuilder builder;
            Collection components;
            MultiMap relations = MultiMap.create();
            for (PsiJavaModule module3 : projectModules) {
                for (PsiRequiresStatement statement2 : module3.getRequires()) {
                    PsiJavaModule dependency = PsiJavaModuleReference.resolve((PsiElement)statement2, statement2.getModuleName(), true);
                    if (dependency == null || !projectModules.contains(dependency)) continue;
                    relations.putValue((Object)module3, (Object)dependency);
                }
            }
            if (!relations.isEmpty() && !(components = (builder = new DFSTBuilder(graph = new ChameleonGraph(relations, false))).getComponents()).isEmpty()) {
                return components.stream().map(ContainerUtil::newLinkedHashSet).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static Map<String, Set<String>> exportsMap(@NotNull PsiJavaModule source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exportsMap"));
        }
        HashMap map = ContainerUtil.newHashMap();
        for (PsiExportsStatement statement2 : source.getExports()) {
            String pkg = statement2.getPackageName();
            List targets = statement2.getModuleNames();
            map.put(pkg, targets.isEmpty() ? Collections.emptySet() : ContainerUtil.newTroveSet((Collection)targets));
        }
        return map;
    }

    private static RequiresGraph buildRequiresGraph(Project project2) {
        MultiMap relations = MultiMap.create();
        THashSet publicEdges = ContainerUtil.newTroveSet();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            Collection<VirtualFile> files = FilenameIndex.getVirtualFilesByName(project2, "module-info.java", module2.getModuleScope(false));
            Optional.ofNullable(ContainerUtil.getFirstItem(files)).map(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)project2)).findFile(arg_0)).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).ifPresent(arg_0 -> JavaModuleGraphUtil.lambda$buildRequiresGraph$6(relations, (Set)publicEdges, arg_0));
        }
        Graph graph = GraphGenerator.generate(new ChameleonGraph(relations, true));
        return new RequiresGraph((OutboundSemiGraph<PsiJavaModule>)graph, (Set<String>)publicEdges);
    }

    private static void visit(PsiJavaModule module2, MultiMap<PsiJavaModule, PsiJavaModule> relations, Set<String> publicEdges) {
        if (!relations.containsKey((Object)module2)) {
            relations.putValues((Object)module2, Collections.emptyList());
            for (PsiRequiresStatement statement2 : module2.getRequires()) {
                for (PsiJavaModule dependency : PsiJavaModuleReference.multiResolve((PsiElement)statement2, statement2.getModuleName(), false)) {
                    relations.putValue((Object)module2, (Object)dependency);
                    if (statement2.isPublic()) {
                        publicEdges.add(RequiresGraph.key(dependency, module2));
                    }
                    JavaModuleGraphUtil.visit(dependency, relations, publicEdges);
                }
            }
        }
    }

    private static /* synthetic */ void lambda$buildRequiresGraph$6(MultiMap relations, Set publicEdges, PsiJavaModule m) {
        JavaModuleGraphUtil.visit(m, (MultiMap<PsiJavaModule, PsiJavaModule>)relations, publicEdges);
    }

    private static class ChameleonGraph<N>
    implements Graph<N> {
        private final Set<N> myNodes = new THashSet();
        private final MultiMap<N, N> myEdges;
        private final boolean myInbound;

        public ChameleonGraph(MultiMap<N, N> edges, boolean inbound) {
            edges.entrySet().forEach(e -> {
                this.myNodes.add(e.getKey());
                this.myNodes.addAll((Collection)e.getValue());
            });
            this.myEdges = edges;
            this.myInbound = inbound;
        }

        public Collection<N> getNodes() {
            return this.myNodes;
        }

        public Iterator<N> getIn(N n) {
            return this.myInbound ? this.myEdges.get(n).iterator() : Collections.emptyIterator();
        }

        public Iterator<N> getOut(N n) {
            return this.myInbound ? Collections.emptyIterator() : this.myEdges.get(n).iterator();
        }
    }

    private static class RequiresGraph {
        private final OutboundSemiGraph<PsiJavaModule> myGraph;
        private final Set<String> myPublicEdges;

        public RequiresGraph(OutboundSemiGraph<PsiJavaModule> graph, Set<String> publicEdges) {
            this.myGraph = graph;
            this.myPublicEdges = publicEdges;
        }

        public boolean reads(PsiJavaModule source, PsiJavaModule destination) {
            Collection nodes = this.myGraph.getNodes();
            if (nodes.contains(destination) && nodes.contains(source)) {
                Iterator directReaders = this.myGraph.getOut((Object)destination);
                while (directReaders.hasNext()) {
                    PsiJavaModule next = (PsiJavaModule)directReaders.next();
                    if (!source.equals(next) && (!this.myPublicEdges.contains(RequiresGraph.key(destination, next)) || !this.reads(source, next))) continue;
                    return true;
                }
            }
            return false;
        }

        public static String key(PsiJavaModule module2, PsiJavaModule exporter) {
            return module2.getModuleName() + '/' + exporter.getModuleName();
        }
    }
}

