/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiredModuleFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GoToSymbolFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ModuleHighlightUtil {
    @Nullable
    static PsiJavaModule getModuleDescriptor(@NotNull PsiFileSystemItem fsItem) {
        if (fsItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fsItem", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "getModuleDescriptor"));
        }
        VirtualFile file2 = fsItem.getVirtualFile();
        if (file2 == null) {
            return null;
        }
        Project project2 = fsItem.getProject();
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project2);
        if (index.isInLibraryClasses(file2)) {
            VirtualFile classRoot = index.getClassRootForFile(file2);
            if (classRoot != null) {
                VirtualFile descriptorFile = classRoot.findChild("module-info.class");
                if (descriptorFile == null) {
                    descriptorFile = classRoot.findFileByRelativePath("META-INF/versions/9/module-info.class");
                }
                if (descriptorFile != null) {
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(descriptorFile);
                    if (psiFile instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile).getModuleDeclaration();
                    }
                } else if (classRoot.getFileSystem() instanceof JarFileSystem && "jar".equalsIgnoreCase(classRoot.getExtension())) {
                    return LightJavaModule.getModule(PsiManager.getInstance((Project)project2), classRoot);
                }
            }
            return null;
        }
        return ModuleHighlightUtil.getModuleDescriptor(index.getModuleForFile(file2));
    }

    static PsiJavaModule getModuleDescriptor(Module module2) {
        return Optional.ofNullable(module2).map(m -> FilenameIndex.getVirtualFilesByName(module2.getProject(), "module-info.java", m.getModuleScope(false))).map(c -> c.size() == 1 ? (VirtualFile)c.iterator().next() : null).map(f -> PsiManager.getInstance((Project)module2.getProject()).findFile(f)).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).orElse(null);
    }

    @Nullable
    static HighlightInfo checkFileName(@NotNull PsiJavaModule element, @NotNull PsiFile file2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileName"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileName"));
        }
        if (!"module-info.java".equals(file2.getName())) {
            String message = JavaErrorMessages.message("module.file.wrong.name", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).description(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createRenameFileFix("module-info.java"));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileDuplicates(@NotNull PsiJavaModule element, @NotNull PsiFile file2) {
        Project project2;
        Collection<VirtualFile> others;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileDuplicates"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileDuplicates"));
        }
        Module module2 = ModuleHighlightUtil.findModule((PsiElement)file2);
        if (module2 != null && (others = FilenameIndex.getVirtualFilesByName(project2 = file2.getProject(), "module-info.java", module2.getModuleScope(false))).size() > 1) {
            String message = JavaErrorMessages.message("module.file.duplicate", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).description(message).create();
            others.stream().map(f -> PsiManager.getInstance((Project)project2).findFile(f)).filter(f -> {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "lambda$checkFileDuplicates$5"));
                }
                return f != file2;
            }).findFirst().ifPresent(duplicate -> QuickFixAction.registerQuickFixAction(info, new GoToSymbolFix((NavigatablePsiElement)duplicate, JavaErrorMessages.message("module.open.duplicate.text", new Object[0]))));
            return info;
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkDuplicateStatements(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkDuplicateStatements"));
        }
        List results = ContainerUtil.newSmartList();
        ModuleHighlightUtil.checkDuplicateRefs(module2.getRequires(), st -> Optional.ofNullable(st.getReferenceElement()).map(PsiJavaModuleReferenceElement::getReferenceText), "module.duplicate.requires", results);
        ModuleHighlightUtil.checkDuplicateRefs(module2.getExports(), st -> Optional.ofNullable(st.getPackageReference()).map(ModuleHighlightUtil::refText), "module.duplicate.export", results);
        ModuleHighlightUtil.checkDuplicateRefs(SyntaxTraverser.psiTraverser().children((Object)module2).filter(PsiUsesStatement.class), st -> Optional.ofNullable(st.getClassReference()).map(ModuleHighlightUtil::refText), "module.duplicate.uses", results);
        ModuleHighlightUtil.checkDuplicateRefs(SyntaxTraverser.psiTraverser().children((Object)module2).filter(PsiProvidesStatement.class), st -> Optional.of(Pair.pair((Object)st.getInterfaceReference(), (Object)st.getImplementationReference())).map(p -> p.first != null && p.second != null ? ModuleHighlightUtil.refText((PsiJavaCodeReferenceElement)p.first) + " / " + ModuleHighlightUtil.refText((PsiJavaCodeReferenceElement)p.second) : null), "module.duplicate.provides", results);
        List list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkDuplicateStatements"));
        }
        return list;
    }

    private static <T extends PsiElement> void checkDuplicateRefs(Iterable<T> statements, Function<T, Optional<String>> ref, @PropertyKey(resourceBundle="messages.JavaErrorMessages") String key2, List<HighlightInfo> results) {
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiElement statement2 : statements) {
            String refText = ref.apply(statement2).orElse(null);
            if (refText == null || filter.add(refText)) continue;
            String message = JavaErrorMessages.message(key2, refText);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement2).description(message).create();
            QuickFixAction.registerQuickFixAction(info, new DeleteElementFix(statement2));
            results.add(info);
        }
    }

    @NotNull
    static List<HighlightInfo> checkUnusedServices(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkUnusedServices"));
        }
        List results = ContainerUtil.newSmartList();
        THashSet exports = ContainerUtil.newTroveSet();
        THashSet uses = ContainerUtil.newTroveSet();
        for (PsiElement child : SyntaxTraverser.psiTraverser().children((Object)module2)) {
            PsiJavaCodeReferenceElement ref;
            if (child instanceof PsiExportsStatement) {
                ref = ((PsiExportsStatement)child).getPackageReference();
                if (ref == null) continue;
                exports.add(ModuleHighlightUtil.refText(ref));
                continue;
            }
            if (!(child instanceof PsiUsesStatement) || (ref = ((PsiUsesStatement)child).getClassReference()) == null) continue;
            uses.add(ModuleHighlightUtil.refText(ref));
        }
        Module host = ModuleHighlightUtil.findModule((PsiElement)module2);
        for (PsiProvidesStatement statement2 : SyntaxTraverser.psiTraverser().children((Object)module2).filter(PsiProvidesStatement.class)) {
            String className;
            String packageName;
            PsiElement target;
            PsiJavaCodeReferenceElement ref = statement2.getInterfaceReference();
            if (ref == null || !((target = ref.resolve()) instanceof PsiClass) || ModuleHighlightUtil.findModule(target) != host || exports.contains(packageName = StringUtil.getPackageName((String)(className = ModuleHighlightUtil.refText(ref)))) || uses.contains(className)) continue;
            String message = JavaErrorMessages.message("module.service.unused", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(ref)).description(message).create());
        }
        List list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkUnusedServices"));
        }
        return list;
    }

    private static String refText(PsiJavaCodeReferenceElement ref) {
        return PsiNameHelper.getQualifiedClassName((String)ref.getText(), (boolean)true);
    }

    @Nullable
    static HighlightInfo checkFileLocation(@NotNull PsiJavaModule element, @NotNull PsiFile file2) {
        VirtualFile root;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileLocation"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileLocation"));
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile != null && (root = ProjectFileIndex.SERVICE.getInstance((Project)file2.getProject()).getSourceRootForFile(vFile)) != null && !root.equals(vFile.getParent())) {
            String message = JavaErrorMessages.message("module.file.wrong.location", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(element)).description(message).create();
            QuickFixAction.registerQuickFixAction(info, new MoveFileFix(vFile, root, QuickFixBundle.message("move.file.to.source.root.text", new Object[0])));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkModuleReference(@Nullable PsiJavaModuleReferenceElement refElement, @NotNull PsiJavaModule container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkModuleReference"));
        }
        if (refElement != null) {
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : refElement.getParent();
            PsiElement target = ref.resolve();
            if (!(target instanceof PsiJavaModule)) {
                return ModuleHighlightUtil.moduleResolveError(refElement, ref);
            }
            if (target == container) {
                String message = JavaErrorMessages.message("module.cyclic.dependence", container.getModuleName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)refElement).description(message).create();
            }
            Collection<PsiJavaModule> cycle = JavaModuleGraphUtil.findCycle((PsiJavaModule)target);
            if (cycle != null && cycle.contains(container)) {
                Stream<String> stream = cycle.stream().map(PsiJavaModule::getModuleName);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    stream = stream.sorted();
                }
                String message = JavaErrorMessages.message("module.cyclic.dependence", stream.collect(Collectors.joining(", ")));
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)refElement).description(message).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        Module module2;
        PsiElement target;
        if (refElement != null && (target = refElement.resolve()) instanceof PsiPackage && (module2 = ModuleHighlightUtil.findModule((PsiElement)refElement)) != null) {
            String packageName = ((PsiPackage)target).getQualifiedName();
            PsiDirectory[] directories = ((PsiPackage)target).getDirectories(module2.getModuleScope(false));
            if (directories.length == 0) {
                String message = JavaErrorMessages.message("package.not.found", packageName);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)refElement).description(message).create();
            }
            if (PsiUtil.isPackageEmpty((PsiDirectory[])directories, (String)packageName)) {
                String message = JavaErrorMessages.message("package.is.empty", packageName);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)refElement).description(message).create();
            }
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkExportTargets(@NotNull PsiExportsStatement statement2, @NotNull PsiJavaModule container) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkExportTargets"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkExportTargets"));
        }
        List results = ContainerUtil.newSmartList();
        THashSet targets = ContainerUtil.newTroveSet();
        for (PsiJavaModuleReferenceElement refElement : statement2.getModuleReferences()) {
            String refText = refElement.getReferenceText();
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : statement2;
            PsiElement target = ref.resolve();
            if (!(target instanceof PsiJavaModule)) {
                results.add(ModuleHighlightUtil.moduleResolveError(refElement, ref));
                continue;
            }
            if (targets.add(refText)) continue;
            String message = JavaErrorMessages.message("module.duplicate.export", refText);
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)refElement).description(message).create());
        }
        List list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkExportTargets"));
        }
        return list;
    }

    @Nullable
    static HighlightInfo checkServiceReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        PsiElement target;
        if (refElement != null && (target = refElement.resolve()) instanceof PsiClass && ((PsiClass)target).isEnum()) {
            String message = JavaErrorMessages.message("module.service.enum", ((PsiClass)target).getName());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).description(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkServiceImplementation(@Nullable PsiJavaCodeReferenceElement implRef, @Nullable PsiJavaCodeReferenceElement intRef) {
        if (implRef != null && intRef != null) {
            PsiElement implTarget = implRef.resolve();
            PsiElement intTarget = intRef.resolve();
            if (implTarget instanceof PsiClass && intTarget instanceof PsiClass) {
                PsiClass implClass = (PsiClass)implTarget;
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)implClass, (PsiClass)((PsiClass)intTarget), (boolean)true)) {
                    String message = JavaErrorMessages.message("module.service.subtype", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create();
                }
                if (implClass.hasModifierProperty("abstract")) {
                    String message = JavaErrorMessages.message("module.service.abstract", implClass.getName());
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create();
                }
                Object[] constructors = implClass.getConstructors();
                if (constructors.length > 0) {
                    PsiMethod constructor = (PsiMethod)JBIterable.of((Object[])constructors).find(c -> c.getParameterList().getParametersCount() == 0);
                    if (constructor == null) {
                        String message = JavaErrorMessages.message("module.service.no.ctor", implClass.getName());
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create();
                    }
                    if (!constructor.hasModifierProperty("public")) {
                        String message = JavaErrorMessages.message("module.service.hidden.ctor", implClass.getName());
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create();
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageAccessibility(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiElement target, @NotNull PsiJavaModule refModule) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessibility"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessibility"));
        }
        if (refModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refModule", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessibility"));
        }
        Module module2 = ModuleHighlightUtil.findModule((PsiElement)refModule);
        if (module2 != null) {
            PsiDirectory[] dirs;
            PsiElement refImport;
            if (target instanceof PsiClass) {
                PsiElement targetFile = target.getParent();
                if (targetFile instanceof PsiClassOwner) {
                    PsiJavaModule targetModule = ModuleHighlightUtil.getModuleDescriptor((PsiFileSystemItem)targetFile);
                    String packageName = ((PsiClassOwner)targetFile).getPackageName();
                    return ModuleHighlightUtil.checkPackageAccessibility(ref, refModule, targetModule, packageName);
                }
            } else if (target instanceof PsiPackage && (refImport = ref.getParent()) instanceof PsiImportStatementBase && ((PsiImportStatementBase)refImport).isOnDemand() && (dirs = ((PsiPackage)target).getDirectories(module2.getModuleWithDependenciesAndLibrariesScope(false))).length == 1) {
                PsiJavaModule targetModule = ModuleHighlightUtil.getModuleDescriptor((PsiFileSystemItem)dirs[0]);
                String packageName = ((PsiPackage)target).getQualifiedName();
                return ModuleHighlightUtil.checkPackageAccessibility(ref, refModule, targetModule, packageName);
            }
        }
        return null;
    }

    private static HighlightInfo checkPackageAccessibility(PsiJavaCodeReferenceElement ref, PsiJavaModule refModule, PsiJavaModule targetModule, String packageName) {
        if (!refModule.equals(targetModule)) {
            if (targetModule == null) {
                String message = JavaErrorMessages.message("module.package.on.classpath", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)ref).description(message).create();
            }
            String refModuleName = refModule.getModuleName();
            String requiredName = targetModule.getModuleName();
            if (!(targetModule instanceof LightJavaModule) && !JavaModuleGraphUtil.exports(targetModule, packageName, refModule)) {
                String message = JavaErrorMessages.message("module.package.not.exported", requiredName, packageName, refModuleName);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)ref).description(message).create();
            }
            if (!"java.base".equals(requiredName) && !JavaModuleGraphUtil.reads(refModule, targetModule)) {
                String message = JavaErrorMessages.message("module.not.in.requirements", refModuleName, requiredName);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)ref).description(message).create();
                QuickFixAction.registerQuickFixAction(info, new AddRequiredModuleFix(refModule, requiredName));
                return info;
            }
        }
        return null;
    }

    private static Module findModule(PsiElement element) {
        return Optional.ofNullable(element.getContainingFile()).map(PsiFile::getVirtualFile).map(f -> ModuleUtilCore.findModuleForFile((VirtualFile)f, (Project)element.getProject())).orElse(null);
    }

    private static HighlightInfo moduleResolveError(PsiJavaModuleReferenceElement refElement, PsiPolyVariantReference ref) {
        if (ref.multiResolve(true).length == 0) {
            String message = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)refElement).description(message).create();
        }
        if (ref.multiResolve(false).length > 1) {
            String message = JavaErrorMessages.message("module.ambiguous", refElement.getReferenceText());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range((PsiElement)refElement).description(message).create();
        }
        String message = JavaErrorMessages.message("module.not.on.path", refElement.getReferenceText());
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)refElement).description(message).create();
        ModuleHighlightUtil.factory().registerOrderEntryFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info), (PsiReference)ref);
        return info;
    }

    private static QuickFixFactory factory() {
        return QuickFixFactory.getInstance();
    }

    private static TextRange range(PsiJavaModule module2) {
        PsiKeyword kw = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)module2, PsiKeyword.class);
        return new TextRange(kw != null ? kw.getTextOffset() : module2.getTextOffset(), module2.getNameElement().getTextRange().getEndOffset());
    }

    private static PsiElement range(PsiJavaCodeReferenceElement refElement) {
        return (PsiElement)ObjectUtils.notNull((Object)refElement.getReferenceNameElement(), (Object)refElement);
    }
}

