/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class InsertMethodCallFix
implements IntentionAction,
LowPriorityAction {
    private final PsiMethodCallExpression myCall;
    private final String myMethodName;

    public InsertMethodCallFix(PsiMethodCallExpression call, PsiMethod method2) {
        this.myCall = call;
        this.myMethodName = method2.getName();
    }

    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("insert.sam.method.call.fix.name", this.myMethodName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InsertMethodCallFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("insert.sam.method.call.fix.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InsertMethodCallFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InsertMethodCallFix", "isAvailable"));
        }
        return this.myCall.isValid() && PsiManager.getInstance((Project)project2).isInProject((PsiElement)this.myCall);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InsertMethodCallFix", "invoke"));
        }
        PsiReferenceExpression methodExpression = this.myCall.getMethodExpression();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String replacement = methodExpression.getText() + "." + this.myMethodName;
        methodExpression.replace((PsiElement)factory.createExpressionFromText(replacement, (PsiElement)methodExpression));
    }

    public boolean startInWriteAction() {
        return true;
    }
}

