/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PermuteArgumentsFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.PermuteArgumentsFix");
    private final PsiCall myCall;
    private final PsiCall myPermutation;

    private PermuteArgumentsFix(@NotNull PsiCall call, @NotNull PsiCall permutation) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix", "<init>"));
        }
        if (permutation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permutation", "com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix", "<init>"));
        }
        this.myCall = call;
        this.myPermutation = permutation;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("permute.arguments", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix", "isAvailable"));
        }
        return !project2.isDisposed() && this.myCall.isValid() && this.myCall.getManager().isInProject((PsiElement)this.myCall);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix", "invoke"));
        }
        this.myCall.getArgumentList().replace((PsiElement)this.myPermutation.getArgumentList());
    }

    public static void registerFix(HighlightInfo info, PsiCall callExpression, CandidateInfo[] candidates, TextRange fixRange) {
        PsiExpression[] expressions = callExpression.getArgumentList().getExpressions();
        if (expressions.length < 2) {
            return;
        }
        ArrayList<PsiCall> permutations = new ArrayList<PsiCall>();
        for (CandidateInfo candidate : candidates) {
            if (!(candidate instanceof MethodCandidateInfo)) continue;
            MethodCandidateInfo methodCandidate = (MethodCandidateInfo)candidate;
            PsiMethod method2 = methodCandidate.getElement();
            PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
            PsiParameter[] parameters = method2.getParameterList().getParameters();
            if (expressions.length != parameters.length || parameters.length == 0) continue;
            int minIncompatibleIndex = parameters.length;
            int maxIncompatibleIndex = 0;
            int incompatibilitiesCount = 0;
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                PsiParameter parameter = parameters[i2];
                PsiType type = substitutor.substitute(parameter.getType());
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)type, (PsiExpression)expressions[i2])) continue;
                if (minIncompatibleIndex == parameters.length) {
                    minIncompatibleIndex = i2;
                }
                maxIncompatibleIndex = i2;
                ++incompatibilitiesCount;
            }
            try {
                PermuteArgumentsFix.registerSwapFixes(expressions, callExpression, permutations, methodCandidate, incompatibilitiesCount, minIncompatibleIndex, maxIncompatibleIndex);
                PermuteArgumentsFix.registerShiftFixes(expressions, callExpression, permutations, methodCandidate, minIncompatibleIndex, maxIncompatibleIndex);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (permutations.size() == 1) {
            PermuteArgumentsFix fix = new PermuteArgumentsFix(callExpression, (PsiCall)permutations.get(0));
            QuickFixAction.registerQuickFixAction(info, fixRange, fix);
        }
    }

    private static void registerShiftFixes(PsiExpression[] expressions, PsiCall callExpression, List<PsiCall> permutations, MethodCandidateInfo methodCandidate, int minIncompatibleIndex, int maxIncompatibleIndex) throws IncorrectOperationException {
        PsiMethod method2 = methodCandidate.getElement();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        for (int i2 = 0; i2 <= minIncompatibleIndex; ++i2) {
            for (int j = Math.max(i2 + 2, maxIncompatibleIndex); j < expressions.length; ++j) {
                JavaResolveResult result2;
                PsiExpression[] copyExpressions;
                PsiCall copy;
                ArrayUtil.rotateLeft((Object[])expressions, (int)i2, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method2, (PsiSubstitutor)substitutor, (PsiExpression[])expressions)) {
                    copy = (PsiCall)callExpression.copy();
                    copyExpressions = copy.getArgumentList().getExpressions();
                    for (int k = i2; k < copyExpressions.length; ++k) {
                        copyExpressions[k].replace((PsiElement)expressions[k]);
                    }
                    result2 = copy.resolveMethodGenerics();
                    if (result2.getElement() != null && result2.isValidResult()) {
                        permutations.add(copy);
                        if (permutations.size() > 1) {
                            return;
                        }
                    }
                }
                ArrayUtil.rotateRight((Object[])expressions, (int)i2, (int)j);
                ArrayUtil.rotateRight((Object[])expressions, (int)i2, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method2, (PsiSubstitutor)substitutor, (PsiExpression[])expressions)) {
                    copy = (PsiCall)callExpression.copy();
                    copyExpressions = copy.getArgumentList().getExpressions();
                    for (int k = i2; k < copyExpressions.length; ++k) {
                        copyExpressions[k].replace((PsiElement)expressions[k]);
                    }
                    result2 = copy.resolveMethodGenerics();
                    if (result2.getElement() != null && result2.isValidResult()) {
                        permutations.add(copy);
                        if (permutations.size() > 1) {
                            return;
                        }
                    }
                }
                ArrayUtil.rotateLeft((Object[])expressions, (int)i2, (int)j);
            }
        }
    }

    private static void registerSwapFixes(PsiExpression[] expressions, PsiCall callExpression, List<PsiCall> permutations, MethodCandidateInfo candidate, int incompatibilitiesCount, int minIncompatibleIndex, int maxIncompatibleIndex) throws IncorrectOperationException {
        PsiMethod method2 = candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (incompatibilitiesCount >= 3) {
            return;
        }
        for (int i2 = minIncompatibleIndex; i2 < maxIncompatibleIndex; ++i2) {
            for (int j = i2 + 1; j <= maxIncompatibleIndex; ++j) {
                ArrayUtil.swap((Object[])expressions, (int)i2, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method2, (PsiSubstitutor)substitutor, (PsiExpression[])expressions)) {
                    PsiCall copy = (PsiCall)callExpression.copy();
                    PsiExpression[] copyExpressions = copy.getArgumentList().getExpressions();
                    copyExpressions[i2].replace((PsiElement)expressions[i2]);
                    copyExpressions[j].replace((PsiElement)expressions[j]);
                    JavaResolveResult result2 = copy.resolveMethodGenerics();
                    if (result2.getElement() != null && result2.isValidResult()) {
                        permutations.add(copy);
                        if (permutations.size() > 1) {
                            return;
                        }
                    }
                }
                ArrayUtil.swap((Object[])expressions, (int)i2, (int)j);
            }
        }
    }
}

